/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Mirror
extends IdentifiableBase
implements Serializable,
InputLocationTracker {
    final String mirrorOf;
    final String name;
    final String url;
    final String layout;
    final String mirrorOfLayouts;
    final boolean blocked;
    final Map<Object, InputLocation> locations;

    protected Mirror(Builder builder) {
        super(builder);
        String string = builder.mirrorOf != null ? builder.mirrorOf : (this.mirrorOf = builder.base != null ? builder.base.mirrorOf : null);
        String string2 = builder.name != null ? builder.name : (this.name = builder.base != null ? builder.base.name : null);
        String string3 = builder.url != null ? builder.url : (this.url = builder.base != null ? builder.base.url : null);
        String string4 = builder.layout != null ? builder.layout : (this.layout = builder.base != null ? builder.base.layout : null);
        String string5 = builder.mirrorOfLayouts != null ? builder.mirrorOfLayouts : (this.mirrorOfLayouts = builder.base != null ? builder.base.mirrorOfLayouts : null);
        this.blocked = builder.blocked != null ? builder.blocked : (builder.base != null ? builder.base.blocked : false);
        Map newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<Object, InputLocation> mutableLocations = new HashMap<Object, InputLocation>(((IdentifiableBase)this).locations);
        mutableLocations.put("mirrorOf", newlocs.containsKey("mirrorOf") ? (InputLocation)newlocs.get("mirrorOf") : (InputLocation)oldlocs.get("mirrorOf"));
        mutableLocations.put("name", newlocs.containsKey("name") ? (InputLocation)newlocs.get("name") : (InputLocation)oldlocs.get("name"));
        mutableLocations.put("url", newlocs.containsKey("url") ? (InputLocation)newlocs.get("url") : (InputLocation)oldlocs.get("url"));
        mutableLocations.put("layout", newlocs.containsKey("layout") ? (InputLocation)newlocs.get("layout") : (InputLocation)oldlocs.get("layout"));
        mutableLocations.put("mirrorOfLayouts", newlocs.containsKey("mirrorOfLayouts") ? (InputLocation)newlocs.get("mirrorOfLayouts") : (InputLocation)oldlocs.get("mirrorOfLayouts"));
        mutableLocations.put("blocked", newlocs.containsKey("blocked") ? (InputLocation)newlocs.get("blocked") : (InputLocation)oldlocs.get("blocked"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getMirrorOf() {
        return this.mirrorOf;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLayout() {
        return this.layout;
    }

    public String getMirrorOfLayouts() {
        return this.mirrorOfLayouts;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Override
    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Mirror.newBuilder(this);
    }

    @Override
    @Nonnull
    public Mirror withId(String id) {
        return Mirror.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Mirror withMirrorOf(String mirrorOf) {
        return Mirror.newBuilder(this, true).mirrorOf(mirrorOf).build();
    }

    @Nonnull
    public Mirror withName(String name) {
        return Mirror.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public Mirror withUrl(String url) {
        return Mirror.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public Mirror withLayout(String layout) {
        return Mirror.newBuilder(this, true).layout(layout).build();
    }

    @Nonnull
    public Mirror withMirrorOfLayouts(String mirrorOfLayouts) {
        return Mirror.newBuilder(this, true).mirrorOfLayouts(mirrorOfLayouts).build();
    }

    @Nonnull
    public Mirror withBlocked(boolean blocked) {
        return Mirror.newBuilder(this, true).blocked(blocked).build();
    }

    @Nonnull
    public static Mirror newInstance() {
        return Mirror.newInstance(true);
    }

    @Nonnull
    public static Mirror newInstance(boolean withDefaults) {
        return Mirror.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Mirror.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Mirror from) {
        return Mirror.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Mirror from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Mirror[");
        sb.append("id=").append(this.getId());
        sb.append(",mirrorOf=").append(this.getMirrorOf());
        sb.append(",url=").append(this.getUrl());
        sb.append(",name=").append(this.getName());
        if (this.isBlocked()) {
            sb.append(",blocked");
        }
        sb.append("]");
        return sb.toString();
    }

    @NotThreadSafe
    public static class Builder
    extends IdentifiableBase.Builder {
        Mirror base;
        String mirrorOf;
        String name;
        String url;
        String layout;
        String mirrorOfLayouts;
        Boolean blocked;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.layout = "default";
                this.mirrorOfLayouts = "default,legacy";
                this.blocked = false;
            }
        }

        protected Builder(Mirror base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.mirrorOf = base.mirrorOf;
                this.name = base.name;
                this.url = base.url;
                this.layout = base.layout;
                this.mirrorOfLayouts = base.mirrorOfLayouts;
                this.blocked = base.blocked;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder mirrorOf(String mirrorOf) {
            this.mirrorOf = mirrorOf;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Nonnull
        public Builder mirrorOfLayouts(String mirrorOfLayouts) {
            this.mirrorOfLayouts = mirrorOfLayouts;
            return this;
        }

        @Nonnull
        public Builder blocked(boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Mirror build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.mirrorOf != null && this.mirrorOf != this.base.mirrorOf || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.layout != null && this.layout != this.base.layout || this.mirrorOfLayouts != null && this.mirrorOfLayouts != this.base.mirrorOfLayouts || this.blocked != null && this.blocked != this.base.blocked)) {
                return this.base;
            }
            return new Mirror(this);
        }
    }
}

