// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.plugin.descriptor;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Definition of a dependency, needed by the plugin at runtime.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Dependency
    implements Serializable
{
    /**
     * The group id of the dependency.
     */
    final String groupId;
    /**
     * The artifact id of the dependency.
     */
    final String artifactId;
    /**
     * The version of the dependency.
     */
    final String version;
    /**
     * The type of dependency.
     */
    final String type;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Dependency(Builder builder) {
        this.groupId = builder.groupId != null ? builder.groupId : (builder.base != null ? builder.base.groupId : null);
        this.artifactId = builder.artifactId != null ? builder.artifactId : (builder.base != null ? builder.base.artifactId : null);
        this.version = builder.version != null ? builder.version : (builder.base != null ? builder.base.version : null);
        this.type = builder.type != null ? builder.type : (builder.base != null ? builder.base.type : null);
    }

    /**
     * The group id of the dependency.
     *
     * @return a {@code String}
     */
    public String getGroupId() {
        return this.groupId;
    }

    /**
     * The artifact id of the dependency.
     *
     * @return a {@code String}
     */
    public String getArtifactId() {
        return this.artifactId;
    }

    /**
     * The version of the dependency.
     *
     * @return a {@code String}
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * The type of dependency.
     *
     * @return a {@code String}
     */
    public String getType() {
        return this.type;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Dependency} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Dependency} with the specified groupId
     */
    @Nonnull
    public Dependency withGroupId(String groupId) {
        return newBuilder(this, true).groupId(groupId).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Dependency} with the specified artifactId
     */
    @Nonnull
    public Dependency withArtifactId(String artifactId) {
        return newBuilder(this, true).artifactId(artifactId).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code Dependency} with the specified version
     */
    @Nonnull
    public Dependency withVersion(String version) {
        return newBuilder(this, true).version(version).build();
    }
    /**
     * Creates a new {@code Dependency} instance using the specified type.
     *
     * @param type the new {@code String} to use
     * @return a {@code Dependency} with the specified type
     */
    @Nonnull
    public Dependency withType(String type) {
        return newBuilder(this, true).type(type).build();
    }

    /**
     * Creates a new {@code Dependency} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Dependency}
     */
    @Nonnull
    public static Dependency newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Dependency} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Dependency}
     */
    @Nonnull
    public static Dependency newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Dependency} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Dependency} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Dependency} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Dependency} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Dependency from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Dependency} builder instance using the specified object as a basis.
     *
     * @param from the {@code Dependency} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Dependency from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Dependency instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Dependency base;
        String groupId;
        String artifactId;
        String version;
        String type;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.type = "jar";
            }
        }

        protected Builder(Dependency base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.type = base.type;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }


        @Nonnull
        public Dependency build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (groupId == null || groupId == base.groupId)
                    && (artifactId == null || artifactId == base.artifactId)
                    && (version == null || version == base.version)
                    && (type == null || type == base.type)
            ) {
                return base;
            }
            return new Dependency(this);
        }
    }

}
