/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class DependencyManagement
implements Serializable,
InputLocationTracker {
    final List<Dependency> dependencies;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected DependencyManagement(Builder builder) {
        this.dependencies = ImmutableCollections.copy(builder.dependencies != null ? builder.dependencies : (builder.base != null ? builder.base.dependencies : null));
        Map<Object, Object> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<String, InputLocation> mutableLocations = new HashMap<String, InputLocation>();
        this.importedFrom = builder.importedFrom;
        mutableLocations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
        mutableLocations.put("dependencies", newlocs.containsKey("dependencies") ? (InputLocation)newlocs.get("dependencies") : (InputLocation)oldlocs.get("dependencies"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    @Nonnull
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return DependencyManagement.newBuilder(this);
    }

    @Nonnull
    public DependencyManagement withDependencies(Collection<Dependency> dependencies) {
        return DependencyManagement.newBuilder(this, true).dependencies(dependencies).build();
    }

    @Nonnull
    public static DependencyManagement newInstance() {
        return DependencyManagement.newInstance(true);
    }

    @Nonnull
    public static DependencyManagement newInstance(boolean withDefaults) {
        return DependencyManagement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return DependencyManagement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(DependencyManagement from) {
        return DependencyManagement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(DependencyManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        DependencyManagement base;
        Collection<Dependency> dependencies;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(DependencyManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.dependencies = base.dependencies;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public DependencyManagement build() {
            if (this.base != null && (this.dependencies == null || this.dependencies == this.base.dependencies)) {
                return this.base;
            }
            return new DependencyManagement(this);
        }
    }
}

