// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Modifications to the build process which is activated based on environmental
 * parameters or command line arguments.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Profile
    extends ModelBase
    implements Serializable, InputLocationTracker
{
    /**
     * The identifier of this build profile. This is used for command line
     * activation, and identifies profiles to be merged.
     */
    final String id;
    /**
     * The conditional logic which will automatically trigger the inclusion of this
     * profile.
     */
    final Activation activation;
    /**
     * Information required to build the project.
     */
    final BuildBase build;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Profile(Builder builder) {
        super(builder);
        this.id = builder.id != null ? builder.id : (builder.base != null ? builder.base.id : null);
        this.activation = builder.activation != null ? builder.activation : (builder.base != null ? builder.base.activation : null);
        this.build = builder.build != null ? builder.build : (builder.base != null ? builder.base.build : null);
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>(super.locations);
        mutableLocations.put("id", newlocs.containsKey("id") ? newlocs.get("id") : oldlocs.get("id"));
        mutableLocations.put("activation", newlocs.containsKey("activation") ? newlocs.get("activation") : oldlocs.get("activation"));
        mutableLocations.put("build", newlocs.containsKey("build") ? newlocs.get("build") : oldlocs.get("build"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    /**
     * The identifier of this build profile. This is used for command line
     * activation, and identifies profiles to be merged.
     *
     * @return a {@code String}
     */
    public String getId() {
        return this.id;
    }

    /**
     * The conditional logic which will automatically trigger the inclusion of this
     * profile.
     *
     * @return a {@code Activation}
     */
    public Activation getActivation() {
        return this.activation;
    }

    /**
     * Information required to build the project.
     *
     * @return a {@code BuildBase}
     */
    public BuildBase getBuild() {
        return this.build;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Profile} instance using the specified modules.
     *
     * @param modules the new {@code Collection<String>} to use
     * @return a {@code Profile} with the specified modules
     */
    @Deprecated
    @Nonnull
    public Profile withModules(Collection<String> modules) {
        return newBuilder(this, true).modules(modules).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified subprojects.
     *
     * @param subprojects the new {@code Collection<String>} to use
     * @return a {@code Profile} with the specified subprojects
     */
    @Nonnull
    public Profile withSubprojects(Collection<String> subprojects) {
        return newBuilder(this, true).subprojects(subprojects).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified distributionManagement.
     *
     * @param distributionManagement the new {@code DistributionManagement} to use
     * @return a {@code Profile} with the specified distributionManagement
     */
    @Nonnull
    public Profile withDistributionManagement(DistributionManagement distributionManagement) {
        return newBuilder(this, true).distributionManagement(distributionManagement).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified properties.
     *
     * @param properties the new {@code Map<String, String>} to use
     * @return a {@code Profile} with the specified properties
     */
    @Nonnull
    public Profile withProperties(Map<String, String> properties) {
        return newBuilder(this, true).properties(properties).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified dependencyManagement.
     *
     * @param dependencyManagement the new {@code DependencyManagement} to use
     * @return a {@code Profile} with the specified dependencyManagement
     */
    @Nonnull
    public Profile withDependencyManagement(DependencyManagement dependencyManagement) {
        return newBuilder(this, true).dependencyManagement(dependencyManagement).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified dependencies.
     *
     * @param dependencies the new {@code Collection<Dependency>} to use
     * @return a {@code Profile} with the specified dependencies
     */
    @Nonnull
    public Profile withDependencies(Collection<Dependency> dependencies) {
        return newBuilder(this, true).dependencies(dependencies).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified repositories.
     *
     * @param repositories the new {@code Collection<Repository>} to use
     * @return a {@code Profile} with the specified repositories
     */
    @Nonnull
    public Profile withRepositories(Collection<Repository> repositories) {
        return newBuilder(this, true).repositories(repositories).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified pluginRepositories.
     *
     * @param pluginRepositories the new {@code Collection<Repository>} to use
     * @return a {@code Profile} with the specified pluginRepositories
     */
    @Nonnull
    public Profile withPluginRepositories(Collection<Repository> pluginRepositories) {
        return newBuilder(this, true).pluginRepositories(pluginRepositories).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified reporting.
     *
     * @param reporting the new {@code Reporting} to use
     * @return a {@code Profile} with the specified reporting
     */
    @Nonnull
    public Profile withReporting(Reporting reporting) {
        return newBuilder(this, true).reporting(reporting).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Profile} with the specified id
     */
    @Nonnull
    public Profile withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified activation.
     *
     * @param activation the new {@code Activation} to use
     * @return a {@code Profile} with the specified activation
     */
    @Nonnull
    public Profile withActivation(Activation activation) {
        return newBuilder(this, true).activation(activation).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified build.
     *
     * @param build the new {@code BuildBase} to use
     * @return a {@code Profile} with the specified build
     */
    @Nonnull
    public Profile withBuild(BuildBase build) {
        return newBuilder(this, true).build(build).build();
    }

    /**
     * Creates a new {@code Profile} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Profile}
     */
    @Nonnull
    public static Profile newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Profile} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Profile}
     */
    @Nonnull
    public static Profile newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Profile} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Profile} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Profile} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Profile} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Profile from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Profile} builder instance using the specified object as a basis.
     *
     * @param from the {@code Profile} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Profile from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Profile instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends ModelBase.Builder
    {
        Profile base;
        String id;
        Activation activation;
        BuildBase build;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = "default";
            }
        }

        protected Builder(Profile base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.activation = base.activation;
                this.build = base.build;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Deprecated
        @Nonnull
        public Builder modules(Collection<String> modules) {
            this.modules = modules;
            return this;
        }

        @Nonnull
        public Builder subprojects(Collection<String> subprojects) {
            this.subprojects = subprojects;
            return this;
        }

        @Nonnull
        public Builder distributionManagement(DistributionManagement distributionManagement) {
            this.distributionManagement = distributionManagement;
            return this;
        }

        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder dependencyManagement(DependencyManagement dependencyManagement) {
            this.dependencyManagement = dependencyManagement;
            return this;
        }

        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Nonnull
        public Builder repositories(Collection<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public Builder pluginRepositories(Collection<Repository> pluginRepositories) {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Nonnull
        public Builder reporting(Reporting reporting) {
            this.reporting = reporting;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder activation(Activation activation) {
            this.activation = activation;
            return this;
        }

        @Nonnull
        public Builder build(BuildBase build) {
            this.build = build;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Profile build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (modules == null || modules == base.modules)
                    && (subprojects == null || subprojects == base.subprojects)
                    && (distributionManagement == null || distributionManagement == base.distributionManagement)
                    && (properties == null || properties == base.properties)
                    && (dependencyManagement == null || dependencyManagement == base.dependencyManagement)
                    && (dependencies == null || dependencies == base.dependencies)
                    && (repositories == null || repositories == base.repositories)
                    && (pluginRepositories == null || pluginRepositories == base.pluginRepositories)
                    && (reporting == null || reporting == base.reporting)
                    && (id == null || id == base.id)
                    && (activation == null || activation == base.activation)
                    && (build == null || build == base.build)
            ) {
                return base;
            }
            return new Profile(this);
        }
    }


            
    public static final String SOURCE_POM = "pom";

    public static final String SOURCE_SETTINGS = "settings.xml";

    // We don't want this to be parseable...it's sort of 'hidden'
    // default source for this profile is in the pom itself.
    private String source = SOURCE_POM;

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return source;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "Profile {id: " + getId() + ", source: " + getSource() + "}";
    }
            
          
}
