// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Describes the prerequisites a project can have.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Prerequisites
    implements Serializable, InputLocationTracker
{
    /**
     * For a plugin project (packaging is {@code maven-plugin}), the minimum version of
     * Maven required to use the resulting plugin.<br>
     * In Maven 2, this was also specifying the minimum version of Maven required to build a
     * project, but this usage is <b>deprecated</b> in Maven 3 and not checked any more: use
     * the <a href="https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html">Maven Enforcer Plugin's
     * {@code requireMavenVersion} rule</a> instead.
     */
    final String maven;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Prerequisites(Builder builder) {
        this.maven = builder.maven != null ? builder.maven : (builder.base != null ? builder.base.maven : null);
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>();
        this.importedFrom = builder.importedFrom;
        mutableLocations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
        mutableLocations.put("maven", newlocs.containsKey("maven") ? newlocs.get("maven") : oldlocs.get("maven"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    /**
     * For a plugin project (packaging is {@code maven-plugin}), the minimum version of
     * Maven required to use the resulting plugin.<br>
     * In Maven 2, this was also specifying the minimum version of Maven required to build a
     * project, but this usage is <b>deprecated</b> in Maven 3 and not checked any more: use
     * the <a href="https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html">Maven Enforcer Plugin's
     * {@code requireMavenVersion} rule</a> instead.
     *
     * @return a {@code String}
     */
    public String getMaven() {
        return this.maven;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom()
    {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Prerequisites} instance using the specified maven.
     *
     * @param maven the new {@code String} to use
     * @return a {@code Prerequisites} with the specified maven
     */
    @Nonnull
    public Prerequisites withMaven(String maven) {
        return newBuilder(this, true).maven(maven).build();
    }

    /**
     * Creates a new {@code Prerequisites} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Prerequisites}
     */
    @Nonnull
    public static Prerequisites newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Prerequisites} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Prerequisites}
     */
    @Nonnull
    public static Prerequisites newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Prerequisites} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Prerequisites} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Prerequisites} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Prerequisites} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Prerequisites from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Prerequisites} builder instance using the specified object as a basis.
     *
     * @param from the {@code Prerequisites} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Prerequisites from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Prerequisites instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Prerequisites base;
        String maven;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.maven = "2.0";
            }
        }

        protected Builder(Prerequisites base, boolean forceCopy) {
            if (forceCopy) {
                this.maven = base.maven;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder maven(String maven) {
            this.maven = maven;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Prerequisites build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (maven == null || maven == base.maven)
            ) {
                return base;
            }
            return new Prerequisites(this);
        }
    }

}
