// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Information about one of the committers on this project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Developer
    extends Contributor
    implements Serializable, InputLocationTracker
{
    /**
     * The unique ID of the developer in the SCM.
     */
    final String id;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Developer(Builder builder) {
        super(builder);
        this.id = builder.id != null ? builder.id : (builder.base != null ? builder.base.id : null);
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>(super.locations);
        mutableLocations.put("id", newlocs.containsKey("id") ? newlocs.get("id") : oldlocs.get("id"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    /**
     * The unique ID of the developer in the SCM.
     *
     * @return a {@code String}
     */
    public String getId() {
        return this.id;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Developer} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code Developer} with the specified name
     */
    @Nonnull
    public Developer withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code Developer} instance using the specified email.
     *
     * @param email the new {@code String} to use
     * @return a {@code Developer} with the specified email
     */
    @Nonnull
    public Developer withEmail(String email) {
        return newBuilder(this, true).email(email).build();
    }
    /**
     * Creates a new {@code Developer} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code Developer} with the specified url
     */
    @Nonnull
    public Developer withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }
    /**
     * Creates a new {@code Developer} instance using the specified organization.
     *
     * @param organization the new {@code String} to use
     * @return a {@code Developer} with the specified organization
     */
    @Nonnull
    public Developer withOrganization(String organization) {
        return newBuilder(this, true).organization(organization).build();
    }
    /**
     * Creates a new {@code Developer} instance using the specified organizationUrl.
     *
     * @param organizationUrl the new {@code String} to use
     * @return a {@code Developer} with the specified organizationUrl
     */
    @Nonnull
    public Developer withOrganizationUrl(String organizationUrl) {
        return newBuilder(this, true).organizationUrl(organizationUrl).build();
    }
    /**
     * Creates a new {@code Developer} instance using the specified roles.
     *
     * @param roles the new {@code Collection<String>} to use
     * @return a {@code Developer} with the specified roles
     */
    @Nonnull
    public Developer withRoles(Collection<String> roles) {
        return newBuilder(this, true).roles(roles).build();
    }
    /**
     * Creates a new {@code Developer} instance using the specified timezone.
     *
     * @param timezone the new {@code String} to use
     * @return a {@code Developer} with the specified timezone
     */
    @Nonnull
    public Developer withTimezone(String timezone) {
        return newBuilder(this, true).timezone(timezone).build();
    }
    /**
     * Creates a new {@code Developer} instance using the specified properties.
     *
     * @param properties the new {@code Map<String, String>} to use
     * @return a {@code Developer} with the specified properties
     */
    @Nonnull
    public Developer withProperties(Map<String, String> properties) {
        return newBuilder(this, true).properties(properties).build();
    }
    /**
     * Creates a new {@code Developer} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Developer} with the specified id
     */
    @Nonnull
    public Developer withId(String id) {
        return newBuilder(this, true).id(id).build();
    }

    /**
     * Creates a new {@code Developer} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Developer}
     */
    @Nonnull
    public static Developer newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Developer} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Developer}
     */
    @Nonnull
    public static Developer newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Developer} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Developer} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Developer} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Developer} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Developer from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Developer} builder instance using the specified object as a basis.
     *
     * @param from the {@code Developer} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Developer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Developer instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends Contributor.Builder
    {
        Developer base;
        String id;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
            }
        }

        protected Builder(Developer base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder email(String email) {
            this.email = email;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        @Nonnull
        public Builder organizationUrl(String organizationUrl) {
            this.organizationUrl = organizationUrl;
            return this;
        }

        @Nonnull
        public Builder roles(Collection<String> roles) {
            this.roles = roles;
            return this;
        }

        @Nonnull
        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Developer build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (name == null || name == base.name)
                    && (email == null || email == base.email)
                    && (url == null || url == base.url)
                    && (organization == null || organization == base.organization)
                    && (organizationUrl == null || organizationUrl == base.organizationUrl)
                    && (roles == null || roles == base.roles)
                    && (timezone == null || timezone == base.timezone)
                    && (properties == null || properties == base.properties)
                    && (id == null || id == base.id)
            ) {
                return base;
            }
            return new Developer(this);
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "Developer {id=" + getId() + ", " + super.toString() + "}";
    }
            
          
}
