// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Deployment repository contains the information needed for deploying to the remote
 * repository, which adds uniqueVersion property to usual repositories for download.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class DeploymentRepository
    extends Repository
    implements Serializable, InputLocationTracker
{
    /**
     * Whether to assign snapshots a unique version comprised of the timestamp and
     * build number, or to use the same version each time
     */
    final boolean uniqueVersion;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected DeploymentRepository(Builder builder) {
        super(builder);
        this.uniqueVersion = builder.uniqueVersion != null ? builder.uniqueVersion : (builder.base != null ? builder.base.uniqueVersion : true);
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>(super.locations);
        mutableLocations.put("uniqueVersion", newlocs.containsKey("uniqueVersion") ? newlocs.get("uniqueVersion") : oldlocs.get("uniqueVersion"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof DeploymentRepository)) {
            return false;
        }
        DeploymentRepository that = (DeploymentRepository) o;
        return Objects.equals( this.id, that.id );
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    /**
     * Whether to assign snapshots a unique version comprised of the timestamp and
     * build number, or to use the same version each time
     *
     * @return a {@code boolean}
     */
    public boolean isUniqueVersion() {
        return this.uniqueVersion;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code DeploymentRepository} with the specified id
     */
    @Nonnull
    public DeploymentRepository withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code DeploymentRepository} with the specified name
     */
    @Nonnull
    public DeploymentRepository withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code DeploymentRepository} with the specified url
     */
    @Nonnull
    public DeploymentRepository withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified layout.
     *
     * @param layout the new {@code String} to use
     * @return a {@code DeploymentRepository} with the specified layout
     */
    @Nonnull
    public DeploymentRepository withLayout(String layout) {
        return newBuilder(this, true).layout(layout).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified releases.
     *
     * @param releases the new {@code RepositoryPolicy} to use
     * @return a {@code DeploymentRepository} with the specified releases
     */
    @Nonnull
    public DeploymentRepository withReleases(RepositoryPolicy releases) {
        return newBuilder(this, true).releases(releases).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified snapshots.
     *
     * @param snapshots the new {@code RepositoryPolicy} to use
     * @return a {@code DeploymentRepository} with the specified snapshots
     */
    @Nonnull
    public DeploymentRepository withSnapshots(RepositoryPolicy snapshots) {
        return newBuilder(this, true).snapshots(snapshots).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified uniqueVersion.
     *
     * @param uniqueVersion the new {@code boolean} to use
     * @return a {@code DeploymentRepository} with the specified uniqueVersion
     */
    @Nonnull
    public DeploymentRepository withUniqueVersion(boolean uniqueVersion) {
        return newBuilder(this, true).uniqueVersion(uniqueVersion).build();
    }

    /**
     * Creates a new {@code DeploymentRepository} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code DeploymentRepository}
     */
    @Nonnull
    public static DeploymentRepository newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code DeploymentRepository} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code DeploymentRepository}
     */
    @Nonnull
    public static DeploymentRepository newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code DeploymentRepository} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code DeploymentRepository} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code DeploymentRepository} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code DeploymentRepository} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(DeploymentRepository from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code DeploymentRepository} builder instance using the specified object as a basis.
     *
     * @param from the {@code DeploymentRepository} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(DeploymentRepository from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create DeploymentRepository instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends Repository.Builder
    {
        DeploymentRepository base;
        Boolean uniqueVersion;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.uniqueVersion = true;
            }
        }

        protected Builder(DeploymentRepository base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.uniqueVersion = base.uniqueVersion;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Nonnull
        public Builder releases(RepositoryPolicy releases) {
            this.releases = releases;
            return this;
        }

        @Nonnull
        public Builder snapshots(RepositoryPolicy snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        @Nonnull
        public Builder uniqueVersion(boolean uniqueVersion) {
            this.uniqueVersion = uniqueVersion;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public DeploymentRepository build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (id == null || id == base.id)
                    && (name == null || name == base.name)
                    && (url == null || url == base.url)
                    && (layout == null || layout == base.layout)
                    && (releases == null || releases == base.releases)
                    && (snapshots == null || snapshots == base.snapshots)
                    && (uniqueVersion == null || uniqueVersion == base.uniqueVersion)
            ) {
                return base;
            }
            return new DeploymentRepository(this);
        }
    }

}
