// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Build configuration in a profile.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class BuildBase
    extends PluginConfiguration
    implements Serializable, InputLocationTracker
{
    /**
     * The default goal (or phase in Maven 2) to execute when none is specified for
     * the project. Note that in case of a build with subprojects, only the default goal of the top-level
     * project is relevant, i.e. the default goals of subprojects are ignored. Since Maven 3,
     * multiple goals/phases can be separated by whitespace.
     */
    final String defaultGoal;
    /**
     * This element describes all the classpath resources such as properties
     * files associated with a project. These resources are often included in the final
     * package.
     * The default value is {@code src/main/resources}.
     */
    final List<Resource> resources;
    /**
     * This element describes all the classpath resources such as properties
     * files associated with a project's unit tests.
     * The default value is {@code src/test/resources}.
     */
    final List<Resource> testResources;
    /**
     * The directory where all files generated by the build are placed.
     * The default value is {@code target}.
     */
    final String directory;
    /**
     * The filename (excluding the extension, and with no path information) that
     * the produced artifact will be called.
     * The default value is {@code ${artifactId}-${version}}.
     */
    final String finalName;
    /**
     * The list of filter properties files that are used when filtering is enabled.
     */
    final List<String> filters;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected BuildBase(Builder builder) {
        super(builder);
        this.defaultGoal = builder.defaultGoal != null ? builder.defaultGoal : (builder.base != null ? builder.base.defaultGoal : null);
        this.resources = ImmutableCollections.copy(builder.resources != null ? builder.resources : (builder.base != null ? builder.base.resources : null));
        this.testResources = ImmutableCollections.copy(builder.testResources != null ? builder.testResources : (builder.base != null ? builder.base.testResources : null));
        this.directory = builder.directory != null ? builder.directory : (builder.base != null ? builder.base.directory : null);
        this.finalName = builder.finalName != null ? builder.finalName : (builder.base != null ? builder.base.finalName : null);
        this.filters = ImmutableCollections.copy(builder.filters != null ? builder.filters : (builder.base != null ? builder.base.filters : null));
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>(super.locations);
        mutableLocations.put("defaultGoal", newlocs.containsKey("defaultGoal") ? newlocs.get("defaultGoal") : oldlocs.get("defaultGoal"));
        mutableLocations.put("resources", newlocs.containsKey("resources") ? newlocs.get("resources") : oldlocs.get("resources"));
        mutableLocations.put("testResources", newlocs.containsKey("testResources") ? newlocs.get("testResources") : oldlocs.get("testResources"));
        mutableLocations.put("directory", newlocs.containsKey("directory") ? newlocs.get("directory") : oldlocs.get("directory"));
        mutableLocations.put("finalName", newlocs.containsKey("finalName") ? newlocs.get("finalName") : oldlocs.get("finalName"));
        mutableLocations.put("filters", newlocs.containsKey("filters") ? newlocs.get("filters") : oldlocs.get("filters"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    /**
     * The default goal (or phase in Maven 2) to execute when none is specified for
     * the project. Note that in case of a build with subprojects, only the default goal of the top-level
     * project is relevant, i.e. the default goals of subprojects are ignored. Since Maven 3,
     * multiple goals/phases can be separated by whitespace.
     *
     * @return a {@code String}
     */
    public String getDefaultGoal() {
        return this.defaultGoal;
    }

    /**
     * This element describes all the classpath resources such as properties
     * files associated with a project. These resources are often included in the final
     * package.
     * The default value is {@code src/main/resources}.
     *
     * @return a {@code List<Resource>}
     */
    @Nonnull
    public List<Resource> getResources() {
        return this.resources;
    }

    /**
     * This element describes all the classpath resources such as properties
     * files associated with a project's unit tests.
     * The default value is {@code src/test/resources}.
     *
     * @return a {@code List<Resource>}
     */
    @Nonnull
    public List<Resource> getTestResources() {
        return this.testResources;
    }

    /**
     * The directory where all files generated by the build are placed.
     * The default value is {@code target}.
     *
     * @return a {@code String}
     */
    public String getDirectory() {
        return this.directory;
    }

    /**
     * The filename (excluding the extension, and with no path information) that
     * the produced artifact will be called.
     * The default value is {@code ${artifactId}-${version}}.
     *
     * @return a {@code String}
     */
    public String getFinalName() {
        return this.finalName;
    }

    /**
     * The list of filter properties files that are used when filtering is enabled.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getFilters() {
        return this.filters;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<Plugin>} to use
     * @return a {@code BuildBase} with the specified plugins
     */
    @Nonnull
    public BuildBase withPlugins(Collection<Plugin> plugins) {
        return newBuilder(this, true).plugins(plugins).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified pluginManagement.
     *
     * @param pluginManagement the new {@code PluginManagement} to use
     * @return a {@code BuildBase} with the specified pluginManagement
     */
    @Nonnull
    public BuildBase withPluginManagement(PluginManagement pluginManagement) {
        return newBuilder(this, true).pluginManagement(pluginManagement).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified defaultGoal.
     *
     * @param defaultGoal the new {@code String} to use
     * @return a {@code BuildBase} with the specified defaultGoal
     */
    @Nonnull
    public BuildBase withDefaultGoal(String defaultGoal) {
        return newBuilder(this, true).defaultGoal(defaultGoal).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified resources.
     *
     * @param resources the new {@code Collection<Resource>} to use
     * @return a {@code BuildBase} with the specified resources
     */
    @Nonnull
    public BuildBase withResources(Collection<Resource> resources) {
        return newBuilder(this, true).resources(resources).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified testResources.
     *
     * @param testResources the new {@code Collection<Resource>} to use
     * @return a {@code BuildBase} with the specified testResources
     */
    @Nonnull
    public BuildBase withTestResources(Collection<Resource> testResources) {
        return newBuilder(this, true).testResources(testResources).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified directory.
     *
     * @param directory the new {@code String} to use
     * @return a {@code BuildBase} with the specified directory
     */
    @Nonnull
    public BuildBase withDirectory(String directory) {
        return newBuilder(this, true).directory(directory).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified finalName.
     *
     * @param finalName the new {@code String} to use
     * @return a {@code BuildBase} with the specified finalName
     */
    @Nonnull
    public BuildBase withFinalName(String finalName) {
        return newBuilder(this, true).finalName(finalName).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified filters.
     *
     * @param filters the new {@code Collection<String>} to use
     * @return a {@code BuildBase} with the specified filters
     */
    @Nonnull
    public BuildBase withFilters(Collection<String> filters) {
        return newBuilder(this, true).filters(filters).build();
    }

    /**
     * Creates a new {@code BuildBase} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code BuildBase}
     */
    @Nonnull
    public static BuildBase newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code BuildBase} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code BuildBase}
     */
    @Nonnull
    public static BuildBase newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code BuildBase} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code BuildBase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code BuildBase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code BuildBase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(BuildBase from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code BuildBase} builder instance using the specified object as a basis.
     *
     * @param from the {@code BuildBase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(BuildBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create BuildBase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends PluginConfiguration.Builder
    {
        BuildBase base;
        String defaultGoal;
        Collection<Resource> resources;
        Collection<Resource> testResources;
        String directory;
        String finalName;
        Collection<String> filters;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
            }
        }

        protected Builder(BuildBase base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.defaultGoal = base.defaultGoal;
                this.resources = base.resources;
                this.testResources = base.testResources;
                this.directory = base.directory;
                this.finalName = base.finalName;
                this.filters = base.filters;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Nonnull
        public Builder defaultGoal(String defaultGoal) {
            this.defaultGoal = defaultGoal;
            return this;
        }

        @Nonnull
        public Builder resources(Collection<Resource> resources) {
            this.resources = resources;
            return this;
        }

        @Nonnull
        public Builder testResources(Collection<Resource> testResources) {
            this.testResources = testResources;
            return this;
        }

        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder finalName(String finalName) {
            this.finalName = finalName;
            return this;
        }

        @Nonnull
        public Builder filters(Collection<String> filters) {
            this.filters = filters;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public BuildBase build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (plugins == null || plugins == base.plugins)
                    && (pluginManagement == null || pluginManagement == base.pluginManagement)
                    && (defaultGoal == null || defaultGoal == base.defaultGoal)
                    && (resources == null || resources == base.resources)
                    && (testResources == null || testResources == base.testResources)
                    && (directory == null || directory == base.directory)
                    && (finalName == null || finalName == base.finalName)
                    && (filters == null || filters == base.filters)
            ) {
                return base;
            }
            return new BuildBase(this);
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "BuildBase {" + super.toString() + "}";
    }
            
          
}
