// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * This is an activator which will detect an operating system's attributes in order
 * to activate its profile.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ActivationOS
    implements Serializable, InputLocationTracker
{
    /**
     * The name of the operating system to be used to activate the profile. This must be an exact match
     * of the {@code ${os.name}} Java property, such as {@code Windows XP}.
     */
    final String name;
    /**
     * The general family of the OS to be used to activate the profile, such as
     * {@code windows} or {@code unix}.
     */
    final String family;
    /**
     * The architecture of the operating system to be used to activate the
     * profile.
     */
    final String arch;
    /**
     * The version of the operating system to be used to activate the
     * profile.
     */
    final String version;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected ActivationOS(Builder builder) {
        this.name = builder.name != null ? builder.name : (builder.base != null ? builder.base.name : null);
        this.family = builder.family != null ? builder.family : (builder.base != null ? builder.base.family : null);
        this.arch = builder.arch != null ? builder.arch : (builder.base != null ? builder.base.arch : null);
        this.version = builder.version != null ? builder.version : (builder.base != null ? builder.base.version : null);
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>();
        this.importedFrom = builder.importedFrom;
        mutableLocations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
        mutableLocations.put("name", newlocs.containsKey("name") ? newlocs.get("name") : oldlocs.get("name"));
        mutableLocations.put("family", newlocs.containsKey("family") ? newlocs.get("family") : oldlocs.get("family"));
        mutableLocations.put("arch", newlocs.containsKey("arch") ? newlocs.get("arch") : oldlocs.get("arch"));
        mutableLocations.put("version", newlocs.containsKey("version") ? newlocs.get("version") : oldlocs.get("version"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    /**
     * The name of the operating system to be used to activate the profile. This must be an exact match
     * of the {@code ${os.name}} Java property, such as {@code Windows XP}.
     *
     * @return a {@code String}
     */
    public String getName() {
        return this.name;
    }

    /**
     * The general family of the OS to be used to activate the profile, such as
     * {@code windows} or {@code unix}.
     *
     * @return a {@code String}
     */
    public String getFamily() {
        return this.family;
    }

    /**
     * The architecture of the operating system to be used to activate the
     * profile.
     *
     * @return a {@code String}
     */
    public String getArch() {
        return this.arch;
    }

    /**
     * The version of the operating system to be used to activate the
     * profile.
     *
     * @return a {@code String}
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom()
    {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code ActivationOS} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code ActivationOS} with the specified name
     */
    @Nonnull
    public ActivationOS withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code ActivationOS} instance using the specified family.
     *
     * @param family the new {@code String} to use
     * @return a {@code ActivationOS} with the specified family
     */
    @Nonnull
    public ActivationOS withFamily(String family) {
        return newBuilder(this, true).family(family).build();
    }
    /**
     * Creates a new {@code ActivationOS} instance using the specified arch.
     *
     * @param arch the new {@code String} to use
     * @return a {@code ActivationOS} with the specified arch
     */
    @Nonnull
    public ActivationOS withArch(String arch) {
        return newBuilder(this, true).arch(arch).build();
    }
    /**
     * Creates a new {@code ActivationOS} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code ActivationOS} with the specified version
     */
    @Nonnull
    public ActivationOS withVersion(String version) {
        return newBuilder(this, true).version(version).build();
    }

    /**
     * Creates a new {@code ActivationOS} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ActivationOS}
     */
    @Nonnull
    public static ActivationOS newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code ActivationOS} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ActivationOS}
     */
    @Nonnull
    public static ActivationOS newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code ActivationOS} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code ActivationOS} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code ActivationOS} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code ActivationOS} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(ActivationOS from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code ActivationOS} builder instance using the specified object as a basis.
     *
     * @param from the {@code ActivationOS} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(ActivationOS from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create ActivationOS instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        ActivationOS base;
        String name;
        String family;
        String arch;
        String version;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(ActivationOS base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.family = base.family;
                this.arch = base.arch;
                this.version = base.version;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder family(String family) {
            this.family = family;
            return this;
        }

        @Nonnull
        public Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public ActivationOS build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (name == null || name == base.name)
                    && (family == null || family == base.family)
                    && (arch == null || arch == base.arch)
                    && (version == null || version == base.version)
            ) {
                return base;
            }
            return new ActivationOS(this);
        }
    }

}
