/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginManagement;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PluginConfiguration
extends PluginContainer
implements Serializable,
InputLocationTracker {
    final PluginManagement pluginManagement;
    final InputLocation pluginManagementLocation;

    PluginConfiguration(Collection<Plugin> plugins, PluginManagement pluginManagement, Map<Object, InputLocation> locations, InputLocation location, InputLocation pluginsLocation, InputLocation pluginManagementLocation) {
        super(plugins, locations, location, pluginsLocation);
        this.pluginManagement = pluginManagement;
        this.pluginManagementLocation = pluginManagementLocation;
    }

    public PluginManagement getPluginManagement() {
        return this.pluginManagement;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "pluginManagement": {
                    return this.pluginManagementLocation;
                }
            }
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return PluginConfiguration.newBuilder(this);
    }

    @Override
    @Nonnull
    public PluginConfiguration withPlugins(Collection<Plugin> plugins) {
        return ((Builder)this.with().plugins((Collection)plugins)).build();
    }

    @Nonnull
    public PluginConfiguration withPluginManagement(PluginManagement pluginManagement) {
        return this.with().pluginManagement(pluginManagement).build();
    }

    @Nonnull
    public static PluginConfiguration newInstance() {
        return PluginConfiguration.newInstance(true);
    }

    @Nonnull
    public static PluginConfiguration newInstance(boolean withDefaults) {
        return PluginConfiguration.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PluginConfiguration.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PluginConfiguration from) {
        return PluginConfiguration.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PluginConfiguration from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "PluginConfiguration {" + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends PluginContainer.Builder {
        PluginConfiguration base;
        PluginManagement pluginManagement;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(PluginConfiguration base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.pluginManagement = base.pluginManagement;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public PluginConfiguration build() {
            if (!(this.base == null || this.plugins != null && this.plugins != this.base.plugins || this.pluginManagement != null && this.pluginManagement != this.base.pluginManagement)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation pluginsLocation = null;
            InputLocation pluginManagementLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                pluginsLocation = (InputLocation)locations.remove("plugins");
                pluginManagementLocation = (InputLocation)locations.remove("pluginManagement");
            }
            return new PluginConfiguration(this.plugins != null ? this.plugins : (this.base != null ? this.base.plugins : null), this.pluginManagement != null ? this.pluginManagement : (this.base != null ? this.base.pluginManagement : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), pluginsLocation != null ? pluginsLocation : (this.base != null ? this.base.pluginsLocation : null), pluginManagementLocation != null ? pluginManagementLocation : (this.base != null ? this.base.pluginManagementLocation : null));
        }
    }
}

