/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.DeploymentRepository;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Relocation;
import org.apache.maven.api.model.Site;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class DistributionManagement
implements Serializable,
InputLocationTracker {
    final DeploymentRepository repository;
    final DeploymentRepository snapshotRepository;
    final Site site;
    final String downloadUrl;
    final Relocation relocation;
    final String status;
    final InputLocation location;
    final InputLocation repositoryLocation;
    final InputLocation snapshotRepositoryLocation;
    final InputLocation siteLocation;
    final InputLocation downloadUrlLocation;
    final InputLocation relocationLocation;
    final InputLocation statusLocation;
    final Map<Object, InputLocation> locations;

    DistributionManagement(DeploymentRepository repository, DeploymentRepository snapshotRepository, Site site, String downloadUrl, Relocation relocation, String status, Map<Object, InputLocation> locations, InputLocation location, InputLocation repositoryLocation, InputLocation snapshotRepositoryLocation, InputLocation siteLocation, InputLocation downloadUrlLocation, InputLocation relocationLocation, InputLocation statusLocation) {
        this.repository = repository;
        this.snapshotRepository = snapshotRepository;
        this.site = site;
        this.downloadUrl = downloadUrl;
        this.relocation = relocation;
        this.status = status;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.repositoryLocation = repositoryLocation;
        this.snapshotRepositoryLocation = snapshotRepositoryLocation;
        this.siteLocation = siteLocation;
        this.downloadUrlLocation = downloadUrlLocation;
        this.relocationLocation = relocationLocation;
        this.statusLocation = statusLocation;
    }

    public DeploymentRepository getRepository() {
        return this.repository;
    }

    public DeploymentRepository getSnapshotRepository() {
        return this.snapshotRepository;
    }

    public Site getSite() {
        return this.site;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public Relocation getRelocation() {
        return this.relocation;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "repository": {
                    return this.repositoryLocation;
                }
                case "snapshotRepository": {
                    return this.snapshotRepositoryLocation;
                }
                case "site": {
                    return this.siteLocation;
                }
                case "downloadUrl": {
                    return this.downloadUrlLocation;
                }
                case "relocation": {
                    return this.relocationLocation;
                }
                case "status": {
                    return this.statusLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return DistributionManagement.newBuilder(this);
    }

    @Nonnull
    public DistributionManagement withRepository(DeploymentRepository repository) {
        return this.with().repository(repository).build();
    }

    @Nonnull
    public DistributionManagement withSnapshotRepository(DeploymentRepository snapshotRepository) {
        return this.with().snapshotRepository(snapshotRepository).build();
    }

    @Nonnull
    public DistributionManagement withSite(Site site) {
        return this.with().site(site).build();
    }

    @Nonnull
    public DistributionManagement withDownloadUrl(String downloadUrl) {
        return this.with().downloadUrl(downloadUrl).build();
    }

    @Nonnull
    public DistributionManagement withRelocation(Relocation relocation) {
        return this.with().relocation(relocation).build();
    }

    @Nonnull
    public DistributionManagement withStatus(String status) {
        return this.with().status(status).build();
    }

    @Nonnull
    public static DistributionManagement newInstance() {
        return DistributionManagement.newInstance(true);
    }

    @Nonnull
    public static DistributionManagement newInstance(boolean withDefaults) {
        return DistributionManagement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return DistributionManagement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(DistributionManagement from) {
        return DistributionManagement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(DistributionManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        DistributionManagement base;
        DeploymentRepository repository;
        DeploymentRepository snapshotRepository;
        Site site;
        String downloadUrl;
        Relocation relocation;
        String status;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(DistributionManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.repository = base.repository;
                this.snapshotRepository = base.snapshotRepository;
                this.site = base.site;
                this.downloadUrl = base.downloadUrl;
                this.relocation = base.relocation;
                this.status = base.status;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder repository(DeploymentRepository repository) {
            this.repository = repository;
            return this;
        }

        @Nonnull
        public Builder snapshotRepository(DeploymentRepository snapshotRepository) {
            this.snapshotRepository = snapshotRepository;
            return this;
        }

        @Nonnull
        public Builder site(Site site) {
            this.site = site;
            return this;
        }

        @Nonnull
        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        @Nonnull
        public Builder relocation(Relocation relocation) {
            this.relocation = relocation;
            return this;
        }

        @Nonnull
        public Builder status(String status) {
            this.status = status;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public DistributionManagement build() {
            if (!(this.base == null || this.repository != null && this.repository != this.base.repository || this.snapshotRepository != null && this.snapshotRepository != this.base.snapshotRepository || this.site != null && this.site != this.base.site || this.downloadUrl != null && this.downloadUrl != this.base.downloadUrl || this.relocation != null && this.relocation != this.base.relocation || this.status != null && this.status != this.base.status)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation repositoryLocation = null;
            InputLocation snapshotRepositoryLocation = null;
            InputLocation siteLocation = null;
            InputLocation downloadUrlLocation = null;
            InputLocation relocationLocation = null;
            InputLocation statusLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                repositoryLocation = locations.remove("repository");
                snapshotRepositoryLocation = locations.remove("snapshotRepository");
                siteLocation = locations.remove("site");
                downloadUrlLocation = locations.remove("downloadUrl");
                relocationLocation = locations.remove("relocation");
                statusLocation = locations.remove("status");
            }
            return new DistributionManagement(this.repository != null ? this.repository : (this.base != null ? this.base.repository : null), this.snapshotRepository != null ? this.snapshotRepository : (this.base != null ? this.base.snapshotRepository : null), this.site != null ? this.site : (this.base != null ? this.base.site : null), this.downloadUrl != null ? this.downloadUrl : (this.base != null ? this.base.downloadUrl : null), this.relocation != null ? this.relocation : (this.base != null ? this.base.relocation : null), this.status != null ? this.status : (this.base != null ? this.base.status : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), repositoryLocation != null ? repositoryLocation : (this.base != null ? this.base.repositoryLocation : null), snapshotRepositoryLocation != null ? snapshotRepositoryLocation : (this.base != null ? this.base.snapshotRepositoryLocation : null), siteLocation != null ? siteLocation : (this.base != null ? this.base.siteLocation : null), downloadUrlLocation != null ? downloadUrlLocation : (this.base != null ? this.base.downloadUrlLocation : null), relocationLocation != null ? relocationLocation : (this.base != null ? this.base.relocationLocation : null), statusLocation != null ? statusLocation : (this.base != null ? this.base.statusLocation : null));
        }
    }
}

