/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PluginContainer
implements Serializable,
InputLocationTracker {
    final List<Plugin> plugins;
    final InputLocation location;
    final InputLocation pluginsLocation;
    final Map<Object, InputLocation> locations;
    Map<String, Plugin> pluginMap;

    PluginContainer(Collection<Plugin> plugins, Map<Object, InputLocation> locations, InputLocation location, InputLocation pluginsLocation) {
        this.plugins = ImmutableCollections.copy(plugins);
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.pluginsLocation = pluginsLocation;
    }

    @Nonnull
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "plugins": {
                    return this.pluginsLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return PluginContainer.newBuilder(this);
    }

    @Nonnull
    public PluginContainer withPlugins(Collection<Plugin> plugins) {
        return this.with().plugins(plugins).build();
    }

    @Nonnull
    public static PluginContainer newInstance() {
        return PluginContainer.newInstance(true);
    }

    @Nonnull
    public static PluginContainer newInstance(boolean withDefaults) {
        return PluginContainer.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PluginContainer.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PluginContainer from) {
        return PluginContainer.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PluginContainer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public synchronized void flushPluginMap() {
        this.pluginMap = null;
    }

    public synchronized Map<String, Plugin> getPluginsAsMap() {
        if (this.pluginMap == null) {
            this.pluginMap = new LinkedHashMap<String, Plugin>();
            if (this.getPlugins() != null) {
                for (Plugin plugin : this.getPlugins()) {
                    this.pluginMap.put(plugin.getKey(), plugin);
                }
            }
        }
        return this.pluginMap;
    }

    @NotThreadSafe
    public static class Builder {
        PluginContainer base;
        Collection<Plugin> plugins;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(PluginContainer base, boolean forceCopy) {
            if (forceCopy) {
                this.plugins = base.plugins;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public PluginContainer build() {
            if (this.base != null && (this.plugins == null || this.plugins == this.base.plugins)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation pluginsLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                pluginsLocation = locations.remove("plugins");
            }
            return new PluginContainer(this.plugins != null ? this.plugins : (this.base != null ? this.base.plugins : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), pluginsLocation != null ? pluginsLocation : (this.base != null ? this.base.pluginsLocation : null));
        }
    }
}

