// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * A repository contains the information needed for establishing connections with
 * remote repository.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class RepositoryBase
    implements Serializable, InputLocationTracker
{
    /**
     * A unique identifier for a repository. This is used to match the repository
     * to configuration in the {@code settings.xml} file, for example. Furthermore, the identifier is
     * used during POM inheritance and profile injection to detect repositories that should be merged.
     */
    final String id;
    /**
     * Human readable name of the repository.
     */
    final String name;
    /**
     * The url of the repository, in the form {@code protocol://hostname/path}.
     */
    final String url;
    /**
     * The type of layout this repository uses for locating and storing artifacts -
     * can be {@code legacy} or {@code default}.
     */
    final String layout;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field id. */
    final InputLocation idLocation;
    /** Location of the xml element for the field name. */
    final InputLocation nameLocation;
    /** Location of the xml element for the field url. */
    final InputLocation urlLocation;
    /** Location of the xml element for the field layout. */
    final InputLocation layoutLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    RepositoryBase(
        String id,
        String name,
        String url,
        String layout,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation idLocation,
        InputLocation nameLocation,
        InputLocation urlLocation,
        InputLocation layoutLocation
    )
    {
        this.id = id;
        this.name = name;
        this.url = url;
        this.layout = layout;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.idLocation = idLocation;
        this.nameLocation = nameLocation;
        this.urlLocation = urlLocation;
        this.layoutLocation = layoutLocation;
    }

    @Override
    public boolean equals( Object o )
    {
        if ( this == o )
        {
            return true;
        }
        if ( o == null || !( o instanceof RepositoryBase ) )
        {
            return false;
        }
        RepositoryBase that = ( RepositoryBase ) o;
        return Objects.equals( this.id, that.id );
    }

    @Override
    public int hashCode()
    {
        return Objects.hash( id );
    }

    /**
     * A unique identifier for a repository. This is used to match the repository
     * to configuration in the {@code settings.xml} file, for example. Furthermore, the identifier is
     * used during POM inheritance and profile injection to detect repositories that should be merged.
     *
     * @return a {@code String}
     */
    public String getId()
    {
        return this.id;
    }

    /**
     * Human readable name of the repository.
     *
     * @return a {@code String}
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * The url of the repository, in the form {@code protocol://hostname/path}.
     *
     * @return a {@code String}
     */
    public String getUrl()
    {
        return this.url;
    }

    /**
     * The type of layout this repository uses for locating and storing artifacts -
     * can be {@code legacy} or {@code default}.
     *
     * @return a {@code String}
     */
    public String getLayout()
    {
        return this.layout;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "id":
                    return idLocation;
                case "name":
                    return nameLocation;
                case "url":
                    return urlLocation;
                case "layout":
                    return layoutLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified id
     */
    @Nonnull
    public RepositoryBase withId( String id )
    {
        return with().id( id ).build();
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified name
     */
    @Nonnull
    public RepositoryBase withName( String name )
    {
        return with().name( name ).build();
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified url
     */
    @Nonnull
    public RepositoryBase withUrl( String url )
    {
        return with().url( url ).build();
    }
    /**
     * Creates a new {@code RepositoryBase} instance using the specified layout.
     *
     * @param layout the new {@code String} to use
     * @return a {@code RepositoryBase} with the specified layout
     */
    @Nonnull
    public RepositoryBase withLayout( String layout )
    {
        return with().layout( layout ).build();
    }

    /**
     * Creates a new {@code RepositoryBase} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code RepositoryBase}
     */
    @Nonnull
    public static RepositoryBase newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code RepositoryBase} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code RepositoryBase}
     */
    @Nonnull
    public static RepositoryBase newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code RepositoryBase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( RepositoryBase from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code RepositoryBase} builder instance using the specified object as a basis.
     *
     * @param from the {@code RepositoryBase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( RepositoryBase from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create RepositoryBase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        RepositoryBase base;
        String id;
        String name;
        String url;
        String layout;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
                this.layout = "default";
            }
        }

        Builder( RepositoryBase base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.id = base.id;
                this.name = base.name;
                this.url = base.url;
                this.layout = base.layout;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id( String id )
        {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name( String name )
        {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url( String url )
        {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout( String layout )
        {
            this.layout = layout;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public RepositoryBase build()
        {
            if ( base != null
                    && ( id == null || id == base.id )
                    && ( name == null || name == base.name )
                    && ( url == null || url == base.url )
                    && ( layout == null || layout == base.layout )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation idLocation = null;
            InputLocation nameLocation = null;
            InputLocation urlLocation = null;
            InputLocation layoutLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                idLocation = locations.remove( "id" );
                nameLocation = locations.remove( "name" );
                urlLocation = locations.remove( "url" );
                layoutLocation = locations.remove( "layout" );
            }
            return new RepositoryBase(
                id != null ? id : ( base != null ? base.id : null ),
                name != null ? name : ( base != null ? base.name : null ),
                url != null ? url : ( base != null ? base.url : null ),
                layout != null ? layout : ( base != null ? base.layout : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                idLocation != null ? idLocation : ( base != null ? base.idLocation : null ),
                nameLocation != null ? nameLocation : ( base != null ? base.nameLocation : null ),
                urlLocation != null ? urlLocation : ( base != null ? base.urlLocation : null ),
                layoutLocation != null ? layoutLocation : ( base != null ? base.layoutLocation : null )
            );
        }
    }

}
