// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Definition of include or exclude patterns.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class PatternSet
    implements Serializable, InputLocationTracker
{
    /**
     * A list of patterns to include, e.g. {@code **&#47;*.xml}.
     */
    final List<String> includes;
    /**
     * A list of patterns to exclude, e.g. {@code **&#47;*.xml}
     */
    final List<String> excludes;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field includes. */
    final InputLocation includesLocation;
    /** Location of the xml element for the field excludes. */
    final InputLocation excludesLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    PatternSet(
        Collection<String> includes,
        Collection<String> excludes,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation includesLocation,
        InputLocation excludesLocation
    )
    {
        this.includes = ImmutableCollections.copy( includes );
        this.excludes = ImmutableCollections.copy( excludes );
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.includesLocation = includesLocation;
        this.excludesLocation = excludesLocation;
    }

    /**
     * A list of patterns to include, e.g. {@code **&#47;*.xml}.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getIncludes()
    {
        return this.includes;
    }

    /**
     * A list of patterns to exclude, e.g. {@code **&#47;*.xml}
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getExcludes()
    {
        return this.excludes;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "includes":
                    return includesLocation;
                case "excludes":
                    return excludesLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code PatternSet} instance using the specified includes.
     *
     * @param includes the new {@code Collection<String>} to use
     * @return a {@code PatternSet} with the specified includes
     */
    @Nonnull
    public PatternSet withIncludes( Collection<String> includes )
    {
        return with().includes( includes ).build();
    }
    /**
     * Creates a new {@code PatternSet} instance using the specified excludes.
     *
     * @param excludes the new {@code Collection<String>} to use
     * @return a {@code PatternSet} with the specified excludes
     */
    @Nonnull
    public PatternSet withExcludes( Collection<String> excludes )
    {
        return with().excludes( excludes ).build();
    }

    /**
     * Creates a new {@code PatternSet} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code PatternSet}
     */
    @Nonnull
    public static PatternSet newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code PatternSet} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code PatternSet}
     */
    @Nonnull
    public static PatternSet newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code PatternSet} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code PatternSet} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code PatternSet} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code PatternSet} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( PatternSet from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code PatternSet} builder instance using the specified object as a basis.
     *
     * @param from the {@code PatternSet} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( PatternSet from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create PatternSet instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        PatternSet base;
        Collection<String> includes;
        Collection<String> excludes;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( PatternSet base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.includes = base.includes;
                this.excludes = base.excludes;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder includes( Collection<String> includes )
        {
            this.includes = includes;
            return this;
        }

        @Nonnull
        public Builder excludes( Collection<String> excludes )
        {
            this.excludes = excludes;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public PatternSet build()
        {
            if ( base != null
                    && ( includes == null || includes == base.includes )
                    && ( excludes == null || excludes == base.excludes )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation includesLocation = null;
            InputLocation excludesLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                includesLocation = locations.remove( "includes" );
                excludesLocation = locations.remove( "excludes" );
            }
            return new PatternSet(
                includes != null ? includes : ( base != null ? base.includes : null ),
                excludes != null ? excludes : ( base != null ? base.excludes : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                includesLocation != null ? includesLocation : ( base != null ? base.includesLocation : null ),
                excludesLocation != null ? excludesLocation : ( base != null ? base.excludesLocation : null )
            );
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        StringBuilder sb = new StringBuilder( 128 );

        sb.append("PatternSet [includes: {");
        for (java.util.Iterator i = getIncludes().iterator(); i.hasNext(); )
        {
            String str = (String) i.next();
            sb.append(str).append(", ");
        }
        if (sb.substring(sb.length() - 2).equals(", ")) sb.delete(sb.length() - 2, sb.length());

        sb.append("}, excludes: {");
        for (java.util.Iterator i = getExcludes().iterator(); i.hasNext(); )
        {
            String str = (String) i.next();
            sb.append(str).append(", ");
        }
        if (sb.substring(sb.length() - 2).equals(", ")) sb.delete(sb.length() - 2, sb.length());

        sb.append("}]");
        return sb.toString();
    }
            
          
}
