// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Configures one method for notifying users/developers when a build breaks.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Notifier
    implements Serializable, InputLocationTracker
{
    /**
     * The mechanism used to deliver notifications.
     */
    final String type;
    /**
     * Whether to send notifications on error.
     */
    final boolean sendOnError;
    /**
     * Whether to send notifications on failure.
     */
    final boolean sendOnFailure;
    /**
     * Whether to send notifications on success.
     */
    final boolean sendOnSuccess;
    /**
     * Whether to send notifications on warning.
     */
    final boolean sendOnWarning;
    /**
     * <b>Deprecated</b>. Where to send the notification to - eg email address.
     */
    final String address;
    /**
     * Extended configuration specific to this notifier goes here.
     */
    final Map<String, String> configuration;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field type. */
    final InputLocation typeLocation;
    /** Location of the xml element for the field sendOnError. */
    final InputLocation sendOnErrorLocation;
    /** Location of the xml element for the field sendOnFailure. */
    final InputLocation sendOnFailureLocation;
    /** Location of the xml element for the field sendOnSuccess. */
    final InputLocation sendOnSuccessLocation;
    /** Location of the xml element for the field sendOnWarning. */
    final InputLocation sendOnWarningLocation;
    /** Location of the xml element for the field address. */
    final InputLocation addressLocation;
    /** Location of the xml element for the field configuration. */
    final InputLocation configurationLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Notifier(
        String type,
        boolean sendOnError,
        boolean sendOnFailure,
        boolean sendOnSuccess,
        boolean sendOnWarning,
        String address,
        Map<String, String> configuration,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation typeLocation,
        InputLocation sendOnErrorLocation,
        InputLocation sendOnFailureLocation,
        InputLocation sendOnSuccessLocation,
        InputLocation sendOnWarningLocation,
        InputLocation addressLocation,
        InputLocation configurationLocation
    )
    {
        this.type = type;
        this.sendOnError = sendOnError;
        this.sendOnFailure = sendOnFailure;
        this.sendOnSuccess = sendOnSuccess;
        this.sendOnWarning = sendOnWarning;
        this.address = address;
        this.configuration = ImmutableCollections.copy( configuration );
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.typeLocation = typeLocation;
        this.sendOnErrorLocation = sendOnErrorLocation;
        this.sendOnFailureLocation = sendOnFailureLocation;
        this.sendOnSuccessLocation = sendOnSuccessLocation;
        this.sendOnWarningLocation = sendOnWarningLocation;
        this.addressLocation = addressLocation;
        this.configurationLocation = configurationLocation;
    }

    /**
     * The mechanism used to deliver notifications.
     *
     * @return a {@code String}
     */
    public String getType()
    {
        return this.type;
    }

    /**
     * Whether to send notifications on error.
     *
     * @return a {@code boolean}
     */
    public boolean isSendOnError()
    {
        return this.sendOnError;
    }

    /**
     * Whether to send notifications on failure.
     *
     * @return a {@code boolean}
     */
    public boolean isSendOnFailure()
    {
        return this.sendOnFailure;
    }

    /**
     * Whether to send notifications on success.
     *
     * @return a {@code boolean}
     */
    public boolean isSendOnSuccess()
    {
        return this.sendOnSuccess;
    }

    /**
     * Whether to send notifications on warning.
     *
     * @return a {@code boolean}
     */
    public boolean isSendOnWarning()
    {
        return this.sendOnWarning;
    }

    /**
     * <b>Deprecated</b>. Where to send the notification to - eg email address.
     *
     * @return a {@code String}
     */
    public String getAddress()
    {
        return this.address;
    }

    /**
     * Extended configuration specific to this notifier goes here.
     *
     * @return a {@code Map<String, String>}
     */
    @Nonnull
    public Map<String, String> getConfiguration()
    {
        return this.configuration;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "type":
                    return typeLocation;
                case "sendOnError":
                    return sendOnErrorLocation;
                case "sendOnFailure":
                    return sendOnFailureLocation;
                case "sendOnSuccess":
                    return sendOnSuccessLocation;
                case "sendOnWarning":
                    return sendOnWarningLocation;
                case "address":
                    return addressLocation;
                case "configuration":
                    return configurationLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Notifier} instance using the specified type.
     *
     * @param type the new {@code String} to use
     * @return a {@code Notifier} with the specified type
     */
    @Nonnull
    public Notifier withType( String type )
    {
        return with().type( type ).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified sendOnError.
     *
     * @param sendOnError the new {@code boolean} to use
     * @return a {@code Notifier} with the specified sendOnError
     */
    @Nonnull
    public Notifier withSendOnError( boolean sendOnError )
    {
        return with().sendOnError( sendOnError ).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified sendOnFailure.
     *
     * @param sendOnFailure the new {@code boolean} to use
     * @return a {@code Notifier} with the specified sendOnFailure
     */
    @Nonnull
    public Notifier withSendOnFailure( boolean sendOnFailure )
    {
        return with().sendOnFailure( sendOnFailure ).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified sendOnSuccess.
     *
     * @param sendOnSuccess the new {@code boolean} to use
     * @return a {@code Notifier} with the specified sendOnSuccess
     */
    @Nonnull
    public Notifier withSendOnSuccess( boolean sendOnSuccess )
    {
        return with().sendOnSuccess( sendOnSuccess ).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified sendOnWarning.
     *
     * @param sendOnWarning the new {@code boolean} to use
     * @return a {@code Notifier} with the specified sendOnWarning
     */
    @Nonnull
    public Notifier withSendOnWarning( boolean sendOnWarning )
    {
        return with().sendOnWarning( sendOnWarning ).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified address.
     *
     * @param address the new {@code String} to use
     * @return a {@code Notifier} with the specified address
     */
    @Nonnull
    public Notifier withAddress( String address )
    {
        return with().address( address ).build();
    }
    /**
     * Creates a new {@code Notifier} instance using the specified configuration.
     *
     * @param configuration the new {@code Map<String, String>} to use
     * @return a {@code Notifier} with the specified configuration
     */
    @Nonnull
    public Notifier withConfiguration( Map<String, String> configuration )
    {
        return with().configuration( configuration ).build();
    }

    /**
     * Creates a new {@code Notifier} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Notifier}
     */
    @Nonnull
    public static Notifier newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Notifier} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Notifier}
     */
    @Nonnull
    public static Notifier newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Notifier} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Notifier} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Notifier} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Notifier} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Notifier from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Notifier} builder instance using the specified object as a basis.
     *
     * @param from the {@code Notifier} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Notifier from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Notifier instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Notifier base;
        String type;
        Boolean sendOnError;
        Boolean sendOnFailure;
        Boolean sendOnSuccess;
        Boolean sendOnWarning;
        String address;
        Map<String, String> configuration;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
                this.type = "mail";
                this.sendOnError = true;
                this.sendOnFailure = true;
                this.sendOnSuccess = true;
                this.sendOnWarning = true;
            }
        }

        Builder( Notifier base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.type = base.type;
                this.sendOnError = base.sendOnError;
                this.sendOnFailure = base.sendOnFailure;
                this.sendOnSuccess = base.sendOnSuccess;
                this.sendOnWarning = base.sendOnWarning;
                this.address = base.address;
                this.configuration = base.configuration;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder type( String type )
        {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder sendOnError( boolean sendOnError )
        {
            this.sendOnError = sendOnError;
            return this;
        }

        @Nonnull
        public Builder sendOnFailure( boolean sendOnFailure )
        {
            this.sendOnFailure = sendOnFailure;
            return this;
        }

        @Nonnull
        public Builder sendOnSuccess( boolean sendOnSuccess )
        {
            this.sendOnSuccess = sendOnSuccess;
            return this;
        }

        @Nonnull
        public Builder sendOnWarning( boolean sendOnWarning )
        {
            this.sendOnWarning = sendOnWarning;
            return this;
        }

        @Nonnull
        public Builder address( String address )
        {
            this.address = address;
            return this;
        }

        @Nonnull
        public Builder configuration( Map<String, String> configuration )
        {
            this.configuration = configuration;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public Notifier build()
        {
            if ( base != null
                    && ( type == null || type == base.type )
                    && ( sendOnError == null || sendOnError == base.sendOnError )
                    && ( sendOnFailure == null || sendOnFailure == base.sendOnFailure )
                    && ( sendOnSuccess == null || sendOnSuccess == base.sendOnSuccess )
                    && ( sendOnWarning == null || sendOnWarning == base.sendOnWarning )
                    && ( address == null || address == base.address )
                    && ( configuration == null || configuration == base.configuration )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation typeLocation = null;
            InputLocation sendOnErrorLocation = null;
            InputLocation sendOnFailureLocation = null;
            InputLocation sendOnSuccessLocation = null;
            InputLocation sendOnWarningLocation = null;
            InputLocation addressLocation = null;
            InputLocation configurationLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                typeLocation = locations.remove( "type" );
                sendOnErrorLocation = locations.remove( "sendOnError" );
                sendOnFailureLocation = locations.remove( "sendOnFailure" );
                sendOnSuccessLocation = locations.remove( "sendOnSuccess" );
                sendOnWarningLocation = locations.remove( "sendOnWarning" );
                addressLocation = locations.remove( "address" );
                configurationLocation = locations.remove( "configuration" );
            }
            return new Notifier(
                type != null ? type : ( base != null ? base.type : null ),
                sendOnError != null ? sendOnError : ( base != null ? base.sendOnError : true ),
                sendOnFailure != null ? sendOnFailure : ( base != null ? base.sendOnFailure : true ),
                sendOnSuccess != null ? sendOnSuccess : ( base != null ? base.sendOnSuccess : true ),
                sendOnWarning != null ? sendOnWarning : ( base != null ? base.sendOnWarning : true ),
                address != null ? address : ( base != null ? base.address : null ),
                configuration != null ? configuration : ( base != null ? base.configuration : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                typeLocation != null ? typeLocation : ( base != null ? base.typeLocation : null ),
                sendOnErrorLocation != null ? sendOnErrorLocation : ( base != null ? base.sendOnErrorLocation : null ),
                sendOnFailureLocation != null ? sendOnFailureLocation : ( base != null ? base.sendOnFailureLocation : null ),
                sendOnSuccessLocation != null ? sendOnSuccessLocation : ( base != null ? base.sendOnSuccessLocation : null ),
                sendOnWarningLocation != null ? sendOnWarningLocation : ( base != null ? base.sendOnWarningLocation : null ),
                addressLocation != null ? addressLocation : ( base != null ? base.addressLocation : null ),
                configurationLocation != null ? configurationLocation : ( base != null ? base.configurationLocation : null )
            );
        }
    }

}
