// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.Dom;

/**
 * Contains the configuration information of the container like Plugin.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ConfigurationContainer
    implements Serializable, InputLocationTracker
{
    /**
     * Whether any configuration should be propagated to child POMs. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code true}.
     */
    final String inherited;
    /**
     * <p>The configuration as DOM object.</p>
     * <p>By default, every element content is trimmed, but starting with Maven 3.1.0, you can add
     * {@code xml:space="preserve"} to elements you want to preserve whitespace.</p>
     * <p>You can control how child POMs inherit configuration from parent POMs by adding {@code combine.children}
     * or {@code combine.self} attributes to the children of the configuration element:</p>
     * <ul>
     * <li>{@code combine.children}: available values are {@code merge} (default) and {@code append},</li>
     * <li>{@code combine.self}: available values are {@code merge} (default) and {@code override}.</li>
     * </ul>
     * <p>See <a href="https://maven.apache.org/pom.html#Plugins">POM Reference documentation</a> and
     * <a href="https://codehaus-plexus.github.io/plexus-utils/apidocs/org/codehaus/plexus/util/xml/Xpp3DomUtils.html">Xpp3DomUtils</a>
     * for more information.</p>
     */
    final Dom configuration;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field inherited. */
    final InputLocation inheritedLocation;
    /** Location of the xml element for the field configuration. */
    final InputLocation configurationLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    ConfigurationContainer(
        String inherited,
        Dom configuration,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation inheritedLocation,
        InputLocation configurationLocation
    )
    {
        this.inherited = inherited;
        this.configuration = configuration;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.inheritedLocation = inheritedLocation;
        this.configurationLocation = configurationLocation;
    }

    /**
     * Whether any configuration should be propagated to child POMs. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code true}.
     *
     * @return a {@code String}
     */
    public String getInherited()
    {
        return this.inherited;
    }

    /**
     * <p>The configuration as DOM object.</p>
     * <p>By default, every element content is trimmed, but starting with Maven 3.1.0, you can add
     * {@code xml:space="preserve"} to elements you want to preserve whitespace.</p>
     * <p>You can control how child POMs inherit configuration from parent POMs by adding {@code combine.children}
     * or {@code combine.self} attributes to the children of the configuration element:</p>
     * <ul>
     * <li>{@code combine.children}: available values are {@code merge} (default) and {@code append},</li>
     * <li>{@code combine.self}: available values are {@code merge} (default) and {@code override}.</li>
     * </ul>
     * <p>See <a href="https://maven.apache.org/pom.html#Plugins">POM Reference documentation</a> and
     * <a href="https://codehaus-plexus.github.io/plexus-utils/apidocs/org/codehaus/plexus/util/xml/Xpp3DomUtils.html">Xpp3DomUtils</a>
     * for more information.</p>
     *
     * @return a {@code Dom}
     */
    public Dom getConfiguration()
    {
        return this.configuration;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "inherited":
                    return inheritedLocation;
                case "configuration":
                    return configurationLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code ConfigurationContainer} instance using the specified inherited.
     *
     * @param inherited the new {@code String} to use
     * @return a {@code ConfigurationContainer} with the specified inherited
     */
    @Nonnull
    public ConfigurationContainer withInherited( String inherited )
    {
        return with().inherited( inherited ).build();
    }
    /**
     * Creates a new {@code ConfigurationContainer} instance using the specified configuration.
     *
     * @param configuration the new {@code Dom} to use
     * @return a {@code ConfigurationContainer} with the specified configuration
     */
    @Nonnull
    public ConfigurationContainer withConfiguration( Dom configuration )
    {
        return with().configuration( configuration ).build();
    }

    /**
     * Creates a new {@code ConfigurationContainer} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ConfigurationContainer}
     */
    @Nonnull
    public static ConfigurationContainer newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code ConfigurationContainer} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ConfigurationContainer}
     */
    @Nonnull
    public static ConfigurationContainer newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code ConfigurationContainer} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code ConfigurationContainer} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code ConfigurationContainer} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code ConfigurationContainer} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ConfigurationContainer from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code ConfigurationContainer} builder instance using the specified object as a basis.
     *
     * @param from the {@code ConfigurationContainer} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ConfigurationContainer from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create ConfigurationContainer instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        ConfigurationContainer base;
        String inherited;
        Dom configuration;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( ConfigurationContainer base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.inherited = base.inherited;
                this.configuration = base.configuration;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder inherited( String inherited )
        {
            this.inherited = inherited;
            return this;
        }

        @Nonnull
        public Builder configuration( Dom configuration )
        {
            this.configuration = configuration;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public ConfigurationContainer build()
        {
            if ( base != null
                    && ( inherited == null || inherited == base.inherited )
                    && ( configuration == null || configuration == base.configuration )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation inheritedLocation = null;
            InputLocation configurationLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                inheritedLocation = locations.remove( "inherited" );
                configurationLocation = locations.remove( "configuration" );
            }
            return new ConfigurationContainer(
                inherited != null ? inherited : ( base != null ? base.inherited : null ),
                configuration != null ? configuration : ( base != null ? base.configuration : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                inheritedLocation != null ? inheritedLocation : ( base != null ? base.inheritedLocation : null ),
                configurationLocation != null ? configurationLocation : ( base != null ? base.configurationLocation : null )
            );
        }
    }


            
    public boolean isInherited()
    {
        return ( getInherited() != null ) ? Boolean.parseBoolean( getInherited() ) : true;
    }

            
          
}
