// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Build configuration in a profile.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class BuildBase
    extends PluginConfiguration
    implements Serializable, InputLocationTracker
{
    /**
     * The default goal (or phase in Maven 2) to execute when none is specified for
     * the project. Note that in case of a multi-module build, only the default goal of the top-level
     * project is relevant, i.e. the default goals of child modules are ignored. Since Maven 3,
     * multiple goals/phases can be separated by whitespace.
     */
    final String defaultGoal;
    /**
     * This element describes all of the classpath resources such as properties
     * files associated with a project. These resources are often included in the final
     * package.
     * The default value is {@code src/main/resources}.
     */
    final List<Resource> resources;
    /**
     * This element describes all of the classpath resources such as properties
     * files associated with a project's unit tests.
     * The default value is {@code src/test/resources}.
     */
    final List<Resource> testResources;
    /**
     * The directory where all files generated by the build are placed.
     * The default value is {@code target}.
     */
    final String directory;
    /**
     * The filename (excluding the extension, and with no path information) that
     * the produced artifact will be called.
     * The default value is {@code ${artifactId}-${version}}.
     */
    final String finalName;
    /**
     * The list of filter properties files that are used when filtering is enabled.
     */
    final List<String> filters;
    /** Location of the xml element for the field defaultGoal. */
    final InputLocation defaultGoalLocation;
    /** Location of the xml element for the field resources. */
    final InputLocation resourcesLocation;
    /** Location of the xml element for the field testResources. */
    final InputLocation testResourcesLocation;
    /** Location of the xml element for the field directory. */
    final InputLocation directoryLocation;
    /** Location of the xml element for the field finalName. */
    final InputLocation finalNameLocation;
    /** Location of the xml element for the field filters. */
    final InputLocation filtersLocation;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    BuildBase(
        Collection<Plugin> plugins,
        PluginManagement pluginManagement,
        String defaultGoal,
        Collection<Resource> resources,
        Collection<Resource> testResources,
        String directory,
        String finalName,
        Collection<String> filters,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation pluginsLocation,
        InputLocation pluginManagementLocation,
        InputLocation defaultGoalLocation,
        InputLocation resourcesLocation,
        InputLocation testResourcesLocation,
        InputLocation directoryLocation,
        InputLocation finalNameLocation,
        InputLocation filtersLocation
    )
    {
        super(
            plugins,
            pluginManagement,
            locations,
            location,
            pluginsLocation,
            pluginManagementLocation
        );
        this.defaultGoal = defaultGoal;
        this.resources = ImmutableCollections.copy( resources );
        this.testResources = ImmutableCollections.copy( testResources );
        this.directory = directory;
        this.finalName = finalName;
        this.filters = ImmutableCollections.copy( filters );
        this.defaultGoalLocation = defaultGoalLocation;
        this.resourcesLocation = resourcesLocation;
        this.testResourcesLocation = testResourcesLocation;
        this.directoryLocation = directoryLocation;
        this.finalNameLocation = finalNameLocation;
        this.filtersLocation = filtersLocation;
    }

    /**
     * The default goal (or phase in Maven 2) to execute when none is specified for
     * the project. Note that in case of a multi-module build, only the default goal of the top-level
     * project is relevant, i.e. the default goals of child modules are ignored. Since Maven 3,
     * multiple goals/phases can be separated by whitespace.
     *
     * @return a {@code String}
     */
    public String getDefaultGoal()
    {
        return this.defaultGoal;
    }

    /**
     * This element describes all of the classpath resources such as properties
     * files associated with a project. These resources are often included in the final
     * package.
     * The default value is {@code src/main/resources}.
     *
     * @return a {@code List<Resource>}
     */
    @Nonnull
    public List<Resource> getResources()
    {
        return this.resources;
    }

    /**
     * This element describes all of the classpath resources such as properties
     * files associated with a project's unit tests.
     * The default value is {@code src/test/resources}.
     *
     * @return a {@code List<Resource>}
     */
    @Nonnull
    public List<Resource> getTestResources()
    {
        return this.testResources;
    }

    /**
     * The directory where all files generated by the build are placed.
     * The default value is {@code target}.
     *
     * @return a {@code String}
     */
    public String getDirectory()
    {
        return this.directory;
    }

    /**
     * The filename (excluding the extension, and with no path information) that
     * the produced artifact will be called.
     * The default value is {@code ${artifactId}-${version}}.
     *
     * @return a {@code String}
     */
    public String getFinalName()
    {
        return this.finalName;
    }

    /**
     * The list of filter properties files that are used when filtering is enabled.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getFilters()
    {
        return this.filters;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "defaultGoal":
                    return defaultGoalLocation;
                case "resources":
                    return resourcesLocation;
                case "testResources":
                    return testResourcesLocation;
                case "directory":
                    return directoryLocation;
                case "finalName":
                    return finalNameLocation;
                case "filters":
                    return filtersLocation;
            }
        }
        return super.getLocation( key );
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<Plugin>} to use
     * @return a {@code BuildBase} with the specified plugins
     */
    @Nonnull
    public BuildBase withPlugins( Collection<Plugin> plugins )
    {
        return with().plugins( plugins ).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified pluginManagement.
     *
     * @param pluginManagement the new {@code PluginManagement} to use
     * @return a {@code BuildBase} with the specified pluginManagement
     */
    @Nonnull
    public BuildBase withPluginManagement( PluginManagement pluginManagement )
    {
        return with().pluginManagement( pluginManagement ).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified defaultGoal.
     *
     * @param defaultGoal the new {@code String} to use
     * @return a {@code BuildBase} with the specified defaultGoal
     */
    @Nonnull
    public BuildBase withDefaultGoal( String defaultGoal )
    {
        return with().defaultGoal( defaultGoal ).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified resources.
     *
     * @param resources the new {@code Collection<Resource>} to use
     * @return a {@code BuildBase} with the specified resources
     */
    @Nonnull
    public BuildBase withResources( Collection<Resource> resources )
    {
        return with().resources( resources ).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified testResources.
     *
     * @param testResources the new {@code Collection<Resource>} to use
     * @return a {@code BuildBase} with the specified testResources
     */
    @Nonnull
    public BuildBase withTestResources( Collection<Resource> testResources )
    {
        return with().testResources( testResources ).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified directory.
     *
     * @param directory the new {@code String} to use
     * @return a {@code BuildBase} with the specified directory
     */
    @Nonnull
    public BuildBase withDirectory( String directory )
    {
        return with().directory( directory ).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified finalName.
     *
     * @param finalName the new {@code String} to use
     * @return a {@code BuildBase} with the specified finalName
     */
    @Nonnull
    public BuildBase withFinalName( String finalName )
    {
        return with().finalName( finalName ).build();
    }
    /**
     * Creates a new {@code BuildBase} instance using the specified filters.
     *
     * @param filters the new {@code Collection<String>} to use
     * @return a {@code BuildBase} with the specified filters
     */
    @Nonnull
    public BuildBase withFilters( Collection<String> filters )
    {
        return with().filters( filters ).build();
    }

    /**
     * Creates a new {@code BuildBase} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code BuildBase}
     */
    @Nonnull
    public static BuildBase newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code BuildBase} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code BuildBase}
     */
    @Nonnull
    public static BuildBase newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code BuildBase} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code BuildBase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code BuildBase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code BuildBase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( BuildBase from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code BuildBase} builder instance using the specified object as a basis.
     *
     * @param from the {@code BuildBase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( BuildBase from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create BuildBase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends PluginConfiguration.Builder
    {
        BuildBase base;
        String defaultGoal;
        Collection<Resource> resources;
        Collection<Resource> testResources;
        String directory;
        String finalName;
        Collection<String> filters;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
            }
        }

        Builder( BuildBase base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.defaultGoal = base.defaultGoal;
                this.resources = base.resources;
                this.testResources = base.testResources;
                this.directory = base.directory;
                this.finalName = base.finalName;
                this.filters = base.filters;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins( Collection<Plugin> plugins )
        {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder pluginManagement( PluginManagement pluginManagement )
        {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Nonnull
        public Builder defaultGoal( String defaultGoal )
        {
            this.defaultGoal = defaultGoal;
            return this;
        }

        @Nonnull
        public Builder resources( Collection<Resource> resources )
        {
            this.resources = resources;
            return this;
        }

        @Nonnull
        public Builder testResources( Collection<Resource> testResources )
        {
            this.testResources = testResources;
            return this;
        }

        @Nonnull
        public Builder directory( String directory )
        {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder finalName( String finalName )
        {
            this.finalName = finalName;
            return this;
        }

        @Nonnull
        public Builder filters( Collection<String> filters )
        {
            this.filters = filters;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public BuildBase build()
        {
            if ( base != null
                    && ( plugins == null || plugins == base.plugins )
                    && ( pluginManagement == null || pluginManagement == base.pluginManagement )
                    && ( defaultGoal == null || defaultGoal == base.defaultGoal )
                    && ( resources == null || resources == base.resources )
                    && ( testResources == null || testResources == base.testResources )
                    && ( directory == null || directory == base.directory )
                    && ( finalName == null || finalName == base.finalName )
                    && ( filters == null || filters == base.filters )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation pluginsLocation = null;
            InputLocation pluginManagementLocation = null;
            InputLocation defaultGoalLocation = null;
            InputLocation resourcesLocation = null;
            InputLocation testResourcesLocation = null;
            InputLocation directoryLocation = null;
            InputLocation finalNameLocation = null;
            InputLocation filtersLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                pluginsLocation = locations.remove( "plugins" );
                pluginManagementLocation = locations.remove( "pluginManagement" );
                defaultGoalLocation = locations.remove( "defaultGoal" );
                resourcesLocation = locations.remove( "resources" );
                testResourcesLocation = locations.remove( "testResources" );
                directoryLocation = locations.remove( "directory" );
                finalNameLocation = locations.remove( "finalName" );
                filtersLocation = locations.remove( "filters" );
            }
            return new BuildBase(
                plugins != null ? plugins : ( base != null ? base.plugins : null ),
                pluginManagement != null ? pluginManagement : ( base != null ? base.pluginManagement : null ),
                defaultGoal != null ? defaultGoal : ( base != null ? base.defaultGoal : null ),
                resources != null ? resources : ( base != null ? base.resources : null ),
                testResources != null ? testResources : ( base != null ? base.testResources : null ),
                directory != null ? directory : ( base != null ? base.directory : null ),
                finalName != null ? finalName : ( base != null ? base.finalName : null ),
                filters != null ? filters : ( base != null ? base.filters : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                pluginsLocation != null ? pluginsLocation : ( base != null ? base.pluginsLocation : null ),
                pluginManagementLocation != null ? pluginManagementLocation : ( base != null ? base.pluginManagementLocation : null ),
                defaultGoalLocation != null ? defaultGoalLocation : ( base != null ? base.defaultGoalLocation : null ),
                resourcesLocation != null ? resourcesLocation : ( base != null ? base.resourcesLocation : null ),
                testResourcesLocation != null ? testResourcesLocation : ( base != null ? base.testResourcesLocation : null ),
                directoryLocation != null ? directoryLocation : ( base != null ? base.directoryLocation : null ),
                finalNameLocation != null ? finalNameLocation : ( base != null ? base.finalNameLocation : null ),
                filtersLocation != null ? filtersLocation : ( base != null ? base.filtersLocation : null )
            );
        }
    }

}
