/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.Session;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelRepositoryHolder;
import org.apache.maven.api.services.ModelResolver;
import org.apache.maven.api.services.ModelResolverException;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.model.ModelProblemUtils;
import org.apache.maven.internal.impl.resolver.ArtifactDescriptorReaderDelegate;
import org.apache.maven.internal.impl.resolver.ArtifactDescriptorUtils;
import org.apache.maven.internal.impl.resolver.DefaultModelCache;
import org.apache.maven.internal.impl.resolver.DefaultModelRepositoryHolder;
import org.apache.maven.internal.impl.resolver.DefaultModelResolver;
import org.apache.maven.internal.impl.resolver.MavenArtifactRelocationSource;
import org.apache.maven.internal.impl.resolver.MavenWorkspaceReader;
import org.apache.maven.internal.impl.resolver.RequestTraceHelper;
import org.codehaus.plexus.interpolation.util.StringUtils;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicyRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultArtifactDescriptorReader
implements ArtifactDescriptorReader {
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final VersionResolver versionResolver;
    private final VersionRangeResolver versionRangeResolver;
    private final ArtifactResolver artifactResolver;
    private final RepositoryEventDispatcher repositoryEventDispatcher;
    private final ModelBuilder modelBuilder;
    private final Map<String, MavenArtifactRelocationSource> artifactRelocationSources;
    private final ArtifactDescriptorReaderDelegate delegate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Inject
    public DefaultArtifactDescriptorReader(RemoteRepositoryManager remoteRepositoryManager, VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher, Map<String, MavenArtifactRelocationSource> artifactRelocationSources) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remoteRepositoryManager cannot be null");
        this.versionResolver = Objects.requireNonNull(versionResolver, "versionResolver cannot be null");
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "versionRangeResolver cannot be null");
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifactResolver cannot be null");
        this.modelBuilder = Objects.requireNonNull(modelBuilder, "modelBuilder cannot be null");
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null");
        this.artifactRelocationSources = Objects.requireNonNull(artifactRelocationSources, "artifactRelocationSources cannot be null");
        this.delegate = new ArtifactDescriptorReaderDelegate();
    }

    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        Model model = this.loadPom(session, request, result);
        if (model != null) {
            Map config = session.getConfigProperties();
            ArtifactDescriptorReaderDelegate delegate = (ArtifactDescriptorReaderDelegate)config.get(ArtifactDescriptorReaderDelegate.class.getName());
            if (delegate == null) {
                delegate = this.delegate;
            }
            delegate.populateResult(InternalSession.from(session), result, model);
        }
        return result;
    }

    private Model loadPom(RepositorySystemSession session, ArtifactDescriptorRequest request, ArtifactDescriptorResult result) throws ArtifactDescriptorException {
        Model model;
        RequestTrace trace = RequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        LinkedHashSet<CallSite> visited = new LinkedHashSet<CallSite>();
        Artifact a = request.getArtifact();
        while (true) {
            Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifactUnconditionally(a);
            try {
                VersionRequest versionRequest = new VersionRequest(a, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                a = a.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                pomArtifact = pomArtifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e) {
                result.addException((Exception)((Object)e));
                throw new ArtifactDescriptorException(result);
            }
            if (!visited.add((CallSite)((Object)(a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getBaseVersion())))) {
                RepositoryException exception = new RepositoryException("Artifact relocations form a cycle: " + String.valueOf(visited));
                this.invalidDescriptor(session, trace, a, (Exception)exception);
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException((Exception)exception);
                throw new ArtifactDescriptorException(result);
            }
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                resolveRequest.setTrace(trace);
                ArtifactResult resolveResult = this.artifactResolver.resolveArtifact(session, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                result.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e) {
                if (e.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(session, trace, a, (Exception)e.getCause());
                    if ((this.getPolicy(session, a, request) & 1) != 0) {
                        return null;
                    }
                }
                result.addException((Exception)((Object)e));
                throw new ArtifactDescriptorException(result);
            }
            WorkspaceReader workspace = session.getWorkspaceReader();
            if (workspace instanceof MavenWorkspaceReader && (model = ((MavenWorkspaceReader)workspace).findModel(pomArtifact)) != null) {
                return model;
            }
            try {
                InternalSession iSession = InternalSession.from(session);
                Session iSessionWithRepos = iSession.withRemoteRepositories(request.getRepositories().stream().map(iSession::getRemoteRepository).toList());
                String gav = pomArtifact.getGroupId() + ":" + pomArtifact.getArtifactId() + ":" + pomArtifact.getVersion();
                DefaultModelResolver modelResolver = new DefaultModelResolver();
                DefaultModelRepositoryHolder modelRepositoryHolder = new DefaultModelRepositoryHolder(iSessionWithRepos, DefaultModelRepositoryHolder.RepositoryMerging.REQUEST_DOMINANT, iSessionWithRepos.getRemoteRepositories());
                ModelBuilderRequest modelRequest = ModelBuilderRequest.builder().session(iSessionWithRepos).projectBuild(false).processPlugins(false).twoPhaseBuilding(false).source(ModelSource.fromPath((Path)pomArtifact.getPath(), (String)gav)).systemProperties(this.toProperties(session.getUserProperties(), session.getSystemProperties())).userProperties(Map.of()).modelResolver((ModelResolver)modelResolver).modelRepositoryHolder((ModelRepositoryHolder)modelRepositoryHolder).modelCache(DefaultModelCache.newInstance(session, false)).build();
                ModelBuilderResult modelResult = this.modelBuilder.build(modelRequest);
                if (!modelResult.getProblems().isEmpty()) {
                    List problems = modelResult.getProblems();
                    if (this.logger.isDebugEnabled()) {
                        String problem = problems.size() == 1 ? "problem" : "problems";
                        String problemPredicate = problem + (problems.size() == 1 ? " was" : " were");
                        Object message = String.format("%s %s encountered while building the effective model for %s during %s\n", problems.size(), problemPredicate, request.getArtifact(), RequestTraceHelper.interpretTrace(true, request.getTrace()));
                        message = (String)message + StringUtils.capitalizeFirstLetter((String)problem);
                        for (ModelProblem modelProblem : problems) {
                            message = (String)message + String.format("\n* %s @ %s", modelProblem.getMessage(), ModelProblemUtils.formatLocation(modelProblem, null));
                        }
                        this.logger.warn((String)message);
                    } else {
                        this.logger.warn("{} {} encountered while building the effective model for {} during {} (use -X to see details)", new Object[]{problems.size(), problems.size() == 1 ? "problem was" : "problems were", request.getArtifact(), RequestTraceHelper.interpretTrace(false, request.getTrace())});
                    }
                }
                model = modelResult.getEffectiveModel();
            }
            catch (ModelBuilderException e) {
                for (ModelProblem problem : e.getResult().getProblems()) {
                    if (!(problem.getException() instanceof ModelResolverException)) continue;
                    result.addException(problem.getException());
                    throw new ArtifactDescriptorException(result);
                }
                this.invalidDescriptor(session, trace, a, (Exception)((Object)e));
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException((Exception)((Object)e));
                throw new ArtifactDescriptorException(result);
            }
            Artifact relocatedArtifact = this.getRelocation(session, result, model);
            if (relocatedArtifact == null) break;
            if (this.withinSameGav(relocatedArtifact, a)) {
                result.setArtifact(relocatedArtifact);
                return model;
            }
            result.addRelocation(a);
            a = relocatedArtifact;
            result.setArtifact(a);
        }
        return model;
    }

    private boolean withinSameGav(Artifact a1, Artifact a2) {
        return Objects.equals(a1.getGroupId(), a2.getGroupId()) && Objects.equals(a1.getArtifactId(), a2.getArtifactId()) && Objects.equals(a1.getVersion(), a2.getVersion());
    }

    private Map<String, String> toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    private Artifact getRelocation(RepositorySystemSession session, ArtifactDescriptorResult artifactDescriptorResult, Model model) throws ArtifactDescriptorException {
        MavenArtifactRelocationSource source;
        Artifact result = null;
        Iterator<MavenArtifactRelocationSource> iterator = this.artifactRelocationSources.values().iterator();
        while (iterator.hasNext() && (result = (source = iterator.next()).relocatedTarget(session, artifactDescriptorResult, model)) == null) {
        }
        return result;
    }

    private void missingDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void invalidDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private int getPolicy(RepositorySystemSession session, Artifact a, ArtifactDescriptorRequest request) {
        ArtifactDescriptorPolicy policy = session.getArtifactDescriptorPolicy();
        if (policy == null) {
            return 0;
        }
        return policy.getPolicy(session, new ArtifactDescriptorPolicyRequest(a, request.getRequestContext()));
    }
}

