/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.api.services.model.ProfileActivationContext;

public class DefaultProfileActivationContext
implements ProfileActivationContext {
    private List<String> activeProfileIds = Collections.emptyList();
    private List<String> inactiveProfileIds = Collections.emptyList();
    private Map<String, String> systemProperties = Collections.emptyMap();
    private Map<String, String> userProperties = Collections.emptyMap();
    private Map<String, String> projectProperties = Collections.emptyMap();
    private Path projectDirectory;

    @Override
    public List<String> getActiveProfileIds() {
        return this.activeProfileIds;
    }

    public DefaultProfileActivationContext setActiveProfileIds(List<String> activeProfileIds) {
        this.activeProfileIds = DefaultProfileActivationContext.unmodifiable(activeProfileIds);
        return this;
    }

    @Override
    public List<String> getInactiveProfileIds() {
        return this.inactiveProfileIds;
    }

    public DefaultProfileActivationContext setInactiveProfileIds(List<String> inactiveProfileIds) {
        this.inactiveProfileIds = DefaultProfileActivationContext.unmodifiable(inactiveProfileIds);
        return this;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public DefaultProfileActivationContext setSystemProperties(Properties systemProperties) {
        return this.setSystemProperties(DefaultProfileActivationContext.toMap(systemProperties));
    }

    public DefaultProfileActivationContext setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = DefaultProfileActivationContext.unmodifiable(systemProperties);
        return this;
    }

    @Override
    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public DefaultProfileActivationContext setUserProperties(Properties userProperties) {
        return this.setUserProperties(DefaultProfileActivationContext.toMap(userProperties));
    }

    public DefaultProfileActivationContext setUserProperties(Map<String, String> userProperties) {
        this.userProperties = DefaultProfileActivationContext.unmodifiable(userProperties);
        return this;
    }

    @Override
    public Path getProjectDirectory() {
        return this.projectDirectory;
    }

    public DefaultProfileActivationContext setProjectDirectory(Path projectDirectory) {
        this.projectDirectory = projectDirectory;
        return this;
    }

    @Override
    public Map<String, String> getProjectProperties() {
        return this.projectProperties;
    }

    public DefaultProfileActivationContext setProjectProperties(Properties projectProperties) {
        return this.setProjectProperties(DefaultProfileActivationContext.toMap(projectProperties));
    }

    public DefaultProfileActivationContext setProjectProperties(Map<String, String> projectProperties) {
        this.projectProperties = DefaultProfileActivationContext.unmodifiable(projectProperties);
        return this;
    }

    private static List<String> unmodifiable(List<String> list) {
        return list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
    }

    private static Map<String, String> unmodifiable(Map<String, String> map) {
        return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    private static Map<String, String> toMap(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
        }
        return null;
    }
}

