/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.internal.impl.model.ModelProblemUtils;

public class DefaultModelProblem
implements ModelProblem {
    private final String source;
    private final int lineNumber;
    private final int columnNumber;
    private final String modelId;
    private final String message;
    private final Exception exception;
    private final BuilderProblem.Severity severity;
    private final ModelProblem.Version version;

    public DefaultModelProblem(String message, BuilderProblem.Severity severity, ModelProblem.Version version, Model source, int lineNumber, int columnNumber, Exception exception) {
        this(message, severity, version, ModelProblemUtils.toPath(source), lineNumber, columnNumber, ModelProblemUtils.toId(source), exception);
    }

    public DefaultModelProblem(String message, BuilderProblem.Severity severity, ModelProblem.Version version, String source, int lineNumber, int columnNumber, String modelId, Exception exception) {
        this.message = message;
        this.severity = severity != null ? severity : BuilderProblem.Severity.ERROR;
        this.source = source != null ? source : "";
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.modelId = modelId != null ? modelId : "";
        this.exception = exception;
        this.version = version;
    }

    public String getSource() {
        return this.source;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getModelId() {
        return this.modelId;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getLocation() {
        return "";
    }

    public String getMessage() {
        String msg = null;
        if (this.message != null && !this.message.isEmpty()) {
            msg = this.message;
        } else if (this.exception != null) {
            msg = this.exception.getMessage();
        }
        if (msg == null) {
            msg = "";
        }
        return msg;
    }

    public BuilderProblem.Severity getSeverity() {
        return this.severity;
    }

    public ModelProblem.Version getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append('[').append(this.getSeverity()).append("] ");
        buffer.append(this.getMessage());
        String location = ModelProblemUtils.formatLocation(this, null);
        if (!location.isEmpty()) {
            buffer.append(" @ ");
            buffer.append(location);
        }
        return buffer.toString();
    }
}

