/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.SettingsBuilder;
import org.apache.maven.api.services.SettingsBuilderException;
import org.apache.maven.api.services.SettingsBuilderRequest;
import org.apache.maven.api.services.SettingsBuilderResult;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.xml.SettingsXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.internal.impl.DefaultBuilderProblem;
import org.apache.maven.internal.impl.DefaultSettingsValidator;
import org.apache.maven.internal.impl.SettingsUtilsV4;
import org.apache.maven.settings.v4.SettingsMerger;
import org.apache.maven.settings.v4.SettingsTransformer;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

@Named
public class DefaultSettingsBuilder
implements SettingsBuilder {
    private final DefaultSettingsValidator settingsValidator = new DefaultSettingsValidator();
    private final SettingsMerger settingsMerger = new SettingsMerger();

    public SettingsBuilderResult build(SettingsBuilderRequest request) throws SettingsBuilderException {
        Path file;
        String localRepository;
        ArrayList<BuilderProblem> problems = new ArrayList<BuilderProblem>();
        Source installationSource = request.getInstallationSettingsSource().orElse(null);
        Settings installation = this.readSettings(installationSource, false, request, problems);
        Source projectSource = request.getProjectSettingsSource().orElse(null);
        Settings project = this.readSettings(projectSource, true, request, problems);
        Source userSource = request.getUserSettingsSource().orElse(null);
        Settings user = this.readSettings(userSource, false, request, problems);
        Settings effective = this.settingsMerger.merge(user, this.settingsMerger.merge(project, installation, false, null), false, null);
        if (effective.getRepositories().isEmpty() && effective.getPluginRepositories().isEmpty()) {
            Repository central = Repository.newBuilder().id("central").name("Central Repository").url("https://repo.maven.apache.org/maven2").snapshots(RepositoryPolicy.newBuilder().enabled(false).build()).build();
            Repository centralWithNoUpdate = central.withReleases(RepositoryPolicy.newBuilder().updatePolicy("never").build());
            effective = Settings.newBuilder((Settings)effective).repositories(List.of(central)).pluginRepositories(List.of(centralWithNoUpdate)).build();
        }
        if ((localRepository = effective.getLocalRepository()) != null && !localRepository.isEmpty() && !(file = Paths.get(localRepository, new String[0])).isAbsolute() && file.toString().startsWith(File.separator)) {
            effective = effective.withLocalRepository(file.toAbsolutePath().toString());
        }
        if (this.hasErrors(problems)) {
            throw new SettingsBuilderException("Error building settings", problems);
        }
        return new DefaultSettingsBuilderResult(effective, problems);
    }

    private boolean hasErrors(List<BuilderProblem> problems) {
        if (problems != null) {
            for (BuilderProblem problem : problems) {
                if (BuilderProblem.Severity.ERROR.compareTo((Enum)problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private Settings readSettings(Source settingsSource, boolean isProjectSettings, SettingsBuilderRequest request, List<BuilderProblem> problems) {
        Settings settings;
        if (settingsSource == null) {
            return Settings.newInstance();
        }
        try {
            try (InputStream is = settingsSource.openStream();){
                settings = (Settings)((SettingsXmlFactory)request.getSession().getService(SettingsXmlFactory.class)).read(XmlReaderRequest.builder().inputStream(is).location(settingsSource.getLocation()).strict(true).build());
            }
            catch (XmlReaderException e) {
                try (InputStream is2 = settingsSource.openStream();){
                    Location location;
                    settings = (Settings)((SettingsXmlFactory)request.getSession().getService(SettingsXmlFactory.class)).read(XmlReaderRequest.builder().inputStream(is2).location(settingsSource.getLocation()).strict(false).build());
                    Throwable throwable = e.getCause();
                    if (throwable instanceof XMLStreamException) {
                        XMLStreamException xe = (XMLStreamException)throwable;
                        location = xe.getLocation();
                    } else {
                        location = null;
                    }
                    Location loc = location;
                    problems.add(new DefaultBuilderProblem(settingsSource.getLocation(), loc != null ? loc.getLineNumber() : -1, loc != null ? loc.getColumnNumber() : -1, (Exception)((Object)e), e.getMessage(), BuilderProblem.Severity.WARNING));
                }
            }
        }
        catch (XmlReaderException e) {
            Location location;
            Throwable throwable = e.getCause();
            if (throwable instanceof XMLStreamException) {
                XMLStreamException xe = (XMLStreamException)throwable;
                location = xe.getLocation();
            } else {
                location = null;
            }
            Location loc = location;
            problems.add(new DefaultBuilderProblem(settingsSource.getLocation(), loc != null ? loc.getLineNumber() : -1, loc != null ? loc.getColumnNumber() : -1, (Exception)((Object)e), "Non-parseable settings " + settingsSource.getLocation() + ": " + e.getMessage(), BuilderProblem.Severity.FATAL));
            return Settings.newInstance();
        }
        catch (IOException e) {
            problems.add(new DefaultBuilderProblem(settingsSource.getLocation(), -1, -1, e, "Non-readable settings " + settingsSource.getLocation() + ": " + e.getMessage(), BuilderProblem.Severity.FATAL));
            return Settings.newInstance();
        }
        settings = this.interpolate(settings, request, problems);
        this.settingsValidator.validate(settings, isProjectSettings, problems);
        if (isProjectSettings) {
            settings = Settings.newBuilder((Settings)settings, (boolean)true).localRepository(null).interactiveMode(false).offline(false).proxies(List.of()).usePluginRegistry(false).servers(settings.getServers().stream().map(s -> Server.newBuilder((Server)s, (boolean)true).username(null).passphrase(null).privateKey(null).password(null).filePermissions(null).directoryPermissions(null).build()).toList()).build();
        }
        return settings;
    }

    private Settings interpolate(Settings settings, SettingsBuilderRequest request, List<BuilderProblem> problems) {
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(request.getSession().getUserProperties()));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(request.getSession().getSystemProperties()));
        try {
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        }
        catch (IOException e) {
            problems.add(new DefaultBuilderProblem(null, -1, -1, e, "Failed to use environment variables for interpolation: " + e.getMessage(), BuilderProblem.Severity.WARNING));
        }
        return new SettingsTransformer(value -> {
            try {
                return value != null ? interpolator.interpolate(value) : null;
            }
            catch (InterpolationException e) {
                problems.add(new DefaultBuilderProblem(null, -1, -1, (Exception)((Object)e), "Failed to interpolate settings: " + e.getMessage(), BuilderProblem.Severity.WARNING));
                return value;
            }
        }).visit(settings);
    }

    public List<BuilderProblem> validate(Settings settings, boolean isProjectSettings) {
        ArrayList<BuilderProblem> problems = new ArrayList<BuilderProblem>();
        this.settingsValidator.validate(settings, isProjectSettings, problems);
        return problems;
    }

    public Profile convert(org.apache.maven.api.model.Profile profile) {
        return SettingsUtilsV4.convertToSettingsProfile(profile);
    }

    public org.apache.maven.api.model.Profile convert(Profile profile) {
        return SettingsUtilsV4.convertFromSettingsProfile(profile);
    }

    static class DefaultSettingsBuilderResult
    implements SettingsBuilderResult {
        private final Settings effectiveSettings;
        private final List<BuilderProblem> problems;

        DefaultSettingsBuilderResult(Settings effectiveSettings, List<BuilderProblem> problems) {
            this.effectiveSettings = effectiveSettings;
            this.problems = problems != null ? problems : new ArrayList();
        }

        public Settings getEffectiveSettings() {
            return this.effectiveSettings;
        }

        public List<BuilderProblem> getProblems() {
            return this.problems;
        }
    }
}

