/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.examples.services.impl;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.examples.indexing.RepositoryIndexManager;
import org.apache.maven.index.examples.indexing.RepositoryIndexer;
import org.apache.maven.index.examples.indexing.SearchRequest;
import org.apache.maven.index.examples.indexing.SearchResults;
import org.apache.maven.index.examples.services.ArtifactIndexingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArtifactIndexingServiceImpl
implements ArtifactIndexingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactIndexingServiceImpl.class);
    @Autowired
    private RepositoryIndexManager repositoryIndexManager;

    @Override
    public void addToIndex(String repositoryId, File artifactFile, String groupId, String artifactId, String version, String extension, String classifier) throws IOException {
        RepositoryIndexer indexer = this.repositoryIndexManager.getRepositoryIndex(repositoryId);
        indexer.addArtifactToIndex(repositoryId, artifactFile, groupId, artifactId, version, extension, classifier);
    }

    @Override
    public void deleteFromIndex(String repositoryId, String groupId, String artifactId, String version, String extension, String classifier) throws IOException {
        RepositoryIndexer indexer = this.repositoryIndexManager.getRepositoryIndex(repositoryId);
        if (indexer != null) {
            indexer.delete(Arrays.asList(new ArtifactInfo(repositoryId, groupId, artifactId, version, classifier, extension)));
        }
    }

    @Override
    public SearchResults search(SearchRequest searchRequest) throws IOException, ParseException {
        SearchResults searchResults = new SearchResults();
        String repositoryId = searchRequest.getRepository();
        if (repositoryId != null && !repositoryId.isEmpty()) {
            LOGGER.debug("Repository: {}", (Object)repositoryId);
            Map<String, Collection<ArtifactInfo>> resultsMap = this.getResultsMap(repositoryId, searchRequest.getQuery());
            if (!resultsMap.isEmpty()) {
                searchResults.setResults(resultsMap);
            }
            if (LOGGER.isDebugEnabled()) {
                int results = resultsMap.entrySet().iterator().next().getValue().size();
                LOGGER.debug("Results: {}", (Object)results);
            }
        } else {
            LinkedHashMap<String, Collection<ArtifactInfo>> resultsMap = new LinkedHashMap<String, Collection<ArtifactInfo>>();
            for (String repoId : this.repositoryIndexManager.getIndexes().keySet()) {
                LOGGER.debug("Repository: {}", (Object)repoId);
                RepositoryIndexer repositoryIndex = this.repositoryIndexManager.getRepositoryIndex(repoId);
                if (repositoryIndex == null) continue;
                Set<ArtifactInfo> artifactInfoResults = this.repositoryIndexManager.getRepositoryIndex(repoId).search(searchRequest.getQuery());
                if (!artifactInfoResults.isEmpty()) {
                    resultsMap.put(repoId, artifactInfoResults);
                }
                LOGGER.debug("Results: {}", (Object)artifactInfoResults.size());
            }
            searchResults.setResults(resultsMap);
        }
        return searchResults;
    }

    @Override
    public boolean contains(SearchRequest searchRequest) throws IOException, ParseException {
        return !this.getResultsMap(searchRequest.getRepository(), searchRequest.getQuery()).isEmpty();
    }

    public Map<String, Collection<ArtifactInfo>> getResultsMap(String repositoryId, String query) throws IOException, ParseException {
        LinkedHashMap<String, Collection<ArtifactInfo>> resultsMap = new LinkedHashMap<String, Collection<ArtifactInfo>>();
        Set<ArtifactInfo> artifactInfoResults = this.repositoryIndexManager.getRepositoryIndex(repositoryId).search(query);
        if (!artifactInfoResults.isEmpty()) {
            resultsMap.put(repositoryId, artifactInfoResults);
        }
        return resultsMap;
    }

    public RepositoryIndexManager getRepositoryIndexManager() {
        return this.repositoryIndexManager;
    }

    public void setRepositoryIndexManager(RepositoryIndexManager repositoryIndexManager) {
        this.repositoryIndexManager = repositoryIndexManager;
    }
}

