/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.creator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.document.Document;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

@Singleton
@Named(value="maven-plugin")
public class MavenPluginArtifactInfoIndexCreator
extends AbstractIndexCreator {
    public static final String ID = "maven-plugin";
    private static final String MAVEN_PLUGIN_PACKAGING = "maven-plugin";
    public static final IndexerField FLD_PLUGIN_PREFIX = new IndexerField(MAVEN.PLUGIN_PREFIX, IndexerFieldVersion.V1, "px", "MavenPlugin prefix (as keyword, stored)", IndexerField.KEYWORD_STORED);
    public static final IndexerField FLD_PLUGIN_GOALS = new IndexerField(MAVEN.PLUGIN_GOALS, IndexerFieldVersion.V1, "gx", "MavenPlugin goals (as keyword, stored)", IndexerField.ANALYZED_STORED);

    public MavenPluginArtifactInfoIndexCreator() {
        super("maven-plugin", Arrays.asList("min"));
    }

    @Override
    public void populateArtifactInfo(ArtifactContext ac) {
        File artifact = ac.getArtifact();
        ArtifactInfo ai = ac.getArtifactInfo();
        if (artifact != null && "maven-plugin".equals(ai.getPackaging()) && artifact.getName().endsWith(".jar")) {
            this.checkMavenPlugin(ai, artifact);
        }
    }

    private void checkMavenPlugin(ArtifactInfo ai, File artifact) {
        block14: {
            try (ZipFile zipFile = new ZipFile(artifact);){
                String pluginDescriptorPath = "META-INF/maven/plugin.xml";
                ZipEntry zipEntry = zipFile.getEntry("META-INF/maven/plugin.xml");
                if (zipEntry == null) break block14;
                try (BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
                    Xpp3Dom[] mojoConfigs;
                    Xpp3Dom plexusConfig = Xpp3DomBuilder.build(new InputStreamReader(is));
                    ai.setPrefix(plexusConfig.getChild("goalPrefix").getValue());
                    ai.setGoals(new ArrayList<String>());
                    for (Xpp3Dom mojoConfig : mojoConfigs = plexusConfig.getChild("mojos").getChildren("mojo")) {
                        ai.getGoals().add(mojoConfig.getChild("goal").getValue());
                    }
                }
            }
            catch (Exception e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().info("Failed to parse Maven artifact " + artifact.getAbsolutePath() + " due to exception:", e);
                }
                this.getLogger().info("Failed to parse Maven artifact " + artifact.getAbsolutePath() + " due to " + e.getMessage());
            }
        }
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
        if (ai.getPrefix() != null) {
            doc.add(FLD_PLUGIN_PREFIX.toField(ai.getPrefix()));
        }
        if (ai.getGoals() != null) {
            doc.add(FLD_PLUGIN_GOALS.toField(ArtifactInfo.lst2str(ai.getGoals())));
        }
    }

    @Override
    public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
        boolean res = false;
        if ("maven-plugin".equals(ai.getPackaging())) {
            ai.setPrefix(doc.get(ArtifactInfo.PLUGIN_PREFIX));
            String goals = doc.get(ArtifactInfo.PLUGIN_GOALS);
            if (goals != null) {
                ai.setGoals(ArtifactInfo.str2lst(goals));
            }
            res = true;
        }
        return res;
    }

    public String toString() {
        return "maven-plugin";
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_PLUGIN_GOALS, FLD_PLUGIN_PREFIX);
    }
}

