/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsSource;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.ImpactsDISI;
import org.apache.lucene.search.PhraseMatcher;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PhraseQueue;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.FixedBitSet;

final class SloppyPhraseMatcher
extends PhraseMatcher {
    private final PhrasePositions[] phrasePositions;
    private final int slop;
    private final int numPostings;
    private final PhraseQueue pq;
    private final boolean captureLeadMatch;
    private final DocIdSetIterator approximation;
    private final ImpactsDISI impactsApproximation;
    private int end;
    private int leadPosition;
    private int leadOffset;
    private int leadEndOffset;
    private int leadOrd;
    private boolean hasRpts;
    private boolean checkedRpts;
    private boolean hasMultiTermRpts;
    private PhrasePositions[][] rptGroups;
    private PhrasePositions[] rptStack;
    private boolean positioned;
    private int matchLength;

    SloppyPhraseMatcher(PhraseQuery.PostingsAndFreq[] postings, int slop, ScoreMode scoreMode, Similarity.SimScorer scorer, float matchCost, boolean captureLeadMatch) {
        super(matchCost);
        this.slop = slop;
        this.numPostings = postings.length;
        this.captureLeadMatch = captureLeadMatch;
        this.pq = new PhraseQueue(postings.length);
        this.phrasePositions = new PhrasePositions[postings.length];
        for (int i = 0; i < postings.length; ++i) {
            this.phrasePositions[i] = new PhrasePositions(postings[i].postings, postings[i].position, i, postings[i].terms);
        }
        this.approximation = ConjunctionDISI.intersectIterators(Arrays.stream(postings).map(p -> p.postings).collect(Collectors.toList()));
        ImpactsSource impactsSource = new ImpactsSource(){

            @Override
            public Impacts getImpacts() throws IOException {
                return new Impacts(){

                    @Override
                    public int numLevels() {
                        return 1;
                    }

                    @Override
                    public List<Impact> getImpacts(int level) {
                        return Collections.singletonList(new Impact(Integer.MAX_VALUE, 1L));
                    }

                    @Override
                    public int getDocIdUpTo(int level) {
                        return Integer.MAX_VALUE;
                    }
                };
            }

            @Override
            public void advanceShallow(int target) throws IOException {
            }
        };
        this.impactsApproximation = new ImpactsDISI(this.approximation, impactsSource, scorer);
    }

    @Override
    DocIdSetIterator approximation() {
        return this.approximation;
    }

    @Override
    ImpactsDISI impactsApproximation() {
        return this.impactsApproximation;
    }

    @Override
    float maxFreq() throws IOException {
        float maxFreq = 0.0f;
        for (PhrasePositions phrasePosition : this.phrasePositions) {
            maxFreq += (float)phrasePosition.postings.freq();
        }
        return maxFreq;
    }

    @Override
    public void reset() throws IOException {
        this.positioned = this.initPhrasePositions();
        this.matchLength = Integer.MAX_VALUE;
        this.leadPosition = Integer.MAX_VALUE;
    }

    @Override
    float sloppyWeight() {
        return 1.0f / (1.0f + (float)this.matchLength);
    }

    @Override
    public boolean nextMatch() throws IOException {
        if (!this.positioned) {
            return false;
        }
        PhrasePositions pp = (PhrasePositions)this.pq.pop();
        assert (pp != null);
        this.captureLead(pp);
        this.matchLength = this.end - pp.position;
        int next = ((PhrasePositions)this.pq.top()).position;
        while (this.advancePP(pp) && (!this.hasRpts || this.advanceRpts(pp))) {
            if (pp.position > next) {
                this.pq.add(pp);
                if (this.matchLength <= this.slop) {
                    return true;
                }
                pp = (PhrasePositions)this.pq.pop();
                next = ((PhrasePositions)this.pq.top()).position;
                assert (pp != null);
                this.matchLength = this.end - pp.position;
            } else {
                int matchLength2 = this.end - pp.position;
                if (matchLength2 < this.matchLength) {
                    this.matchLength = matchLength2;
                }
            }
            this.captureLead(pp);
        }
        this.positioned = false;
        return this.matchLength <= this.slop;
    }

    private void captureLead(PhrasePositions pp) throws IOException {
        if (!this.captureLeadMatch) {
            return;
        }
        this.leadOrd = pp.ord;
        this.leadPosition = pp.position + pp.offset;
        this.leadOffset = pp.postings.startOffset();
        this.leadEndOffset = pp.postings.endOffset();
    }

    @Override
    public int startPosition() {
        int leadPosition = this.leadPosition;
        for (PhrasePositions pp : this.phrasePositions) {
            leadPosition = Math.min(leadPosition, pp.position + pp.offset);
        }
        return leadPosition;
    }

    @Override
    public int endPosition() {
        int endPosition = this.leadPosition;
        for (PhrasePositions pp : this.phrasePositions) {
            if (pp.ord == this.leadOrd) continue;
            endPosition = Math.max(endPosition, pp.position + pp.offset);
        }
        return endPosition;
    }

    @Override
    public int startOffset() throws IOException {
        int leadOffset = this.leadOffset;
        for (PhrasePositions pp : this.phrasePositions) {
            leadOffset = Math.min(leadOffset, pp.postings.startOffset());
        }
        return leadOffset;
    }

    @Override
    public int endOffset() throws IOException {
        int endOffset = this.leadEndOffset;
        for (PhrasePositions pp : this.phrasePositions) {
            if (pp.ord == this.leadOrd) continue;
            endOffset = Math.max(endOffset, pp.postings.endOffset());
        }
        return endOffset;
    }

    private boolean advancePP(PhrasePositions pp) throws IOException {
        if (!pp.nextPosition()) {
            return false;
        }
        if (pp.position > this.end) {
            this.end = pp.position;
        }
        return true;
    }

    private boolean advanceRpts(PhrasePositions pp) throws IOException {
        int k;
        if (pp.rptGroup < 0) {
            return true;
        }
        PhrasePositions[] rg = this.rptGroups[pp.rptGroup];
        FixedBitSet bits = new FixedBitSet(rg.length);
        int k0 = pp.rptInd;
        while ((k = this.collide(pp)) >= 0) {
            if (!this.advancePP(pp = this.lesser(pp, rg[k]))) {
                return false;
            }
            if (k == k0) continue;
            bits = FixedBitSet.ensureCapacity(bits, k);
            bits.set(k);
        }
        int n = 0;
        int numBits = bits.length();
        while (bits.cardinality() > 0) {
            PhrasePositions pp2 = (PhrasePositions)this.pq.pop();
            this.rptStack[n++] = pp2;
            if (pp2.rptGroup < 0 || pp2.rptInd >= numBits || !bits.get(pp2.rptInd)) continue;
            bits.clear(pp2.rptInd);
        }
        for (int i = n - 1; i >= 0; --i) {
            this.pq.add(this.rptStack[i]);
        }
        return true;
    }

    private PhrasePositions lesser(PhrasePositions pp, PhrasePositions pp2) {
        if (pp.position < pp2.position || pp.position == pp2.position && pp.offset < pp2.offset) {
            return pp;
        }
        return pp2;
    }

    private int collide(PhrasePositions pp) {
        int tpPos = this.tpPos(pp);
        PhrasePositions[] rg = this.rptGroups[pp.rptGroup];
        for (int i = 0; i < rg.length; ++i) {
            PhrasePositions pp2 = rg[i];
            if (pp2 == pp || this.tpPos(pp2) != tpPos) continue;
            return pp2.rptInd;
        }
        return -1;
    }

    private boolean initPhrasePositions() throws IOException {
        this.end = Integer.MIN_VALUE;
        if (!this.checkedRpts) {
            return this.initFirstTime();
        }
        if (!this.hasRpts) {
            this.initSimple();
            return true;
        }
        return this.initComplex();
    }

    private void initSimple() throws IOException {
        this.pq.clear();
        for (PhrasePositions pp : this.phrasePositions) {
            pp.firstPosition();
            if (pp.position > this.end) {
                this.end = pp.position;
            }
            this.pq.add(pp);
        }
    }

    private boolean initComplex() throws IOException {
        this.placeFirstPositions();
        if (!this.advanceRepeatGroups()) {
            return false;
        }
        this.fillQueue();
        return true;
    }

    private void placeFirstPositions() throws IOException {
        for (PhrasePositions pp : this.phrasePositions) {
            pp.firstPosition();
        }
    }

    private void fillQueue() {
        this.pq.clear();
        for (PhrasePositions pp : this.phrasePositions) {
            if (pp.position > this.end) {
                this.end = pp.position;
            }
            this.pq.add(pp);
        }
    }

    private boolean advanceRepeatGroups() throws IOException {
        for (PhrasePositions[] rg : this.rptGroups) {
            if (this.hasMultiTermRpts) {
                int incr;
                block1: for (int i = 0; i < rg.length; i += incr) {
                    int k;
                    incr = 1;
                    PhrasePositions pp = rg[i];
                    while ((k = this.collide(pp)) >= 0) {
                        PhrasePositions pp2 = this.lesser(pp, rg[k]);
                        if (!this.advancePP(pp2)) {
                            return false;
                        }
                        if (pp2.rptInd >= i) continue;
                        incr = 0;
                        continue block1;
                    }
                }
                continue;
            }
            for (int j = 1; j < rg.length; ++j) {
                for (int k = 0; k < j; ++k) {
                    if (rg[j].nextPosition()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean initFirstTime() throws IOException {
        this.checkedRpts = true;
        this.placeFirstPositions();
        LinkedHashMap<Term, Integer> rptTerms = this.repeatingTerms();
        boolean bl = this.hasRpts = !rptTerms.isEmpty();
        if (this.hasRpts) {
            this.rptStack = new PhrasePositions[this.numPostings];
            ArrayList<ArrayList<PhrasePositions>> rgs = this.gatherRptGroups(rptTerms);
            this.sortRptGroups(rgs);
            if (!this.advanceRepeatGroups()) {
                return false;
            }
        }
        this.fillQueue();
        return true;
    }

    private void sortRptGroups(ArrayList<ArrayList<PhrasePositions>> rgs) {
        this.rptGroups = new PhrasePositions[rgs.size()][];
        Comparator<PhrasePositions> cmprtr = new Comparator<PhrasePositions>(){

            @Override
            public int compare(PhrasePositions pp1, PhrasePositions pp2) {
                return pp1.offset - pp2.offset;
            }
        };
        for (int i = 0; i < this.rptGroups.length; ++i) {
            PhrasePositions[] rg = rgs.get(i).toArray(new PhrasePositions[0]);
            Arrays.sort(rg, cmprtr);
            this.rptGroups[i] = rg;
            for (int j = 0; j < rg.length; ++j) {
                rg[j].rptInd = j;
            }
        }
    }

    private ArrayList<ArrayList<PhrasePositions>> gatherRptGroups(LinkedHashMap<Term, Integer> rptTerms) throws IOException {
        PhrasePositions[] rpp = this.repeatingPPs(rptTerms);
        ArrayList<ArrayList<PhrasePositions>> res = new ArrayList<ArrayList<PhrasePositions>>();
        if (!this.hasMultiTermRpts) {
            for (int i = 0; i < rpp.length; ++i) {
                PhrasePositions pp = rpp[i];
                if (pp.rptGroup >= 0) continue;
                int tpPos = this.tpPos(pp);
                for (int j = i + 1; j < rpp.length; ++j) {
                    PhrasePositions pp2 = rpp[j];
                    if (pp2.rptGroup >= 0 || pp2.offset == pp.offset || this.tpPos(pp2) != tpPos) continue;
                    int n = pp.rptGroup;
                    if (n < 0) {
                        pp.rptGroup = n = res.size();
                        ArrayList<PhrasePositions> rl = new ArrayList<PhrasePositions>(2);
                        rl.add(pp);
                        res.add(rl);
                    }
                    pp2.rptGroup = n;
                    res.get(n).add(pp2);
                }
            }
        } else {
            ArrayList tmp = new ArrayList();
            ArrayList<FixedBitSet> bb = this.ppTermsBitSets(rpp, rptTerms);
            this.unionTermGroups(bb);
            HashMap<Term, Integer> tg = this.termGroups(rptTerms, bb);
            HashSet<Integer> distinctGroupIDs = new HashSet<Integer>(tg.values());
            for (int i = 0; i < distinctGroupIDs.size(); ++i) {
                tmp.add(new HashSet());
            }
            for (PhrasePositions pp : rpp) {
                for (Term t : pp.terms) {
                    if (!rptTerms.containsKey(t)) continue;
                    int g3 = tg.get(t);
                    ((HashSet)tmp.get(g3)).add(pp);
                    assert (pp.rptGroup == -1 || pp.rptGroup == g3);
                    pp.rptGroup = g3;
                }
            }
            for (HashSet hashSet : tmp) {
                res.add(new ArrayList(hashSet));
            }
        }
        return res;
    }

    private final int tpPos(PhrasePositions pp) {
        return pp.position + pp.offset;
    }

    private LinkedHashMap<Term, Integer> repeatingTerms() {
        LinkedHashMap<Term, Integer> tord = new LinkedHashMap<Term, Integer>();
        HashMap<Term, Integer> tcnt = new HashMap<Term, Integer>();
        for (PhrasePositions pp : this.phrasePositions) {
            for (Term t : pp.terms) {
                Integer cnt = tcnt.compute(t, (key, old) -> old == null ? 1 : 1 + old);
                if (cnt != 2) continue;
                tord.put(t, tord.size());
            }
        }
        return tord;
    }

    private PhrasePositions[] repeatingPPs(HashMap<Term, Integer> rptTerms) {
        ArrayList<PhrasePositions> rp = new ArrayList<PhrasePositions>();
        block0: for (PhrasePositions pp : this.phrasePositions) {
            for (Term t : pp.terms) {
                if (!rptTerms.containsKey(t)) continue;
                rp.add(pp);
                this.hasMultiTermRpts |= pp.terms.length > 1;
                continue block0;
            }
        }
        return rp.toArray(new PhrasePositions[0]);
    }

    private ArrayList<FixedBitSet> ppTermsBitSets(PhrasePositions[] rpp, HashMap<Term, Integer> tord) {
        ArrayList<FixedBitSet> bb = new ArrayList<FixedBitSet>(rpp.length);
        for (PhrasePositions pp : rpp) {
            FixedBitSet b = new FixedBitSet(tord.size());
            for (Term t : pp.terms) {
                Integer ord = tord.get(t);
                if (ord == null) continue;
                b.set(ord);
            }
            bb.add(b);
        }
        return bb;
    }

    private void unionTermGroups(ArrayList<FixedBitSet> bb) {
        int incr;
        for (int i = 0; i < bb.size() - 1; i += incr) {
            incr = 1;
            int j = i + 1;
            while (j < bb.size()) {
                if (bb.get(i).intersects(bb.get(j))) {
                    bb.get(i).or(bb.get(j));
                    bb.remove(j);
                    incr = 0;
                    continue;
                }
                ++j;
            }
        }
    }

    private HashMap<Term, Integer> termGroups(LinkedHashMap<Term, Integer> tord, ArrayList<FixedBitSet> bb) throws IOException {
        HashMap<Term, Integer> tg = new HashMap<Term, Integer>();
        Term[] t = tord.keySet().toArray(new Term[0]);
        for (int i = 0; i < bb.size(); ++i) {
            FixedBitSet bits = bb.get(i);
            int ord = bits.nextSetBit(0);
            while (ord != Integer.MAX_VALUE) {
                tg.put(t[ord], i);
                ord = ord + 1 >= bits.length() ? Integer.MAX_VALUE : bits.nextSetBit(ord + 1);
            }
        }
        return tg;
    }
}

