/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.std40.StandardTokenizer40;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.analysis.th.ThaiWordFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.util.Version;

public final class ThaiAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public ThaiAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public ThaiAnalyzer(CharArraySet stopwords) {
        super(stopwords);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        if (this.getVersion().onOrAfter(Version.LUCENE_4_8_0)) {
            ThaiTokenizer source = new ThaiTokenizer();
            TokenFilter result = new LowerCaseFilter(source);
            if (this.getVersion().onOrAfter(Version.LUCENE_5_4_0)) {
                result = new DecimalDigitFilter(result);
            }
            result = new StopFilter(result, this.stopwords);
            return new Analyzer.TokenStreamComponents(source, result);
        }
        Tokenizer source = this.getVersion().onOrAfter(Version.LUCENE_4_7_0) ? new StandardTokenizer() : new StandardTokenizer40();
        TokenFilter result = new StandardFilter(source);
        result = new LowerCaseFilter(result);
        result = new ThaiWordFilter(result);
        return new Analyzer.TokenStreamComponents(source, new StopFilter(result, this.stopwords));
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = ThaiAnalyzer.loadStopwordSet(false, ThaiAnalyzer.class, ThaiAnalyzer.DEFAULT_STOPWORD_FILE, ThaiAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

