/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.BufferedPartialBlockCipher;
import de.schlichtherle.truezip.crypto.CipherOutputStream;
import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.io.LEDataOutputStream;
import de.schlichtherle.truezip.zip.WinZipAesCipher;
import de.schlichtherle.truezip.zip.WinZipAesEntryParameters;
import java.io.IOException;
import java.security.SecureRandom;
import javax.annotation.concurrent.NotThreadSafe;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.io.MacOutputStream;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.io.TeeOutputStream;

@NotThreadSafe
final class WinZipAesEntryOutputStream
extends CipherOutputStream {
    static final int ITERATION_COUNT = 1000;
    static final int AES_BLOCK_SIZE_BITS = 128;
    static final int PWD_VERIFIER_BITS = 16;
    private final SecureRandom shaker = new SecureRandom();
    private final WinZipAesEntryParameters param;
    private final MacOutputStream mos;
    private final LEDataOutputStream dos;

    WinZipAesEntryOutputStream(LEDataOutputStream out, WinZipAesEntryParameters param) throws IOException {
        super(out, new BufferedPartialBlockCipher(new WinZipAesCipher()));
        assert (null != out);
        assert (null != param);
        this.param = param;
        AesKeyStrength keyStrength = param.getKeyStrength();
        int keyStrengthBits = keyStrength.getBits();
        int keyStrengthBytes = keyStrength.getBytes();
        byte[] salt = new byte[keyStrengthBytes / 2];
        this.shaker.nextBytes(salt);
        byte[] passwd = param.getWritePassword();
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        gen.init(passwd, salt, 1000);
        assert (128 <= keyStrengthBits);
        KeyParameter keyParam = (KeyParameter)((PBEParametersGenerator)gen).generateDerivedParameters(2 * keyStrengthBits + 16);
        this.paranoidWipe(passwd);
        byte[] ctrIv = new byte[16];
        ParametersWithIV aesCtrParam = new ParametersWithIV(new KeyParameter(keyParam.getKey(), 0, keyStrengthBytes), ctrIv);
        KeyParameter sha1HMacParam = new KeyParameter(keyParam.getKey(), keyStrengthBytes, keyStrengthBytes);
        this.cipher.init(true, aesCtrParam);
        HMac mac = new HMac(new SHA1Digest());
        mac.init(sha1HMacParam);
        this.dos = (LEDataOutputStream)this.delegate;
        this.mos = new MacOutputStream(mac);
        this.delegate = new TeeOutputStream(this.dos, this.mos);
        this.dos.write(salt);
        this.writePasswordVerifier(keyParam);
    }

    private void writePasswordVerifier(KeyParameter keyParam) throws IOException {
        this.dos.write(keyParam.getKey(), 2 * this.param.getKeyStrength().getBytes(), 2);
    }

    private void paranoidWipe(byte[] passwd) {
        this.shaker.nextBytes(passwd);
    }

    @Override
    protected void finish() throws IOException {
        super.finish();
        byte[] buf = this.mos.getMac();
        this.dos.write(buf, 0, buf.length / 2);
    }
}

