/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import org.sonatype.guice.bean.locators.BeanLocator;
import org.sonatype.guice.bean.locators.EntryListAdapter;
import org.sonatype.guice.bean.locators.Implicit;
import org.sonatype.guice.bean.locators.InjectorPublisher;
import org.sonatype.guice.bean.reflect.Logs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImplicitBindings {
    private final Iterable<Injector> injectors;

    ImplicitBindings(BeanLocator locator) {
        this.injectors = new EntryListAdapter(locator.locate(Key.get(Injector.class)));
    }

    public <T> Binding<T> get(TypeLiteral<T> type) {
        Key<T> implicitKey = Key.get(type.getRawType(), Implicit.class);
        for (Injector i : this.injectors) {
            try {
                Binding<?> binding = i.getBindings().get(implicitKey);
                if (null == binding) continue;
                Logs.debug("Using implicit binding: {} from: <>", binding, i);
                return binding;
            }
            catch (Throwable e) {
            }
        }
        Key<T> justInTimeKey = Key.get(type);
        for (Injector i : this.injectors) {
            try {
                Binding<T> binding = i.getBinding(justInTimeKey);
                if (!InjectorPublisher.isVisible(binding)) continue;
                Logs.debug("Using just-in-time binding: {} from: <>", binding, i);
                return binding;
            }
            catch (Throwable e) {
            }
        }
        return null;
    }
}

