/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.artifact.GavCalculator;
import org.apache.maven.index.artifact.M2GavCalculator;
import org.apache.maven.index.context.AbstractIndexingContext;
import org.apache.maven.index.context.DocumentFilter;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.NexusAnalyzer;
import org.apache.maven.index.context.NexusIndexSearcherFactory;
import org.apache.maven.index.context.NexusIndexWriter;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIndexingContext
extends AbstractIndexingContext {
    private static final String INDEX_DIRECTORY = ".index";
    public static final String FLD_DESCRIPTOR = "DESCRIPTOR";
    private static final String FLD_DESCRIPTOR_CONTENTS = "NexusIndex";
    private static final String FLD_IDXINFO = "IDXINFO";
    private static final String VERSION = "1.0";
    private static final Term DESCRIPTOR_TERM = new Term("DESCRIPTOR", "NexusIndex");
    private Directory indexDirectory;
    private File indexDirectoryFile;
    private String id;
    private boolean searchable;
    private String repositoryId;
    private File repository;
    private String repositoryUrl;
    private String indexUpdateUrl;
    private NexusIndexWriter indexWriter;
    private SearcherManager searcherManager;
    private Date timestamp;
    private List<? extends IndexCreator> indexCreators;
    private GavCalculator gavCalculator;

    private DefaultIndexingContext(String id, String repositoryId, File repository, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, Directory indexDirectory, boolean reclaimIndex) throws UnsupportedExistingLuceneIndexException, IOException {
        this.id = id;
        this.searchable = true;
        this.repositoryId = repositoryId;
        this.repository = repository;
        this.repositoryUrl = repositoryUrl;
        this.indexUpdateUrl = indexUpdateUrl;
        this.indexWriter = null;
        this.searcherManager = null;
        this.indexCreators = indexCreators;
        this.indexDirectory = indexDirectory;
        for (IndexCreator indexCreator : indexCreators) {
            indexCreator.getIndexerFields();
        }
        this.gavCalculator = new M2GavCalculator();
        this.prepareIndex(reclaimIndex);
    }

    public DefaultIndexingContext(String id, String repositoryId, File repository, File indexDirectoryFile, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        this(id, repositoryId, repository, repositoryUrl, indexUpdateUrl, indexCreators, FSDirectory.open(indexDirectoryFile), reclaimIndex);
        this.indexDirectoryFile = indexDirectoryFile;
    }

    public DefaultIndexingContext(String id, String repositoryId, File repository, Directory indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        this(id, repositoryId, repository, repositoryUrl, indexUpdateUrl, indexCreators, indexDirectory, reclaimIndex);
        if (indexDirectory instanceof FSDirectory) {
            this.indexDirectoryFile = ((FSDirectory)indexDirectory).getDirectory();
        }
    }

    @Override
    public Directory getIndexDirectory() {
        return this.indexDirectory;
    }

    @Override
    public File getIndexDirectoryFile() {
        return this.indexDirectoryFile;
    }

    private void prepareIndex(boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        if (IndexReader.indexExists(this.indexDirectory)) {
            try {
                if (IndexWriter.isLocked(this.indexDirectory)) {
                    IndexWriter.unlock(this.indexDirectory);
                }
                this.openAndWarmup();
                this.checkAndUpdateIndexDescriptor(reclaimIndex);
            }
            catch (IOException e) {
                if (reclaimIndex) {
                    this.prepareCleanIndex(true);
                }
                throw e;
            }
        } else {
            this.prepareCleanIndex(false);
        }
        this.timestamp = IndexUtils.getTimestamp(this.indexDirectory);
    }

    private void prepareCleanIndex(boolean deleteExisting) throws IOException {
        if (deleteExisting) {
            this.closeReaders();
            if (IndexWriter.isLocked(this.indexDirectory)) {
                IndexWriter.unlock(this.indexDirectory);
            }
            this.deleteIndexFiles(true);
        }
        this.openAndWarmup();
        if (StringUtils.isEmpty(this.getRepositoryId())) {
            throw new IllegalArgumentException("The repositoryId cannot be null when creating new repository!");
        }
        this.storeDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateIndexDescriptor(boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        if (reclaimIndex) {
            this.storeDescriptor();
            return;
        }
        if (this.getSize() > 0) {
            TopScoreDocCollector collector = TopScoreDocCollector.create(1, false);
            IndexSearcher indexSearcher = this.acquireIndexSearcher();
            try {
                indexSearcher.search((Query)new TermQuery(DESCRIPTOR_TERM), collector);
                if (collector.getTotalHits() == 0) {
                    throw new UnsupportedExistingLuceneIndexException("The existing index has no NexusIndexer descriptor");
                }
                if (collector.getTotalHits() > 1) {
                    this.storeDescriptor();
                    return;
                }
                Document descriptor = indexSearcher.doc(collector.topDocs().scoreDocs[0].doc);
                String[] h = StringUtils.split(descriptor.get(FLD_IDXINFO), "|");
                String repoId = h[1];
                if (this.getRepositoryId() == null) {
                    this.repositoryId = repoId;
                } else if (!this.getRepositoryId().equals(repoId)) {
                    throw new UnsupportedExistingLuceneIndexException("The existing index is for repository [" + repoId + "] and not for repository [" + this.getRepositoryId() + "]");
                }
            }
            finally {
                this.releaseIndexSearcher(indexSearcher);
            }
        }
    }

    private void storeDescriptor() throws IOException {
        Document hdr = new Document();
        hdr.add(new Field(FLD_DESCRIPTOR, FLD_DESCRIPTOR_CONTENTS, Field.Store.YES, Field.Index.NOT_ANALYZED));
        hdr.add(new Field(FLD_IDXINFO, "1.0|" + this.getRepositoryId(), Field.Store.YES, Field.Index.NO));
        IndexWriter w = this.getIndexWriter();
        w.updateDocument(DESCRIPTOR_TERM, hdr);
        w.commit();
    }

    private void deleteIndexFiles(boolean full) throws IOException {
        if (this.indexDirectory != null) {
            String[] names = this.indexDirectory.listAll();
            if (names != null) {
                IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
                for (int i = 0; i < names.length; ++i) {
                    if (!filter.accept(null, names[i])) continue;
                    this.indexDirectory.deleteFile(names[i]);
                }
            }
            if (full) {
                if (this.indexDirectory.fileExists("nexus-maven-repository-index-packer.properties")) {
                    this.indexDirectory.deleteFile("nexus-maven-repository-index-packer.properties");
                }
                if (this.indexDirectory.fileExists("nexus-maven-repository-index-updater.properties")) {
                    this.indexDirectory.deleteFile("nexus-maven-repository-index-updater.properties");
                }
            }
            IndexUtils.deleteTimestamp(this.indexDirectory);
        }
    }

    @Override
    public boolean isSearchable() {
        return this.searchable;
    }

    @Override
    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void updateTimestamp() throws IOException {
        this.updateTimestamp(false);
    }

    @Override
    public void updateTimestamp(boolean save) throws IOException {
        this.updateTimestamp(save, new Date());
    }

    @Override
    public void updateTimestamp(boolean save, Date timestamp) throws IOException {
        this.timestamp = timestamp;
        if (save) {
            IndexUtils.updateTimestamp(this.indexDirectory, this.getTimestamp());
        }
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() throws IOException {
        IndexSearcher is = this.acquireIndexSearcher();
        try {
            int n = is.getIndexReader().numDocs();
            return n;
        }
        finally {
            this.releaseIndexSearcher(is);
        }
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public File getRepository() {
        return this.repository;
    }

    @Override
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Override
    public String getIndexUpdateUrl() {
        if (this.repositoryUrl != null && (this.indexUpdateUrl == null || this.indexUpdateUrl.trim().length() == 0)) {
            return this.repositoryUrl + (this.repositoryUrl.endsWith("/") ? "" : "/") + INDEX_DIRECTORY;
        }
        return this.indexUpdateUrl;
    }

    @Override
    public Analyzer getAnalyzer() {
        return new NexusAnalyzer();
    }

    protected void openAndWarmup() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
        }
        if (this.searcherManager != null) {
            this.searcherManager.close();
            this.searcherManager = null;
        }
        IndexWriterConfig config = NexusIndexWriter.defaultConfig();
        this.indexWriter = new NexusIndexWriter(this.getIndexDirectory(), config);
        this.indexWriter.commit();
        this.searcherManager = new SearcherManager(this.indexWriter, false, new NexusIndexSearcherFactory(this));
    }

    @Override
    public IndexWriter getIndexWriter() throws IOException {
        return this.indexWriter;
    }

    @Override
    public IndexSearcher acquireIndexSearcher() throws IOException {
        this.searcherManager.maybeRefresh();
        return (IndexSearcher)this.searcherManager.acquire();
    }

    @Override
    public void releaseIndexSearcher(IndexSearcher is) throws IOException {
        if (is == null) {
            return;
        }
        this.searcherManager.release(is);
    }

    @Override
    public void commit() throws IOException {
        try {
            this.getIndexWriter().commit();
        }
        catch (CorruptIndexException e) {
            this.close(false);
            throw e;
        }
        catch (IOException e) {
            this.close(false);
            throw e;
        }
    }

    @Override
    public void rollback() throws IOException {
        try {
            this.getIndexWriter().rollback();
        }
        catch (CorruptIndexException e) {
            this.close(false);
            throw e;
        }
        catch (IOException e) {
            this.close(false);
            throw e;
        }
    }

    @Override
    public synchronized void optimize() throws CorruptIndexException, IOException {
        try {
            this.getIndexWriter().optimize();
            this.commit();
        }
        catch (CorruptIndexException e) {
            this.close(false);
            throw e;
        }
        catch (IOException e) {
            this.close(false);
            throw e;
        }
    }

    @Override
    public synchronized void close(boolean deleteFiles) throws IOException {
        if (this.indexDirectory != null) {
            IndexUtils.updateTimestamp(this.indexDirectory, this.getTimestamp());
            this.closeReaders();
            if (deleteFiles) {
                this.deleteIndexFiles(true);
            }
            this.indexDirectory.close();
        }
        this.indexDirectory = null;
    }

    @Override
    public synchronized void purge() throws IOException {
        this.closeReaders();
        this.deleteIndexFiles(true);
        this.openAndWarmup();
        try {
            this.prepareIndex(true);
        }
        catch (UnsupportedExistingLuceneIndexException unsupportedExistingLuceneIndexException) {
            // empty catch block
        }
        this.rebuildGroups();
        this.updateTimestamp(true, null);
    }

    @Override
    public synchronized void replace(Directory directory) throws IOException {
        Date ts = IndexUtils.getTimestamp(directory);
        this.closeReaders();
        this.deleteIndexFiles(false);
        IndexUtils.copyDirectory(directory, this.indexDirectory);
        this.openAndWarmup();
        this.storeDescriptor();
        this.updateTimestamp(true, ts);
        this.optimize();
    }

    @Override
    public synchronized void merge(Directory directory) throws IOException {
        this.merge(directory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void merge(Directory directory, DocumentFilter filter) throws IOException {
        IndexSearcher s = this.acquireIndexSearcher();
        try {
            IndexWriter w = this.getIndexWriter();
            IndexReader directoryReader = IndexReader.open(directory, true);
            TopScoreDocCollector collector = null;
            try {
                int numDocs = directoryReader.maxDoc();
                for (int i = 0; i < numDocs; ++i) {
                    if (directoryReader.isDeleted(i)) continue;
                    Document d = directoryReader.document(i);
                    if (filter != null && !filter.accept(d)) continue;
                    String uinfo = d.get(ArtifactInfo.UINFO);
                    if (uinfo != null) {
                        collector = TopScoreDocCollector.create(1, false);
                        s.search((Query)new TermQuery(new Term(ArtifactInfo.UINFO, uinfo)), collector);
                        if (collector.getTotalHits() != 0) continue;
                        w.addDocument(IndexUtils.updateDocument(d, this, false));
                        continue;
                    }
                    String deleted = d.get(ArtifactInfo.DELETED);
                    if (deleted == null) continue;
                    w.deleteDocuments(new Term(ArtifactInfo.UINFO, deleted));
                    w.addDocument(d);
                }
            }
            finally {
                directoryReader.close();
                this.commit();
            }
            this.rebuildGroups();
            Date mergedTimestamp = IndexUtils.getTimestamp(directory);
            if (this.getTimestamp() != null && mergedTimestamp != null && mergedTimestamp.after(this.getTimestamp())) {
                this.updateTimestamp(true, mergedTimestamp);
            } else {
                this.updateTimestamp(true);
            }
            this.optimize();
        }
        finally {
            this.releaseIndexSearcher(s);
        }
    }

    private void closeReaders() throws CorruptIndexException, IOException {
        if (this.searcherManager != null) {
            this.searcherManager.close();
            this.searcherManager = null;
        }
        if (this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    @Override
    public GavCalculator getGavCalculator() {
        return this.gavCalculator;
    }

    @Override
    public List<IndexCreator> getIndexCreators() {
        return Collections.unmodifiableList(this.indexCreators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rebuildGroups() throws IOException {
        IndexSearcher is = this.acquireIndexSearcher();
        try {
            IndexReader r = is.getIndexReader();
            LinkedHashSet<String> rootGroups = new LinkedHashSet<String>();
            LinkedHashSet<String> allGroups = new LinkedHashSet<String>();
            int numDocs = r.maxDoc();
            for (int i = 0; i < numDocs; ++i) {
                Document d;
                String uinfo;
                if (r.isDeleted(i) || (uinfo = (d = r.document(i)).get(ArtifactInfo.UINFO)) == null) continue;
                ArtifactInfo info = IndexUtils.constructArtifactInfo(d, this);
                rootGroups.add(info.getRootGroup());
                allGroups.add(info.groupId);
            }
            this.setRootGroups(rootGroups);
            this.setAllGroups(allGroups);
            this.optimize();
        }
        finally {
            this.releaseIndexSearcher(is);
        }
    }

    @Override
    public Set<String> getAllGroups() throws IOException {
        return this.getGroups("allGroups", "allGroups", "allGroupsList");
    }

    @Override
    public synchronized void setAllGroups(Collection<String> groups) throws IOException {
        this.setGroups(groups, "allGroups", "allGroups", "allGroupsList");
        this.commit();
    }

    @Override
    public Set<String> getRootGroups() throws IOException {
        return this.getGroups("rootGroups", "rootGroups", "rootGroupsList");
    }

    @Override
    public synchronized void setRootGroups(Collection<String> groups) throws IOException {
        this.setGroups(groups, "rootGroups", "rootGroups", "rootGroupsList");
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getGroups(String field, String filedValue, String listField) throws IOException, CorruptIndexException {
        TopScoreDocCollector collector = TopScoreDocCollector.create(1, false);
        IndexSearcher indexSearcher = this.acquireIndexSearcher();
        try {
            Document doc;
            String groupList;
            indexSearcher.search((Query)new TermQuery(new Term(field, filedValue)), collector);
            TopDocs topDocs = collector.topDocs();
            LinkedHashSet<String> groups = new LinkedHashSet<String>(Math.max(10, topDocs.totalHits));
            if (topDocs.totalHits > 0 && (groupList = (doc = indexSearcher.doc(topDocs.scoreDocs[0].doc)).get(listField)) != null) {
                groups.addAll(Arrays.asList(groupList.split("\\|")));
            }
            LinkedHashSet<String> linkedHashSet = groups;
            return linkedHashSet;
        }
        finally {
            this.releaseIndexSearcher(indexSearcher);
        }
    }

    protected void setGroups(Collection<String> groups, String groupField, String groupFieldValue, String groupListField) throws IOException, CorruptIndexException {
        IndexWriter w = this.getIndexWriter();
        w.updateDocument(new Term(groupField, groupFieldValue), this.createGroupsDocument(groups, groupField, groupFieldValue, groupListField));
    }

    protected Document createGroupsDocument(Collection<String> groups, String field, String fieldValue, String listField) {
        Document groupDoc = new Document();
        groupDoc.add(new Field(field, fieldValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
        groupDoc.add(new Field(listField, ArtifactInfo.lst2str(groups), Field.Store.YES, Field.Index.NO));
        return groupDoc;
    }

    public String toString() {
        return this.id + " : " + this.timestamp;
    }
}

