/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.file.FileEntry;
import de.schlichtherle.truezip.fs.file.TempFilePool;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class FileOutputSocket
extends OutputSocket<FileEntry> {
    private static final String FILE_POOL_PREFIX = ".tzp";
    private final FileEntry entry;
    private final BitField<FsOutputOption> options;
    @CheckForNull
    private final Entry template;
    @CheckForNull
    private volatile TempFilePool pool;

    FileOutputSocket(FileEntry entry, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        assert (null != entry);
        assert (null != options);
        this.entry = entry;
        this.options = options;
        this.template = template;
    }

    private TempFilePool getTempFilePool() {
        TempFilePool pool = this.pool;
        return null != pool ? pool : (this.pool = new TempFilePool(FILE_POOL_PREFIX, null, this.entry.getFile().getParentFile()));
    }

    @Override
    public FileEntry getLocalTarget() {
        return this.entry;
    }

    @Override
    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public OutputStream newOutputStream() throws IOException {
        final File entryFile = this.entry.getFile();
        if (this.options.get(FsOutputOption.EXCLUSIVE) && entryFile.exists()) {
            throw new IOException(entryFile.getPath() + " (file exists already)");
        }
        if (this.options.get(FsOutputOption.CREATE_PARENTS)) {
            entryFile.getParentFile().mkdirs();
        }
        final FileEntry temp = this.options.get(FsOutputOption.CACHE) && !entryFile.createNewFile() ? this.getTempFilePool().allocate() : this.entry;
        final File tempFile = temp.getFile();
        try {
            if (temp != this.entry && this.options.get(FsOutputOption.APPEND)) {
                IOSocket.copy(this.entry.getInputSocket(), temp.getOutputSocket());
            }
            class OutputStream
            extends DecoratingOutputStream {
                boolean closed;

                OutputStream() throws FileNotFoundException {
                    super(new FileOutputStream(file, FileOutputSocket.this.options.get(FsOutputOption.APPEND)));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        super.close();
                        return;
                    }
                    finally {
                        block28: {
                            try {
                                if (temp == FileOutputSocket.this.entry) break block28;
                                IOException cause = null;
                                try {
                                    if (!(tempFile.renameTo(entryFile) || entryFile.delete() && tempFile.renameTo(entryFile))) {
                                        IOSocket.copy(temp.getInputSocket(), FileOutputSocket.this.entry.getOutputSocket());
                                    }
                                }
                                catch (IOException ex) {
                                    cause = ex;
                                    throw cause;
                                }
                                finally {
                                    try {
                                        ((IOPool.Entry)((Object)temp)).release();
                                    }
                                    catch (IOException ex) {
                                        throw (IOException)ex.initCause(cause);
                                    }
                                }
                            }
                            finally {
                                long time;
                                Entry template = FileOutputSocket.this.template;
                                if (null != template && -1L != (time = template.getTime(Entry.Access.WRITE)) && !entryFile.setLastModified(time)) {
                                    throw new IOException(entryFile.getPath() + " (cannot preserve last modification time)");
                                }
                            }
                        }
                    }
                }
            }
            return new OutputStream();
        }
        catch (IOException cause) {
            if (temp != this.entry) {
                try {
                    ((IOPool.Entry)((Object)temp)).release();
                }
                catch (IOException ex) {
                    throw (IOException)ex.initCause(cause);
                }
            }
            throw cause;
        }
    }
}

