/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.FsUriModifier;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS", "SE_TRANSIENT_FIELD_NOT_RESTORED"})
public final class FsMountPoint
implements Serializable,
Comparable<FsMountPoint> {
    private static final long serialVersionUID = 5723957985634276648L;
    @NonNull
    private URI uri;
    @Nullable
    private transient FsPath path;
    @Nullable
    private volatile transient FsScheme scheme;
    @Nullable
    private volatile transient FsMountPoint hierarchical;

    @NonNull
    public static FsMountPoint create(@NonNull String uri) {
        return FsMountPoint.create(uri, FsUriModifier.NULL);
    }

    @NonNull
    public static FsMountPoint create(@NonNull String uri, @NonNull FsUriModifier modifier) {
        try {
            return new FsMountPoint(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NonNull
    public static FsMountPoint create(@NonNull URI uri) {
        return FsMountPoint.create(uri, FsUriModifier.NULL);
    }

    @NonNull
    public static FsMountPoint create(@NonNull URI uri, @NonNull FsUriModifier modifier) {
        try {
            return new FsMountPoint(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NonNull
    public static FsMountPoint create(@NonNull FsScheme scheme, @NonNull FsPath path) {
        try {
            return new FsMountPoint(scheme, path);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public FsMountPoint(@NonNull String uri) throws URISyntaxException {
        this.parse(new URI(uri), FsUriModifier.NULL);
    }

    public FsMountPoint(@NonNull String uri, @NonNull FsUriModifier modifier) throws URISyntaxException {
        this.parse(new URI(uri), modifier);
    }

    public FsMountPoint(@NonNull URI uri) throws URISyntaxException {
        this.parse(uri, FsUriModifier.NULL);
    }

    public FsMountPoint(@NonNull URI uri, @NonNull FsUriModifier modifier) throws URISyntaxException {
        this.parse(uri, modifier);
    }

    public FsMountPoint(@NonNull FsScheme scheme, @NonNull FsPath path) throws URISyntaxException {
        URI pathUri = path.getUri();
        if (!pathUri.isAbsolute()) {
            throw new URISyntaxException(FsMountPoint.quote(pathUri), "Path not absolute");
        }
        String pathEntryNameUriPath = path.getEntryName().getUri().getPath();
        if (0 == pathEntryNameUriPath.length()) {
            throw new URISyntaxException(FsMountPoint.quote(pathUri), "Empty entry name");
        }
        this.uri = new URI(scheme.toString() + ':' + path.toString() + "!/");
        this.scheme = scheme;
        this.path = path;
        assert (this.invariants());
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri.toString());
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(in.readObject().toString()), FsUriModifier.NULL);
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(@NonNull URI uri, @NonNull FsUriModifier modifier) throws URISyntaxException {
        if (null != uri.getRawFragment()) {
            throw new URISyntaxException(FsMountPoint.quote(uri), "Fragment not allowed");
        }
        if (uri.isOpaque()) {
            URI nuri;
            String ssp = uri.getRawSchemeSpecificPart();
            int i = ssp.lastIndexOf("!/");
            if (ssp.length() - 2 != i) {
                throw new URISyntaxException(FsMountPoint.quote(uri), "Doesn't end with mount point separator \"!/\"");
            }
            this.path = new FsPath(ssp.substring(0, i), modifier);
            URI pathUri = this.path.getUri();
            if (!pathUri.isAbsolute()) {
                throw new URISyntaxException(FsMountPoint.quote(uri), "Path not absolute");
            }
            if (0 == this.path.getEntryName().getPath().length()) {
                throw new URISyntaxException(FsMountPoint.quote(uri), "Empty URI path of entry name of path");
            }
            if (FsUriModifier.NULL != modifier && !uri.equals(nuri = new URI(uri.getScheme() + ':' + pathUri.toString() + "!/"))) {
                uri = nuri;
            }
        } else {
            if (!(uri = modifier.modify(uri, FsUriModifier.PostFix.MOUNT_POINT)).isAbsolute()) {
                throw new URISyntaxException(FsMountPoint.quote(uri), "Not absolute");
            }
            if (!uri.getRawPath().endsWith("/")) {
                throw new URISyntaxException(FsMountPoint.quote(uri), "URI path doesn't end with separator \"/\"");
            }
            this.path = null;
        }
        this.uri = uri;
        assert (this.invariants());
    }

    private static String quote(Object s) {
        return "\"" + s + "\"";
    }

    private boolean invariants() {
        assert (null != this.getUri());
        assert (this.getUri().isAbsolute());
        assert (null == this.getUri().getRawFragment());
        if (this.getUri().isOpaque()) {
            assert (this.getUri().getRawSchemeSpecificPart().endsWith("!/"));
            assert (null != this.getPath());
            assert (this.getPath().getUri().isAbsolute());
            assert (null == this.getPath().getUri().getRawFragment());
            assert (0 != this.getPath().getEntryName().getUri().getRawPath().length());
        } else {
            assert (this.getUri().normalize() == this.getUri());
            assert (this.getUri().getRawPath().endsWith("/"));
            assert (null == this.getPath());
        }
        return true;
    }

    @NonNull
    public FsScheme getScheme() {
        return null != this.scheme ? this.scheme : (this.scheme = FsScheme.create(this.uri.getScheme()));
    }

    @Nullable
    public FsPath getPath() {
        return this.path;
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @Nullable
    public FsMountPoint getParent() {
        assert (null == this.path || null != this.path.getMountPoint());
        return null == this.path ? null : this.path.getMountPoint();
    }

    @NonNull
    public FsPath resolve(@NonNull FsEntryName entryName) {
        return new FsPath(this, entryName);
    }

    @NonNull
    public FsMountPoint hierarchicalize() {
        if (null != this.hierarchical) {
            return this.hierarchical;
        }
        if (this.uri.isOpaque()) {
            URI uri = this.path.hierarchicalize().getUri();
            try {
                this.hierarchical = new FsMountPoint(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath() + '/', uri.getQuery(), null));
                return this.hierarchical;
            }
            catch (URISyntaxException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        this.hierarchical = this;
        return this.hierarchical;
    }

    public boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof FsMountPoint && this.uri.equals(((FsMountPoint)that).uri);
    }

    @Override
    public int compareTo(@NonNull FsMountPoint that) {
        return this.uri.compareTo(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @NonNull
    public String toString() {
        return this.uri.toString();
    }
}

