/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.xmlparser.builders;

import org.apache.lucene.search.BoostingQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.xmlparser.DOMUtils;
import org.apache.lucene.xmlparser.ParserException;
import org.apache.lucene.xmlparser.QueryBuilder;
import org.w3c.dom.Element;

public class BoostingQueryBuilder
implements QueryBuilder {
    private QueryBuilder factory;
    float defaultBoost = 0.01f;

    public BoostingQueryBuilder(QueryBuilder factory) {
        this.factory = factory;
    }

    public Query getQuery(Element e) throws ParserException {
        Element mainQueryElem = DOMUtils.getChildByTagName(e, "Query");
        if (mainQueryElem == null) {
            throw new ParserException("BoostingQuery missing a \"Query\" child element");
        }
        if ((mainQueryElem = DOMUtils.getFirstChildElement(mainQueryElem)) == null) {
            throw new ParserException("BoostingQuery \"Query\" element missing a child element");
        }
        Query mainQuery = this.factory.getQuery(mainQueryElem);
        Element boostQueryElem = DOMUtils.getChildByTagName(e, "BoostQuery");
        float boost = DOMUtils.getAttribute(boostQueryElem, "boost", this.defaultBoost);
        if (boostQueryElem == null) {
            throw new ParserException("BoostingQuery missing a \"BoostQuery\" child element");
        }
        if ((boostQueryElem = DOMUtils.getFirstChildElement(boostQueryElem)) == null) {
            throw new ParserException("BoostingQuery \"BoostQuery\" element missing a child element");
        }
        Query boostQuery = this.factory.getQuery(boostQueryElem);
        BoostingQuery bq = new BoostingQuery(mainQuery, boostQuery, boost);
        bq.setBoost(DOMUtils.getAttribute(e, "boost", 1.0f));
        return bq;
    }
}

