/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.tests.analysis.CannedTokenStream;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.analysis.MockTokenizer;
import org.apache.lucene.tests.analysis.Token;
import org.apache.lucene.tests.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.index.RandomPostingsTester;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LineFileDocs;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.RamUsageTester;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.BytesRef;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class BasePostingsFormatTestCase
extends BaseIndexFileFormatTestCase {
    static RandomPostingsTester postingsTester;

    @BeforeClass
    public static void createPostings() throws IOException {
        postingsTester = new RandomPostingsTester(BasePostingsFormatTestCase.random());
    }

    @AfterClass
    public static void afterClass() throws Exception {
        postingsTester = null;
    }

    public void testDocsOnly() throws Exception {
        postingsTester.testFull(this.getCodec(), BasePostingsFormatTestCase.createTempDir("testPostingsFormat.testExact"), IndexOptions.DOCS, false);
    }

    public void testDocsAndFreqs() throws Exception {
        postingsTester.testFull(this.getCodec(), BasePostingsFormatTestCase.createTempDir("testPostingsFormat.testExact"), IndexOptions.DOCS_AND_FREQS, false);
    }

    public void testDocsAndFreqsAndPositions() throws Exception {
        postingsTester.testFull(this.getCodec(), BasePostingsFormatTestCase.createTempDir("testPostingsFormat.testExact"), IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, false);
    }

    public void testDocsAndFreqsAndPositionsAndPayloads() throws Exception {
        postingsTester.testFull(this.getCodec(), BasePostingsFormatTestCase.createTempDir("testPostingsFormat.testExact"), IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, true);
    }

    public void testDocsAndFreqsAndPositionsAndOffsets() throws Exception {
        postingsTester.testFull(this.getCodec(), BasePostingsFormatTestCase.createTempDir("testPostingsFormat.testExact"), IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, false);
    }

    public void testDocsAndFreqsAndPositionsAndOffsetsAndPayloads() throws Exception {
        postingsTester.testFull(this.getCodec(), BasePostingsFormatTestCase.createTempDir("testPostingsFormat.testExact"), IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, true);
    }

    public void testRandom() throws Exception {
        int iters = 5;
        for (int iter = 0; iter < iters; ++iter) {
            Path path = BasePostingsFormatTestCase.createTempDir("testPostingsFormat");
            BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newFSDirectory(path);
            boolean indexPayloads = BasePostingsFormatTestCase.random().nextBoolean();
            FieldsProducer fieldsProducer = postingsTester.buildIndex(this.getCodec(), (Directory)dir, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, indexPayloads, false);
            postingsTester.testFields((Fields)fieldsProducer);
            postingsTester.testTerms((Fields)fieldsProducer, EnumSet.allOf(RandomPostingsTester.Option.class), IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, false);
            fieldsProducer.close();
            fieldsProducer = null;
            dir.close();
        }
    }

    protected boolean isPostingsEnumReuseImplemented() {
        return true;
    }

    public void testPostingsEnumReuse() throws Exception {
        Path path = BasePostingsFormatTestCase.createTempDir("testPostingsEnumReuse");
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newFSDirectory(path);
        FieldsProducer fieldsProducer = postingsTester.buildIndex(this.getCodec(), (Directory)dir, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, BasePostingsFormatTestCase.random().nextBoolean(), true);
        Collections.shuffle(BasePostingsFormatTestCase.postingsTester.allTerms, BasePostingsFormatTestCase.random());
        RandomPostingsTester.FieldAndTerm fieldAndTerm = BasePostingsFormatTestCase.postingsTester.allTerms.get(0);
        Terms terms = fieldsProducer.terms(fieldAndTerm.field);
        TermsEnum te = terms.iterator();
        te.seekExact(fieldAndTerm.term);
        BasePostingsFormatTestCase.checkReuse(te, 8, 120, false);
        if (this.isPostingsEnumReuseImplemented()) {
            BasePostingsFormatTestCase.checkReuse(te, 120, 120, true);
        }
        fieldsProducer.close();
        dir.close();
    }

    protected static void checkReuse(TermsEnum termsEnum, int firstFlags, int secondFlags, boolean shouldReuse) throws IOException {
        PostingsEnum postings1 = termsEnum.postings(null, firstFlags);
        PostingsEnum postings2 = termsEnum.postings(postings1, secondFlags);
        if (shouldReuse) {
            BasePostingsFormatTestCase.assertSame((String)("Expected PostingsEnum " + postings1.getClass().getName() + " to be reused"), (Object)postings1, (Object)postings2);
        } else {
            BasePostingsFormatTestCase.assertNotSame((String)("Expected PostingsEnum " + postings1.getClass().getName() + " to not be reused"), (Object)postings1, (Object)postings2);
        }
    }

    public void testJustEmptyField() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(null);
        iwc.setCodec(this.getCodec());
        RandomIndexWriter iw = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)BasePostingsFormatTestCase.newStringField("", "something", Field.Store.NO));
        iw.addDocument(doc);
        DirectoryReader ir = iw.getReader();
        LeafReader ar = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)ir);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)ar.getFieldInfos().size());
        Terms terms = ar.terms("");
        BasePostingsFormatTestCase.assertNotNull((Object)terms);
        TermsEnum termsEnum = terms.iterator();
        BasePostingsFormatTestCase.assertNotNull((Object)termsEnum.next());
        BasePostingsFormatTestCase.assertEquals((Object)termsEnum.term(), (Object)new BytesRef((CharSequence)"something"));
        BasePostingsFormatTestCase.assertNull((Object)termsEnum.next());
        ir.close();
        iw.close();
        dir.close();
    }

    public void testEmptyFieldAndEmptyTerm() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(null);
        iwc.setCodec(this.getCodec());
        RandomIndexWriter iw = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)BasePostingsFormatTestCase.newStringField("", "", Field.Store.NO));
        iw.addDocument(doc);
        DirectoryReader ir = iw.getReader();
        LeafReader ar = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)ir);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)ar.getFieldInfos().size());
        Terms terms = ar.terms("");
        BasePostingsFormatTestCase.assertNotNull((Object)terms);
        TermsEnum termsEnum = terms.iterator();
        BasePostingsFormatTestCase.assertNotNull((Object)termsEnum.next());
        BasePostingsFormatTestCase.assertEquals((Object)termsEnum.term(), (Object)new BytesRef((CharSequence)""));
        BasePostingsFormatTestCase.assertNull((Object)termsEnum.next());
        ir.close();
        iw.close();
        dir.close();
    }

    public void testDidntWantFreqsButAskedAnyway() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BasePostingsFormatTestCase.random()));
        iwc.setCodec(this.getCodec());
        RandomIndexWriter iw = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)BasePostingsFormatTestCase.newTextField("field", "value", Field.Store.NO));
        iw.addDocument(doc);
        iw.addDocument(doc);
        DirectoryReader ir = iw.getReader();
        LeafReader ar = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)ir);
        TermsEnum termsEnum = ar.terms("field").iterator();
        BasePostingsFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"value")));
        PostingsEnum docsEnum = termsEnum.postings(null, 0);
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.freq());
        ir.close();
        iw.close();
        dir.close();
    }

    public void testAskForPositionsWhenNotThere() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BasePostingsFormatTestCase.random()));
        iwc.setCodec(this.getCodec());
        RandomIndexWriter iw = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)BasePostingsFormatTestCase.newStringField("field", "value", Field.Store.NO));
        iw.addDocument(doc);
        iw.addDocument(doc);
        DirectoryReader ir = iw.getReader();
        LeafReader ar = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)ir);
        TermsEnum termsEnum = ar.terms("field").iterator();
        BasePostingsFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"value")));
        PostingsEnum docsEnum = termsEnum.postings(null, 24);
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.freq());
        ir.close();
        iw.close();
        dir.close();
    }

    public void testGhosts() throws Exception {
        TermsEnum termsEnum;
        BytesRef term;
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(null);
        iwc.setCodec(this.getCodec());
        iwc.setMergePolicy((MergePolicy)BasePostingsFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        Document doc = new Document();
        iw.addDocument(doc);
        doc.add((IndexableField)BasePostingsFormatTestCase.newStringField("ghostField", "something", Field.Store.NO));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.deleteDocuments(new Term("ghostField", "something"));
        iw.forceMerge(1);
        DirectoryReader ir = iw.getReader();
        LeafReader ar = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)ir);
        BasePostingsFormatTestCase.assertTrue((ar.getFieldInfos().size() <= 1 ? 1 : 0) != 0);
        Terms terms = ar.terms("ghostField");
        if (terms != null && (term = (termsEnum = terms.iterator()).next()) != null) {
            PostingsEnum postingsEnum = termsEnum.postings(null);
            BasePostingsFormatTestCase.assertTrue((postingsEnum.nextDoc() == Integer.MAX_VALUE ? 1 : 0) != 0);
        }
        ir.close();
        iw.close();
        dir.close();
    }

    public void testLevel2Ghosts() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(null);
        iwc.setCodec(this.getCodec());
        iwc.setMergePolicy((MergePolicy)BasePostingsFormatTestCase.newLogMergePolicy());
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document document = new Document();
        document.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        document.add((IndexableField)new StringField("suggest_field", "apples", Field.Store.NO));
        iw.addDocument((Iterable)document);
        iw.addDocument((Iterable)new Document());
        iw.commit();
        document = new Document();
        document.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        document.add((IndexableField)new StringField("suggest_field2", "apples", Field.Store.NO));
        iw.addDocument((Iterable)document);
        iw.commit();
        iw.deleteDocuments(new Term[]{new Term("id", "0")});
        iw.forceMerge(1);
        iw.addDocument((Iterable)new Document());
        iw.forceMerge(1);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        IndexSearcher indexSearcher = new IndexSearcher((IndexReader)reader);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)indexSearcher.count((Query)new TermQuery(new Term("id", "1"))));
        reader.close();
        iw.close();
        dir.close();
    }

    public void testInvertedWrite() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BasePostingsFormatTestCase.random());
        analyzer.setMaxTokenLength(TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, 32766));
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(analyzer);
        final ConcurrentHashMap termFreqs = new ConcurrentHashMap();
        final AtomicLong sumDocFreq = new AtomicLong();
        final AtomicLong sumTotalTermFreq = new AtomicLong();
        iwc.setCodec((Codec)new FilterCodec(this.getCodec().getName(), this.getCodec()){

            public PostingsFormat postingsFormat() {
                final PostingsFormat defaultPostingsFormat = this.delegate.postingsFormat();
                final Thread mainThread = Thread.currentThread();
                return new PostingsFormat(defaultPostingsFormat.getName()){

                    public FieldsConsumer fieldsConsumer(final SegmentWriteState state) throws IOException {
                        final FieldsConsumer fieldsConsumer = defaultPostingsFormat.fieldsConsumer(state);
                        return new FieldsConsumer(){

                            public void write(Fields fields, NormsProducer norms) throws IOException {
                                boolean isMerge;
                                fieldsConsumer.write(fields, norms);
                                boolean bl = isMerge = state.context.context == IOContext.Context.MERGE;
                                assert (isMerge || Thread.currentThread() == mainThread);
                                boolean addOnSecondPass = LuceneTestCase.random().nextBoolean();
                                Terms terms = fields.terms("body");
                                assert (terms != null);
                                TermsEnum termsEnum = terms.iterator();
                                PostingsEnum docs = null;
                                while (termsEnum.next() != null) {
                                    BytesRef term = termsEnum.term();
                                    boolean noPositions = LuceneTestCase.random().nextBoolean();
                                    docs = noPositions ? termsEnum.postings(docs, 8) : termsEnum.postings(null, 24);
                                    int docFreq = 0;
                                    long totalTermFreq = 0L;
                                    while (docs.nextDoc() != Integer.MAX_VALUE) {
                                        ++docFreq;
                                        totalTermFreq += (long)docs.freq();
                                        int limit = TestUtil.nextInt(LuceneTestCase.random(), 1, docs.freq());
                                        if (noPositions) continue;
                                        for (int i = 0; i < limit; ++i) {
                                            docs.nextPosition();
                                        }
                                    }
                                    String termString = term.utf8ToString();
                                    Assert.assertTrue((!isMerge || termFreqs.containsKey(termString) ? 1 : 0) != 0);
                                    if (isMerge) continue;
                                    if (!addOnSecondPass) {
                                        TermFreqs tf = (TermFreqs)termFreqs.get(termString);
                                        if (tf == null) {
                                            tf = new TermFreqs();
                                            termFreqs.put(termString, tf);
                                        }
                                        tf.docFreq += docFreq;
                                        tf.totalTermFreq += totalTermFreq;
                                        sumDocFreq.addAndGet(docFreq);
                                        sumTotalTermFreq.addAndGet(totalTermFreq);
                                        continue;
                                    }
                                    if (termFreqs.containsKey(termString)) continue;
                                    termFreqs.put(termString, new TermFreqs());
                                }
                                for (String term : termFreqs.keySet()) {
                                    if (!termsEnum.seekExact(new BytesRef((CharSequence)term))) continue;
                                    boolean noPositions = LuceneTestCase.random().nextBoolean();
                                    docs = noPositions ? termsEnum.postings(docs, 8) : termsEnum.postings(null, 24);
                                    int docFreq = 0;
                                    long totalTermFreq = 0L;
                                    while (docs.nextDoc() != Integer.MAX_VALUE) {
                                        ++docFreq;
                                        totalTermFreq += (long)docs.freq();
                                        int limit = TestUtil.nextInt(LuceneTestCase.random(), 1, docs.freq());
                                        if (noPositions) continue;
                                        for (int i = 0; i < limit; ++i) {
                                            docs.nextPosition();
                                        }
                                    }
                                    if (!isMerge && addOnSecondPass) {
                                        TermFreqs tf = (TermFreqs)termFreqs.get(term);
                                        assert (tf != null);
                                        tf.docFreq += docFreq;
                                        tf.totalTermFreq += totalTermFreq;
                                        sumDocFreq.addAndGet(docFreq);
                                        sumTotalTermFreq.addAndGet(totalTermFreq);
                                    }
                                    Assert.assertTrue((docFreq <= ((TermFreqs)termFreqs.get((Object)term)).docFreq ? 1 : 0) != 0);
                                    Assert.assertTrue((totalTermFreq <= ((TermFreqs)termFreqs.get((Object)term)).totalTermFreq ? 1 : 0) != 0);
                                }
                                for (int iter = 0; iter < 10; ++iter) {
                                    BytesRef term = new BytesRef((CharSequence)TestUtil.randomRealisticUnicodeString(LuceneTestCase.random()));
                                    TermsEnum.SeekStatus status = termsEnum.seekCeil(term);
                                    if (status != TermsEnum.SeekStatus.NOT_FOUND) continue;
                                    Assert.assertTrue((term.compareTo(termsEnum.term()) < 0 ? 1 : 0) != 0);
                                }
                            }

                            public void close() throws IOException {
                                fieldsConsumer.close();
                            }
                        };
                    }

                    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
                        return defaultPostingsFormat.fieldsProducer(state);
                    }
                };
            }
        });
        RandomIndexWriter w = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        LineFileDocs docs = new LineFileDocs(BasePostingsFormatTestCase.random());
        int bytesToIndex = BasePostingsFormatTestCase.atLeast(100) * 1024;
        int bytesIndexed = 0;
        while (bytesIndexed < bytesToIndex) {
            Document doc = docs.nextDoc();
            Document justBodyDoc = new Document();
            justBodyDoc.add(doc.getField("body"));
            w.addDocument(justBodyDoc);
            bytesIndexed = (int)((long)bytesIndexed + RamUsageTester.ramUsed(justBodyDoc));
        }
        DirectoryReader r = w.getReader();
        w.close();
        Terms terms = MultiTerms.getTerms((IndexReader)r, (String)"body");
        BasePostingsFormatTestCase.assertEquals((long)sumDocFreq.get(), (long)terms.getSumDocFreq());
        BasePostingsFormatTestCase.assertEquals((long)sumTotalTermFreq.get(), (long)terms.getSumTotalTermFreq());
        TermsEnum termsEnum = terms.iterator();
        long termCount = 0L;
        boolean supportsOrds = true;
        while (termsEnum.next() != null) {
            BytesRef term = termsEnum.term();
            BasePostingsFormatTestCase.assertEquals((long)((TermFreqs)termFreqs.get((Object)term.utf8ToString())).docFreq, (long)termsEnum.docFreq());
            BasePostingsFormatTestCase.assertEquals((long)((TermFreqs)termFreqs.get((Object)term.utf8ToString())).totalTermFreq, (long)termsEnum.totalTermFreq());
            if (supportsOrds) {
                long ord;
                try {
                    ord = termsEnum.ord();
                }
                catch (UnsupportedOperationException uoe) {
                    supportsOrds = false;
                    ord = -1L;
                }
                if (ord != -1L) {
                    BasePostingsFormatTestCase.assertEquals((long)termCount, (long)ord);
                }
            }
            ++termCount;
        }
        BasePostingsFormatTestCase.assertEquals((long)termFreqs.size(), (long)termCount);
        r.close();
        dir.close();
    }

    protected void assertReused(String field, PostingsEnum p1, PostingsEnum p2) {
        if (!"Direct".equals(TestUtil.getPostingsFormat(field))) {
            BasePostingsFormatTestCase.assertSame((Object)p1, (Object)p2);
        }
    }

    public void testPostingsEnumDocsOnly() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("foo", "bar", Field.Store.NO));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).terms("foo").iterator();
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        for (int flag : new int[]{0, 8, 24, 88, 56, 120}) {
            postings = termsEnum.postings(null, flag);
            BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
            BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
            BasePostingsFormatTestCase.assertEquals((long)1L, (long)postings.freq());
            BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
            postings2 = termsEnum.postings(postings, flag);
            BasePostingsFormatTestCase.assertNotNull((Object)postings2);
            this.assertReused("foo", postings, postings2);
            BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
            BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
            BasePostingsFormatTestCase.assertEquals((long)1L, (long)postings2.freq());
            BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        }
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumFreqs() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
        doc.add((IndexableField)new Field("foo", (CharSequence)"bar bar", (IndexableFieldType)ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).terms("foo").iterator();
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", docsOnly, docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        for (int flag : new int[]{0, 8, 24, 88, 56, 120}) {
            postings = termsEnum.postings(null, flag);
            BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
            BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
            if (flag != 0) {
                BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
            }
            BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
            postings2 = termsEnum.postings(postings, flag);
            BasePostingsFormatTestCase.assertNotNull((Object)postings2);
            this.assertReused("foo", postings, postings2);
            BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
            BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
            if (flag != 0) {
                BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
            }
            BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        }
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumPositions() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)new TextField("foo", "bar bar", Field.Store.NO));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).terms("foo").iterator();
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", docsOnly, docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 24);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 24);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 88);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 88);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 56);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 56);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 120);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 120);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumOffsets() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        doc.add((IndexableField)new Field("foo", (CharSequence)"bar bar", (IndexableFieldType)ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).terms("foo").iterator();
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", docsOnly, docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 24);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 24);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 88);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 88);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 56);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 56);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 120);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 120);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumPayloads() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        Token token1 = new Token("bar", 0, 3);
        token1.setPayload(new BytesRef((CharSequence)"pay1"));
        Token token2 = new Token("bar", 4, 7);
        token2.setPayload(new BytesRef((CharSequence)"pay2"));
        doc.add((IndexableField)new TextField("foo", (TokenStream)new CannedTokenStream(token1, token2)));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).terms("foo").iterator();
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", docsOnly, docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 24);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 24);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 88);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 88);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 56);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 56);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 120);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 120);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumAll() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        Token token1 = new Token("bar", 0, 3);
        token1.setPayload(new BytesRef((CharSequence)"pay1"));
        Token token2 = new Token("bar", 4, 7);
        token2.setPayload(new BytesRef((CharSequence)"pay2"));
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        doc.add((IndexableField)new Field("foo", (TokenStream)new CannedTokenStream(token1, token2), (IndexableFieldType)ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).terms("foo").iterator();
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", docsOnly, docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 24);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 24);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 88);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 88);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 56);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 56);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlyLeafReader((IndexReader)reader).postings(new Term("foo", "bar"), 120);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(docsAndPositionsEnum, 120);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    @Override
    protected void addRandomFields(Document doc) {
        for (IndexOptions opts : IndexOptions.values()) {
            if (opts == IndexOptions.NONE) continue;
            FieldType ft = new FieldType();
            ft.setIndexOptions(opts);
            ft.freeze();
            int numFields = BasePostingsFormatTestCase.random().nextInt(5);
            for (int j = 0; j < numFields; ++j) {
                doc.add((IndexableField)new Field("f_" + opts, (CharSequence)TestUtil.randomSimpleString(BasePostingsFormatTestCase.random(), 2), (IndexableFieldType)ft));
            }
        }
    }

    @LuceneTestCase.Nightly
    public void testLineFileDocs() throws IOException {
        try (BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newFSDirectory(BasePostingsFormatTestCase.createTempDir());){
            try (LineFileDocs docs = new LineFileDocs(BasePostingsFormatTestCase.random());
                 IndexWriter w = new IndexWriter((Directory)dir, new IndexWriterConfig());){
                int numDocs = BasePostingsFormatTestCase.atLeast(10000);
                for (int i = 0; i < numDocs; ++i) {
                    Document doc = docs.nextDoc();
                    IndexableField body = doc.getField("body");
                    BasePostingsFormatTestCase.assertNotNull((Object)body);
                    BasePostingsFormatTestCase.assertNotNull((Object)body.stringValue());
                    BasePostingsFormatTestCase.assertNotEquals((Object)IndexOptions.NONE, (Object)body.fieldType().indexOptions());
                    body = new TextField("body", body.stringValue(), Field.Store.NO);
                    w.addDocument(Collections.singletonList(body));
                }
                w.forceMerge(1);
            }
            TestUtil.checkIndex((Directory)dir);
        }
    }

    private static class TermFreqs {
        long totalTermFreq;
        int docFreq;

        private TermFreqs() {
        }
    }
}

