/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.compressing.dummy;

import java.io.IOException;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.tests.codecs.compressing.CompressingCodec;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

public class DummyCompressingCodec
extends CompressingCodec {
    public static final CompressionMode DUMMY = new CompressionMode(){

        public Compressor newCompressor() {
            return DUMMY_COMPRESSOR;
        }

        public Decompressor newDecompressor() {
            return DUMMY_DECOMPRESSOR;
        }

        public String toString() {
            return "DUMMY";
        }
    };
    private static final Decompressor DUMMY_DECOMPRESSOR = new Decompressor(){

        public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
            assert (offset + length <= originalLength);
            if (bytes.bytes.length < originalLength) {
                bytes.bytes = new byte[ArrayUtil.oversize((int)originalLength, (int)1)];
            }
            in.readBytes(bytes.bytes, 0, offset + length);
            bytes.offset = offset;
            bytes.length = length;
        }

        public Decompressor clone() {
            return this;
        }
    };
    private static final Compressor DUMMY_COMPRESSOR = new Compressor(){

        public void compress(ByteBuffersDataInput buffersInput, DataOutput out) throws IOException {
            out.copyBytes((DataInput)buffersInput, buffersInput.size());
        }

        public void close() throws IOException {
        }
    };

    public DummyCompressingCodec(int chunkSize, int maxDocsPerChunk, boolean withSegmentSuffix, int blockSize) {
        super("DummyCompressingStoredFieldsData", withSegmentSuffix ? "DummyCompressingStoredFields" : "", DUMMY, chunkSize, maxDocsPerChunk, blockSize);
    }

    public DummyCompressingCodec() {
        this(16384, 128, false, 10);
    }
}

