/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.cranky;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

class CrankyNormsFormat
extends NormsFormat {
    final NormsFormat delegate;
    final Random random;

    CrankyNormsFormat(NormsFormat delegate, Random random) {
        this.delegate = delegate;
        this.random = random;
    }

    public NormsConsumer normsConsumer(SegmentWriteState state) throws IOException {
        if (this.random.nextInt(100) == 0) {
            throw new IOException("Fake IOException from NormsFormat.normsConsumer()");
        }
        return new CrankyNormsConsumer(this.delegate.normsConsumer(state), this.random);
    }

    public NormsProducer normsProducer(SegmentReadState state) throws IOException {
        return this.delegate.normsProducer(state);
    }

    static class CrankyNormsConsumer
    extends NormsConsumer {
        final NormsConsumer delegate;
        final Random random;

        CrankyNormsConsumer(NormsConsumer delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from NormsConsumer.close()");
            }
        }

        public void addNormsField(FieldInfo field, NormsProducer valuesProducer) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from NormsConsumer.addNormsField()");
            }
            this.delegate.addNormsField(field, valuesProducer);
        }
    }
}

