/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.MergeReaderWrapper;
import org.apache.lucene.tests.index.MismatchedCodecReader;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;

public class MockRandomMergePolicy
extends MergePolicy {
    private final Random random;
    boolean doNonBulkMerges = true;

    public MockRandomMergePolicy(Random random) {
        this.random = new Random(random.nextLong());
    }

    public void setDoNonBulkMerges(boolean v) {
        this.doNonBulkMerges = v;
    }

    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) {
        MergePolicy.MergeSpecification mergeSpec = null;
        ArrayList<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
        Set merging = mergeContext.getMergingSegments();
        for (SegmentCommitInfo sipc : segmentInfos) {
            if (merging.contains(sipc)) continue;
            segments.add(sipc);
        }
        int numSegments = segments.size();
        if (numSegments > 1 && (numSegments > 30 || this.random.nextInt(5) == 3)) {
            Collections.shuffle(segments, this.random);
            mergeSpec = new MergePolicy.MergeSpecification();
            int segsToMerge = TestUtil.nextInt(this.random, 1, numSegments);
            if (this.doNonBulkMerges && this.random.nextBoolean()) {
                mergeSpec.add((MergePolicy.OneMerge)new MockRandomOneMerge(segments.subList(0, segsToMerge), this.random.nextLong()));
            } else {
                mergeSpec.add(new MergePolicy.OneMerge(segments.subList(0, segsToMerge)));
            }
        }
        return mergeSpec;
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        ArrayList<SegmentCommitInfo> eligibleSegments = new ArrayList<SegmentCommitInfo>();
        for (SegmentCommitInfo info : segmentInfos) {
            if (!segmentsToMerge.containsKey(info)) continue;
            eligibleSegments.add(info);
        }
        MergePolicy.MergeSpecification mergeSpec = null;
        if (eligibleSegments.size() > 1 || eligibleSegments.size() == 1 && !this.isMerged(segmentInfos, (SegmentCommitInfo)eligibleSegments.get(0), mergeContext)) {
            int inc;
            mergeSpec = new MergePolicy.MergeSpecification();
            Collections.shuffle(eligibleSegments, this.random);
            for (int upto = 0; upto < eligibleSegments.size(); upto += inc) {
                int max = Math.min(10, eligibleSegments.size() - upto);
                int n = inc = max <= 2 ? max : TestUtil.nextInt(this.random, 2, max);
                if (this.doNonBulkMerges && this.random.nextBoolean()) {
                    mergeSpec.add((MergePolicy.OneMerge)new MockRandomOneMerge(eligibleSegments.subList(upto, upto + inc), this.random.nextLong()));
                    continue;
                }
                mergeSpec.add(new MergePolicy.OneMerge(eligibleSegments.subList(upto, upto + inc)));
            }
        }
        if (mergeSpec != null) {
            for (MergePolicy.OneMerge merge : mergeSpec.merges) {
                for (SegmentCommitInfo info : merge.segments) {
                    assert (segmentsToMerge.containsKey(info));
                }
            }
        }
        return mergeSpec;
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.findMerges(null, segmentInfos, mergeContext);
    }

    public MergePolicy.MergeSpecification findFullFlushMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        MergePolicy.MergeSpecification mergeSpecification = this.findMerges(null, segmentInfos, mergeContext);
        if (mergeSpecification == null) {
            return null;
        }
        MergePolicy.MergeSpecification filteredMergeSpecification = new MergePolicy.MergeSpecification();
        for (MergePolicy.OneMerge oneMerge : mergeSpecification.merges) {
            boolean filtered = false;
            ArrayList<SegmentCommitInfo> nonMergingSegments = new ArrayList<SegmentCommitInfo>();
            for (SegmentCommitInfo sci : oneMerge.segments) {
                if (!mergeContext.getMergingSegments().contains(sci)) {
                    nonMergingSegments.add(sci);
                    continue;
                }
                filtered = true;
            }
            if (filtered) {
                if (nonMergingSegments.size() <= 0) continue;
                filteredMergeSpecification.add(new MergePolicy.OneMerge(nonMergingSegments));
                continue;
            }
            filteredMergeSpecification.add(oneMerge);
        }
        if (filteredMergeSpecification.merges.size() > 0) {
            return filteredMergeSpecification;
        }
        return null;
    }

    public boolean useCompoundFile(SegmentInfos infos, SegmentCommitInfo mergedInfo, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.random.nextInt(5) != 1;
    }

    static Sorter.DocMap reverse(CodecReader reader) throws IOException {
        final int maxDoc = reader.maxDoc();
        final BitSet parents = reader.getFieldInfos().getParentField() == null ? null : BitSet.of((DocIdSetIterator)DocValues.getNumeric((LeafReader)reader, (String)reader.getFieldInfos().getParentField()), (int)maxDoc);
        return new Sorter.DocMap(){

            public int size() {
                return maxDoc;
            }

            public int oldToNew(int docID) {
                if (parents == null) {
                    return maxDoc - 1 - docID;
                }
                int oldBlockStart = docID == 0 ? 0 : parents.prevSetBit(docID - 1) + 1;
                int oldBlockEnd = parents.nextSetBit(docID);
                int newBlockEnd = maxDoc - 1 - oldBlockStart;
                return newBlockEnd - (oldBlockEnd - docID);
            }

            public int newToOld(int docID) {
                if (parents == null) {
                    return maxDoc - 1 - docID;
                }
                int oldBlockEnd = parents.nextSetBit(maxDoc - 1 - docID);
                int newBlockEnd = this.oldToNew(oldBlockEnd);
                return oldBlockEnd - (newBlockEnd - docID);
            }
        };
    }

    static class MockRandomOneMerge
    extends MergePolicy.OneMerge {
        final Random r;

        MockRandomOneMerge(List<SegmentCommitInfo> segments, long seed) {
            super(segments);
            this.r = new Random(seed);
        }

        public CodecReader wrapForMerge(CodecReader reader) throws IOException {
            int thingToDo = this.r.nextInt(7);
            if (thingToDo == 0) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("NOTE: MockRandomMergePolicy now swaps in a SlowCodecReaderWrapper for merging reader=" + reader);
                }
                return SlowCodecReaderWrapper.wrap((LeafReader)new FilterLeafReader(new MergeReaderWrapper(reader)){

                    public IndexReader.CacheHelper getCoreCacheHelper() {
                        return this.in.getCoreCacheHelper();
                    }

                    public IndexReader.CacheHelper getReaderCacheHelper() {
                        return this.in.getReaderCacheHelper();
                    }
                });
            }
            if (thingToDo == 1) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("NOTE: MockRandomMergePolicy now swaps in a MismatchedLeafReader for merging reader=" + reader);
                }
                return new MismatchedCodecReader(reader, this.r);
            }
            return reader;
        }

        public Sorter.DocMap reorder(CodecReader reader, Directory dir, Executor executor) throws IOException {
            if (this.r.nextBoolean()) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("NOTE: MockRandomMergePolicy now reverses reader=" + reader);
                }
                return MockRandomMergePolicy.reverse(reader);
            }
            if (executor != null && this.r.nextBoolean()) {
                Runnable dummyRunnable = () -> {};
                FutureTask<Object> task = new FutureTask<Object>(dummyRunnable, null);
                executor.execute(task);
                try {
                    task.get();
                }
                catch (InterruptedException e) {
                    throw new ThreadInterruptedException(e);
                }
                catch (ExecutionException e) {
                    throw IOUtils.rethrowAlways((Throwable)e.getCause());
                }
            }
            return null;
        }
    }
}

