/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.NamedMatches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;

public abstract class MatchesTestBase
extends LuceneTestCase {
    protected IndexSearcher searcher;
    protected Directory directory;
    protected IndexReader reader = null;
    protected static final String FIELD_WITH_OFFSETS = "field_offsets";
    protected static final String FIELD_NO_OFFSETS = "field_no_offsets";
    protected static final String FIELD_DOCS_ONLY = "field_docs_only";
    protected static final String FIELD_FREQS = "field_freqs";
    protected static final String FIELD_POINT = "field_point";
    private static final FieldType OFFSETS = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
    private static final FieldType DOCS;
    private static final FieldType DOCS_AND_FREQS;

    protected abstract String[] getDocuments();

    @Override
    public void tearDown() throws Exception {
        this.reader.close();
        this.directory.close();
        super.tearDown();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.directory = MatchesTestBase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(MatchesTestBase.random(), this.directory, MatchesTestBase.newIndexWriterConfig(new MockAnalyzer(MatchesTestBase.random())).setMergePolicy((MergePolicy)MatchesTestBase.newLogMergePolicy()));
        String[] docFields = this.getDocuments();
        for (int i = 0; i < docFields.length; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)MatchesTestBase.newField(FIELD_WITH_OFFSETS, docFields[i], OFFSETS));
            doc.add((IndexableField)MatchesTestBase.newField(FIELD_NO_OFFSETS, docFields[i], TextField.TYPE_STORED));
            doc.add((IndexableField)MatchesTestBase.newField(FIELD_DOCS_ONLY, docFields[i], DOCS));
            doc.add((IndexableField)MatchesTestBase.newField(FIELD_FREQS, docFields[i], DOCS_AND_FREQS));
            doc.add((IndexableField)new IntPoint(FIELD_POINT, new int[]{10}));
            doc.add((IndexableField)new NumericDocValuesField(FIELD_POINT, 10L));
            doc.add((IndexableField)new NumericDocValuesField("id", (long)i));
            doc.add((IndexableField)MatchesTestBase.newField("id", Integer.toString(i), TextField.TYPE_STORED));
            writer.addDocument(doc);
        }
        writer.forceMerge(1);
        this.reader = writer.getReader();
        writer.close();
        this.searcher = MatchesTestBase.newSearcher((IndexReader)MatchesTestBase.getOnlyLeafReader(this.reader));
    }

    protected void checkMatches(Query q, String field, int[][] expected) throws IOException {
        Weight w = this.searcher.createWeight(this.searcher.rewrite(q), ScoreMode.COMPLETE, 1.0f);
        for (int i = 0; i < expected.length; ++i) {
            int doc;
            LeafReaderContext ctx = (LeafReaderContext)this.searcher.leafContexts.get(ReaderUtil.subIndex((int)expected[i][0], (List)this.searcher.leafContexts));
            Matches matches = w.matches(ctx, doc = expected[i][0] - ctx.docBase);
            if (matches == null) {
                MatchesTestBase.assertEquals((long)expected[i].length, (long)1L);
                continue;
            }
            MatchesIterator it = matches.getMatches(field);
            if (expected[i].length == 1) {
                MatchesTestBase.assertNull((Object)it);
                continue;
            }
            this.checkFieldMatches(it, expected[i]);
            this.checkFieldMatches(matches.getMatches(field), expected[i]);
        }
    }

    protected void checkLabelCount(Query q, String field, int[] expected) throws IOException {
        Weight w = this.searcher.createWeight(this.searcher.rewrite(q), ScoreMode.COMPLETE, 1.0f);
        for (int i = 0; i < expected.length; ++i) {
            int doc;
            LeafReaderContext ctx = (LeafReaderContext)this.searcher.leafContexts.get(ReaderUtil.subIndex((int)i, (List)this.searcher.leafContexts));
            Matches matches = w.matches(ctx, doc = i - ctx.docBase);
            if (matches == null) {
                MatchesTestBase.assertEquals((String)("Expected to get matches on document " + i), (long)0L, (long)expected[i]);
                continue;
            }
            MatchesIterator it = matches.getMatches(field);
            if (expected[i] == 0) {
                MatchesTestBase.assertNull((Object)it);
                continue;
            }
            MatchesTestBase.assertNotNull((Object)it);
            IdentityHashMap<Query, Integer> labels = new IdentityHashMap<Query, Integer>();
            while (it.next()) {
                labels.put(it.getQuery(), 1);
            }
            MatchesTestBase.assertEquals((long)expected[i], (long)labels.size());
        }
    }

    protected void checkFieldMatches(MatchesIterator it, int[] expected) throws IOException {
        int pos = 1;
        while (it.next()) {
            MatchesTestBase.assertEquals((String)"Wrong start position", (long)expected[pos], (long)it.startPosition());
            MatchesTestBase.assertEquals((String)"Wrong end position", (long)expected[pos + 1], (long)it.endPosition());
            MatchesTestBase.assertEquals((String)"Wrong start offset", (long)expected[pos + 2], (long)it.startOffset());
            MatchesTestBase.assertEquals((String)"Wrong end offset", (long)expected[pos + 3], (long)it.endOffset());
            pos += 4;
        }
        MatchesTestBase.assertEquals((long)expected.length, (long)pos);
    }

    protected void checkNoPositionsMatches(Query q, String field, boolean[] expected) throws IOException {
        Weight w = this.searcher.createWeight(this.searcher.rewrite(q), ScoreMode.COMPLETE, 1.0f);
        for (int i = 0; i < expected.length; ++i) {
            LeafReaderContext ctx = (LeafReaderContext)this.searcher.leafContexts.get(ReaderUtil.subIndex((int)i, (List)this.searcher.leafContexts));
            int doc = i - ctx.docBase;
            Matches matches = w.matches(ctx, doc);
            if (expected[i]) {
                MatchesIterator mi = matches.getMatches(field);
                MatchesTestBase.assertTrue((boolean)mi.next());
                MatchesTestBase.assertEquals((long)-1L, (long)mi.startPosition());
                while (mi.next()) {
                    MatchesTestBase.assertEquals((long)-1L, (long)mi.startPosition());
                }
                continue;
            }
            MatchesTestBase.assertNull((Object)matches);
        }
    }

    protected void checkSubMatches(Query q, String[][] expectedNames) throws IOException {
        Weight w = this.searcher.createWeight(this.searcher.rewrite(q), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        for (int i = 0; i < expectedNames.length; ++i) {
            int doc;
            LeafReaderContext ctx = (LeafReaderContext)this.searcher.leafContexts.get(ReaderUtil.subIndex((int)i, (List)this.searcher.leafContexts));
            Matches matches = w.matches(ctx, doc = i - ctx.docBase);
            if (matches == null) {
                MatchesTestBase.assertEquals((String)("Expected to get no matches on document " + i), (long)0L, (long)expectedNames[i].length);
                continue;
            }
            HashSet<String> expectedQueries = new HashSet<String>(Arrays.asList(expectedNames[i]));
            Set actualQueries = NamedMatches.findNamedMatches((Matches)matches).stream().map(NamedMatches::getName).collect(Collectors.toSet());
            HashSet unexpected = new HashSet(actualQueries);
            unexpected.removeAll(expectedQueries);
            MatchesTestBase.assertEquals((String)("Unexpected matching leaf queries: " + unexpected), (long)0L, (long)unexpected.size());
            HashSet<String> missing = new HashSet<String>(expectedQueries);
            missing.removeAll(actualQueries);
            MatchesTestBase.assertEquals((String)("Missing matching leaf queries: " + missing), (long)0L, (long)missing.size());
        }
    }

    protected void assertIsLeafMatch(Query q, String field) throws IOException {
        Weight w = this.searcher.createWeight(this.searcher.rewrite(q), ScoreMode.COMPLETE, 1.0f);
        for (int i = 0; i < this.searcher.reader.maxDoc(); ++i) {
            int doc;
            LeafReaderContext ctx = (LeafReaderContext)this.searcher.leafContexts.get(ReaderUtil.subIndex((int)i, (List)this.searcher.leafContexts));
            Matches matches = w.matches(ctx, doc = i - ctx.docBase);
            if (matches == null) {
                return;
            }
            MatchesIterator mi = matches.getMatches(field);
            if (mi == null) {
                return;
            }
            while (mi.next()) {
                MatchesTestBase.assertNull((Object)mi.getSubMatches());
            }
        }
    }

    protected void checkTermMatches(Query q, String field, TermMatch[][][] expected) throws IOException {
        Weight w = this.searcher.createWeight(this.searcher.rewrite(q), ScoreMode.COMPLETE, 1.0f);
        for (int i = 0; i < expected.length; ++i) {
            int doc;
            LeafReaderContext ctx = (LeafReaderContext)this.searcher.leafContexts.get(ReaderUtil.subIndex((int)i, (List)this.searcher.leafContexts));
            Matches matches = w.matches(ctx, doc = i - ctx.docBase);
            if (matches == null) {
                MatchesTestBase.assertEquals((long)expected[i].length, (long)0L);
                continue;
            }
            MatchesIterator it = matches.getMatches(field);
            if (expected[i].length == 0) {
                MatchesTestBase.assertNull((Object)it);
                continue;
            }
            this.checkTerms(expected[i], it);
        }
    }

    private void checkTerms(TermMatch[][] expected, MatchesIterator it) throws IOException {
        int upTo = 0;
        while (it.next()) {
            HashSet<TermMatch> expectedMatches = new HashSet<TermMatch>(Arrays.asList(expected[upTo]));
            MatchesIterator submatches = it.getSubMatches();
            while (submatches.next()) {
                TermMatch tm = new TermMatch(submatches.startPosition(), submatches.startOffset(), submatches.endOffset());
                if (expectedMatches.remove(tm)) continue;
                MatchesTestBase.fail((String)("Unexpected term match: " + tm));
            }
            if (expectedMatches.size() != 0) {
                MatchesTestBase.fail((String)("Missing term matches: " + expectedMatches.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            ++upTo;
        }
        if (upTo < expected.length - 1) {
            MatchesTestBase.fail((String)"Missing expected match");
        }
    }

    static {
        OFFSETS.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        DOCS = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        DOCS.setIndexOptions(IndexOptions.DOCS);
        DOCS_AND_FREQS = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        DOCS_AND_FREQS.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
    }

    protected static class TermMatch {
        public final int position;
        public final int startOffset;
        public final int endOffset;

        public TermMatch(int position, int startOffset, int endOffset) {
            this.position = position;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TermMatch termMatch = (TermMatch)o;
            return this.position == termMatch.position && this.startOffset == termMatch.startOffset && this.endOffset == termMatch.endOffset;
        }

        public int hashCode() {
            return Objects.hash(this.position, this.startOffset, this.endOffset);
        }

        public String toString() {
            return this.position + "[" + this.startOffset + "->" + this.endOffset + "]";
        }
    }
}

