/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.TestUtil;

public class AssertingKnnVectorsFormat
extends KnnVectorsFormat {
    private final KnnVectorsFormat delegate = TestUtil.getDefaultKnnVectorsFormat();

    public AssertingKnnVectorsFormat() {
        super("Asserting");
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new AssertingKnnVectorsWriter(this.delegate.fieldsWriter(state));
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new AssertingKnnVectorsReader(this.delegate.fieldsReader(state));
    }

    static class AssertingKnnVectorsReader
    extends KnnVectorsReader {
        final KnnVectorsReader delegate;

        AssertingKnnVectorsReader(KnnVectorsReader delegate) {
            assert (delegate != null);
            this.delegate = delegate;
        }

        public void checkIntegrity() throws IOException {
            this.delegate.checkIntegrity();
        }

        public VectorValues getVectorValues(String field) throws IOException {
            VectorValues values = this.delegate.getVectorValues(field);
            if (values != null) {
                assert (values.docID() == -1);
                assert (values.size() >= 0);
                assert (values.dimension() > 0);
            }
            return values;
        }

        public TopDocs search(String field, float[] target, int k, Bits acceptDocs) throws IOException {
            TopDocs hits = this.delegate.search(field, target, k, acceptDocs);
            assert (hits != null);
            assert (hits.scoreDocs.length <= k);
            return hits;
        }

        public void close() throws IOException {
            this.delegate.close();
            this.delegate.close();
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }
    }

    static class AssertingKnnVectorsWriter
    extends KnnVectorsWriter {
        final KnnVectorsWriter delegate;

        AssertingKnnVectorsWriter(KnnVectorsWriter delegate) {
            assert (delegate != null);
            this.delegate = delegate;
        }

        public void writeField(FieldInfo fieldInfo, VectorValues values) throws IOException {
            assert (fieldInfo != null);
            assert (values != null);
            this.delegate.writeField(fieldInfo, values);
        }

        public void finish() throws IOException {
            this.delegate.finish();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

