/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.StoredFieldVisitor;

public class MismatchedLeafReader
extends FilterLeafReader {
    final FieldInfos shuffled;

    public MismatchedLeafReader(LeafReader in, Random random) {
        super(in);
        this.shuffled = MismatchedLeafReader.shuffleInfos(in.getFieldInfos(), random);
    }

    public FieldInfos getFieldInfos() {
        return this.shuffled;
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.in.document(docID, (StoredFieldVisitor)new MismatchedVisitor(visitor));
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    static FieldInfos shuffleInfos(FieldInfos infos, Random random) {
        ArrayList<FieldInfo> shuffled = new ArrayList<FieldInfo>();
        for (FieldInfo info : infos) {
            shuffled.add(info);
        }
        Collections.shuffle(shuffled, random);
        for (int i = 0; i < shuffled.size(); ++i) {
            FieldInfo oldInfo = (FieldInfo)shuffled.get(i);
            FieldInfo newInfo = new FieldInfo(oldInfo.name, i, oldInfo.hasVectors(), oldInfo.omitsNorms(), oldInfo.hasPayloads(), oldInfo.getIndexOptions(), oldInfo.getDocValuesType(), oldInfo.getDocValuesGen(), oldInfo.attributes(), oldInfo.getPointDimensionCount(), oldInfo.getPointIndexDimensionCount(), oldInfo.getPointNumBytes(), oldInfo.isSoftDeletesField());
            shuffled.set(i, newInfo);
        }
        return new FieldInfos(shuffled.toArray(new FieldInfo[shuffled.size()]));
    }

    class MismatchedVisitor
    extends StoredFieldVisitor {
        final StoredFieldVisitor in;

        MismatchedVisitor(StoredFieldVisitor in) {
            this.in = in;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.in.binaryField(this.renumber(fieldInfo), value);
        }

        public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.in.stringField(this.renumber(fieldInfo), value);
        }

        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.in.intField(this.renumber(fieldInfo), value);
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.in.longField(this.renumber(fieldInfo), value);
        }

        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.in.floatField(this.renumber(fieldInfo), value);
        }

        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.in.doubleField(this.renumber(fieldInfo), value);
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return this.in.needsField(this.renumber(fieldInfo));
        }

        FieldInfo renumber(FieldInfo original) {
            FieldInfo renumbered = MismatchedLeafReader.this.shuffled.fieldInfo(original.name);
            if (renumbered == null) {
                throw new AssertionError((Object)"stored fields sending bogus infos!");
            }
            return renumbered;
        }
    }
}

