/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeImpl;

public final class CannedTokenStream
extends TokenStream {
    private final Token[] tokens;
    private int upto = 0;
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final int finalOffset;
    private final int finalPosInc;

    public CannedTokenStream(Token ... tokens) {
        this(0, 0, tokens);
    }

    public CannedTokenStream(int finalPosInc, int finalOffset, Token ... tokens) {
        super(Token.TOKEN_ATTRIBUTE_FACTORY);
        this.tokens = tokens;
        this.finalOffset = finalOffset;
        this.finalPosInc = finalPosInc;
    }

    public void end() throws IOException {
        super.end();
        this.posIncrAtt.setPositionIncrement(this.finalPosInc);
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    public void reset() throws IOException {
        this.upto = 0;
        super.reset();
    }

    public boolean incrementToken() {
        if (this.upto < this.tokens.length) {
            this.clearAttributes();
            this.tokens[this.upto++].copyTo((AttributeImpl)((Token)this.offsetAtt));
            return true;
        }
        return false;
    }
}

