/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.generators.RandomBytes;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.CRC32;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.mockfile.ExtrasFS;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.junit.Assert;

public abstract class BaseDirectoryTestCase
extends LuceneTestCase {
    protected abstract Directory getDirectory(Path var1) throws IOException;

    public void testCopyFrom() throws Exception {
        Throwable throwable;
        BaseDirectoryWrapper dest;
        try (Object source = this.getDirectory(BaseDirectoryTestCase.createTempDir("testCopy"));){
            dest = BaseDirectoryTestCase.newDirectory();
            throwable = null;
            try {
                this.runCopyFrom((Directory)source, (Directory)dest);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dest != null) {
                    if (throwable != null) {
                        try {
                            dest.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dest.close();
                    }
                }
            }
        }
        source = BaseDirectoryTestCase.newDirectory();
        var2_2 = null;
        try {
            dest = this.getDirectory(BaseDirectoryTestCase.createTempDir("testCopyDestination"));
            throwable = null;
            try {
                this.runCopyFrom((Directory)source, (Directory)dest);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dest != null) {
                    if (throwable != null) {
                        try {
                            dest.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dest.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
        finally {
            if (source != null) {
                if (var2_2 != null) {
                    try {
                        source.close();
                    }
                    catch (Throwable throwable7) {
                        var2_2.addSuppressed(throwable7);
                    }
                } else {
                    source.close();
                }
            }
        }
    }

    private void runCopyFrom(Directory source, Directory dest) throws IOException {
        IndexOutput output = source.createOutput("foobar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
        byte[] bytes = RandomBytes.randomBytesOfLength((Random)BaseDirectoryTestCase.random(), (int)20000);
        output.writeBytes(bytes, bytes.length);
        output.close();
        dest.copyFrom(source, "foobar", "foobaz", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
        BaseDirectoryTestCase.assertTrue((boolean)BaseDirectoryTestCase.slowFileExists(dest, "foobaz"));
        IndexInput input = dest.openInput("foobaz", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
        byte[] bytes2 = new byte[bytes.length];
        input.readBytes(bytes2, 0, bytes2.length);
        input.close();
        BaseDirectoryTestCase.assertArrayEquals((byte[])bytes, (byte[])bytes2);
    }

    public void testRename() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testRename"));){
            IndexOutput output = dir.createOutput("foobar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int numBytes = BaseDirectoryTestCase.random().nextInt(20000);
            byte[] bytes = new byte[numBytes];
            BaseDirectoryTestCase.random().nextBytes(bytes);
            output.writeBytes(bytes, bytes.length);
            output.close();
            dir.rename("foobar", "foobaz");
            IndexInput input = dir.openInput("foobaz", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            byte[] bytes2 = new byte[numBytes];
            input.readBytes(bytes2, 0, bytes2.length);
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)numBytes);
            input.close();
            BaseDirectoryTestCase.assertArrayEquals((byte[])bytes, (byte[])bytes2);
        }
    }

    public void testDeleteFile() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testDeleteFile"));){
            String file = "foo.txt";
            Assert.assertFalse((boolean)Arrays.asList(dir.listAll()).contains(file));
            dir.createOutput("foo.txt", IOContext.DEFAULT).close();
            Assert.assertTrue((boolean)Arrays.asList(dir.listAll()).contains(file));
            dir.deleteFile("foo.txt");
            Assert.assertFalse((boolean)Arrays.asList(dir.listAll()).contains(file));
            BaseDirectoryTestCase.expectThrowsAnyOf(Arrays.asList(NoSuchFileException.class, FileNotFoundException.class), () -> dir.deleteFile("foo.txt"));
        }
    }

    public void testByte() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testByte"));){
            IndexOutput output = dir.createOutput("byte", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeByte((byte)-128);
            output.close();
            IndexInput input = dir.openInput("byte", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)1L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)-128L, (long)input.readByte());
            input.close();
        }
    }

    public void testShort() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testShort"));){
            IndexOutput output = dir.createOutput("short", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeShort((short)-20);
            output.close();
            IndexInput input = dir.openInput("short", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)2L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)-20L, (long)input.readShort());
            input.close();
        }
    }

    public void testInt() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testInt"));){
            IndexOutput output = dir.createOutput("int", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeInt(-500);
            output.close();
            IndexInput input = dir.openInput("int", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)4L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)-500L, (long)input.readInt());
            input.close();
        }
    }

    public void testLong() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testLong"));){
            IndexOutput output = dir.createOutput("long", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeLong(-5000L);
            output.close();
            IndexInput input = dir.openInput("long", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)8L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)-5000L, (long)input.readLong());
            input.close();
        }
    }

    public void testAlignedLittleEndianLongs() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testAlignedLittleEndianLongs"));){
            try (IndexOutput out = dir.createOutput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                out.writeLong(Long.reverseBytes(3L));
                out.writeLong(Long.reverseBytes(Long.MAX_VALUE));
                out.writeLong(Long.reverseBytes(-3L));
            }
            var4_6 = null;
            try (IndexInput input = dir.openInput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                BaseDirectoryTestCase.assertEquals((long)24L, (long)input.length());
                long[] l = new long[4];
                input.readLELongs(l, 1, 3);
                BaseDirectoryTestCase.assertArrayEquals((long[])new long[]{0L, 3L, Long.MAX_VALUE, -3L}, (long[])l);
                BaseDirectoryTestCase.assertEquals((long)24L, (long)input.getFilePointer());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
        }
    }

    public void testUnalignedLittleEndianLongs() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testUnalignedLittleEndianLongs"));){
            try (IndexOutput out = dir.createOutput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                out.writeByte((byte)2);
                out.writeLong(Long.reverseBytes(3L));
                out.writeLong(Long.reverseBytes(Long.MAX_VALUE));
                out.writeLong(Long.reverseBytes(-3L));
            }
            var4_6 = null;
            try (IndexInput input = dir.openInput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                BaseDirectoryTestCase.assertEquals((long)25L, (long)input.length());
                BaseDirectoryTestCase.assertEquals((long)2L, (long)input.readByte());
                long[] l = new long[4];
                input.readLELongs(l, 1, 3);
                BaseDirectoryTestCase.assertArrayEquals((long[])new long[]{0L, 3L, Long.MAX_VALUE, -3L}, (long[])l);
                BaseDirectoryTestCase.assertEquals((long)25L, (long)input.getFilePointer());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
        }
    }

    public void testLittleEndianLongsUnderflow() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testLittleEndianLongsUnderflow"));){
            int offset = BaseDirectoryTestCase.random().nextInt(8);
            int length = TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 16);
            try (IndexOutput out = dir.createOutput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                byte[] b = new byte[offset + length * 8 - TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 8)];
                BaseDirectoryTestCase.random().nextBytes(b);
                out.writeBytes(b, b.length);
            }
            var6_8 = null;
            try (IndexInput input = dir.openInput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                input.seek((long)offset);
                BaseDirectoryTestCase.expectThrows(EOFException.class, () -> input.readLELongs(new long[length], 0, length));
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
        }
    }

    public void testString() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testString"));){
            IndexOutput output = dir.createOutput("string", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeString("hello!");
            output.close();
            IndexInput input = dir.openInput("string", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((Object)"hello!", (Object)input.readString());
            BaseDirectoryTestCase.assertEquals((long)7L, (long)input.length());
            input.close();
        }
    }

    public void testVInt() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testVInt"));){
            IndexOutput output = dir.createOutput("vint", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeVInt(500);
            output.close();
            IndexInput input = dir.openInput("vint", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)2L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)500L, (long)input.readVInt());
            input.close();
        }
    }

    public void testVLong() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testVLong"));){
            IndexOutput output = dir.createOutput("vlong", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeVLong(Long.MAX_VALUE);
            output.close();
            IndexInput input = dir.openInput("vlong", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)9L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)Long.MAX_VALUE, (long)input.readVLong());
            input.close();
        }
    }

    public void testZInt() throws Exception {
        int[] ints = new int[BaseDirectoryTestCase.random().nextInt(10)];
        block14: for (int i = 0; i < ints.length; ++i) {
            switch (BaseDirectoryTestCase.random().nextInt(3)) {
                case 0: {
                    ints[i] = BaseDirectoryTestCase.random().nextInt();
                    continue block14;
                }
                case 1: {
                    ints[i] = BaseDirectoryTestCase.random().nextBoolean() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    continue block14;
                }
                case 2: {
                    ints[i] = (BaseDirectoryTestCase.random().nextBoolean() ? -1 : 1) * BaseDirectoryTestCase.random().nextInt(1024);
                    continue block14;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testZInt"));){
            IndexOutput output = dir.createOutput("zint", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            for (int i : ints) {
                output.writeZInt(i);
            }
            output.close();
            IndexInput input = dir.openInput("zint", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            for (int i : ints) {
                BaseDirectoryTestCase.assertEquals((long)i, (long)input.readZInt());
            }
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)input.getFilePointer());
            input.close();
        }
    }

    public void testZLong() throws Exception {
        long[] longs = new long[BaseDirectoryTestCase.random().nextInt(10)];
        block14: for (int i = 0; i < longs.length; ++i) {
            switch (BaseDirectoryTestCase.random().nextInt(3)) {
                case 0: {
                    longs[i] = BaseDirectoryTestCase.random().nextLong();
                    continue block14;
                }
                case 1: {
                    longs[i] = BaseDirectoryTestCase.random().nextBoolean() ? Long.MIN_VALUE : Long.MAX_VALUE;
                    continue block14;
                }
                case 2: {
                    longs[i] = (BaseDirectoryTestCase.random().nextBoolean() ? -1 : 1) * BaseDirectoryTestCase.random().nextInt(1024);
                    continue block14;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testZLong"));){
            IndexOutput output = dir.createOutput("zlong", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            for (long l : longs) {
                output.writeZLong(l);
            }
            output.close();
            IndexInput input = dir.openInput("zlong", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            for (long l : longs) {
                BaseDirectoryTestCase.assertEquals((long)l, (long)input.readZLong());
            }
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)input.getFilePointer());
            input.close();
        }
    }

    public void testSetOfStrings() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testSetOfStrings"));){
            IndexOutput output = dir.createOutput("stringset", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeSetOfStrings(BaseDirectoryTestCase.asSet("test1", "test2"));
            output.writeSetOfStrings(Collections.emptySet());
            output.writeSetOfStrings(BaseDirectoryTestCase.asSet("test3"));
            output.close();
            IndexInput input = dir.openInput("stringset", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            Set set1 = input.readSetOfStrings();
            BaseDirectoryTestCase.assertEquals(BaseDirectoryTestCase.asSet("test1", "test2"), (Object)set1);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> set1.add("bogus"));
            Set set2 = input.readSetOfStrings();
            BaseDirectoryTestCase.assertEquals(Collections.emptySet(), (Object)set2);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> set2.add("bogus"));
            Set set3 = input.readSetOfStrings();
            BaseDirectoryTestCase.assertEquals(Collections.singleton("test3"), (Object)set3);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> set3.add("bogus"));
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)input.getFilePointer());
            input.close();
        }
    }

    public void testMapOfStrings() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("test1", "value1");
        m.put("test2", "value2");
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testMapOfStrings"));){
            IndexOutput output = dir.createOutput("stringmap", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeMapOfStrings(m);
            output.writeMapOfStrings(Collections.emptyMap());
            output.writeMapOfStrings(Collections.singletonMap("key", "value"));
            output.close();
            IndexInput input = dir.openInput("stringmap", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            Map map1 = input.readMapOfStrings();
            BaseDirectoryTestCase.assertEquals(m, (Object)map1);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> map1.put("bogus1", "bogus2"));
            Map map2 = input.readMapOfStrings();
            BaseDirectoryTestCase.assertEquals(Collections.emptyMap(), (Object)map2);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> map2.put("bogus1", "bogus2"));
            Map map3 = input.readMapOfStrings();
            BaseDirectoryTestCase.assertEquals(Collections.singletonMap("key", "value"), (Object)map3);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> map3.put("bogus1", "bogus2"));
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)input.getFilePointer());
            input.close();
        }
    }

    public void testChecksum() throws Exception {
        CRC32 expected = new CRC32();
        int numBytes = BaseDirectoryTestCase.random().nextInt(20000);
        byte[] bytes = new byte[numBytes];
        BaseDirectoryTestCase.random().nextBytes(bytes);
        expected.update(bytes);
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testChecksum"));){
            IndexOutput output = dir.createOutput("checksum", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeBytes(bytes, 0, bytes.length);
            output.close();
            ChecksumIndexInput input = dir.openChecksumInput("checksum", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            input.skipBytes((long)numBytes);
            BaseDirectoryTestCase.assertEquals((long)expected.getValue(), (long)input.getChecksum());
            input.close();
        }
    }

    public void testDetectClose() throws Throwable {
        Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testDetectClose"));
        dir.close();
        BaseDirectoryTestCase.expectThrows(AlreadyClosedException.class, () -> dir.createOutput("test", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random())));
    }

    public void testThreadSafetyInListAll() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testThreadSafety"));){
            if (dir instanceof BaseDirectoryWrapper) {
                ((BaseDirectoryWrapper)dir).setCheckIndexOnClose(false);
            }
            if (dir instanceof MockDirectoryWrapper) {
                ((MockDirectoryWrapper)dir).setThrottling(MockDirectoryWrapper.Throttling.NEVER);
            }
            AtomicBoolean stop = new AtomicBoolean();
            Thread writer = new Thread(() -> {
                try {
                    Random rnd = new Random(RandomizedTest.randomLong() + 1L);
                    int max = RandomizedTest.randomIntBetween((int)500, (int)1000);
                    for (int i = 0; i < max; ++i) {
                        String fileName = "file-" + i;
                        try (IndexOutput output = dir.createOutput(fileName, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                            Thread.yield();
                        }
                        BaseDirectoryTestCase.assertTrue((boolean)BaseDirectoryTestCase.slowFileExists(dir, fileName));
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    stop.set(true);
                }
            });
            Thread reader = new Thread(() -> {
                try {
                    Random rnd = new Random(RandomizedTest.randomLong());
                    while (!stop.get()) {
                        Object[] files = (String[])Arrays.stream(dir.listAll()).filter(name -> !ExtrasFS.isExtra(name)).toArray(String[]::new);
                        if (files.length <= 0) continue;
                        do {
                            String file = (String)RandomPicks.randomFrom((Random)rnd, (Object[])files);
                            try {
                                IndexInput input = dir.openInput(file, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                                Throwable throwable = null;
                                if (input == null) continue;
                                if (throwable != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    continue;
                                }
                                input.close();
                            }
                            catch (AccessDeniedException input) {
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException("Something went wrong when opening: " + file, e);
                            }
                        } while (rnd.nextInt(3) != 0);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            reader.start();
            writer.start();
            writer.join();
            reader.join();
        }
    }

    public void testFileExistsInListAfterCreated() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testFileExistsInListAfterCreated"));){
            String name = "file";
            dir.createOutput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random())).close();
            BaseDirectoryTestCase.assertTrue((boolean)BaseDirectoryTestCase.slowFileExists(dir, name));
            BaseDirectoryTestCase.assertTrue((boolean)Arrays.asList(dir.listAll()).contains(name));
        }
    }

    public void testSeekToEOFThenBack() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testSeekToEOFThenBack"));){
            int bufferLength = 1024;
            IndexOutput o = dir.createOutput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            byte[] bytes = new byte[3 * bufferLength];
            o.writeBytes(bytes, 0, bytes.length);
            o.close();
            IndexInput i = dir.openInput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            i.seek((long)(2 * bufferLength - 1));
            i.seek((long)(3 * bufferLength));
            i.seek((long)bufferLength);
            i.readBytes(bytes, 0, 2 * bufferLength);
            i.close();
        }
    }

    public void testIllegalEOF() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testIllegalEOF"));){
            IndexOutput o = dir.createOutput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            byte[] b = new byte[1024];
            o.writeBytes(b, 0, 1024);
            o.close();
            IndexInput i = dir.openInput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            i.seek(1024L);
            i.close();
        }
    }

    public void testSeekPastEOF() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testSeekPastEOF"));){
            IndexOutput o = dir.createOutput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int len = BaseDirectoryTestCase.random().nextInt(2048);
            byte[] b = new byte[len];
            o.writeBytes(b, 0, len);
            o.close();
            IndexInput i = dir.openInput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.expectThrows(EOFException.class, () -> i.seek((long)(len + RandomizedTest.randomIntBetween((int)1, (int)2048))));
            i.seek((long)len);
            BaseDirectoryTestCase.expectThrows(EOFException.class, () -> ((IndexInput)i).readByte());
            BaseDirectoryTestCase.expectThrows(EOFException.class, () -> i.readBytes(new byte[1], 0, 1));
            i.close();
        }
    }

    public void testSliceOutOfBounds() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testSliceOutOfBounds"));){
            IndexOutput o = dir.createOutput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int len = BaseDirectoryTestCase.random().nextInt(2040) + 8;
            byte[] b = new byte[len];
            o.writeBytes(b, 0, len);
            o.close();
            IndexInput i = dir.openInput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.expectThrows(IllegalArgumentException.class, () -> i.slice("slice1", 0L, (long)(len + 1)));
            BaseDirectoryTestCase.expectThrows(IllegalArgumentException.class, () -> i.slice("slice2", -1L, (long)len));
            IndexInput slice = i.slice("slice3", 4L, (long)(len / 2));
            BaseDirectoryTestCase.expectThrows(IllegalArgumentException.class, () -> slice.slice("slice3sub", 1L, (long)(len / 2)));
            i.close();
        }
    }

    public void testNoDir() throws Throwable {
        Path tempDir = BaseDirectoryTestCase.createTempDir("doesnotexist");
        IOUtils.rm((Path[])new Path[]{tempDir});
        try (Directory dir = this.getDirectory(tempDir);){
            BaseDirectoryTestCase.expectThrowsAnyOf(Arrays.asList(NoSuchFileException.class, IndexNotFoundException.class), () -> DirectoryReader.open((Directory)dir));
        }
    }

    public void testCopyBytes() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testCopyBytes"));){
            int upto;
            IndexOutput out = dir.createOutput("test", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            byte[] bytes = new byte[TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 77777)];
            int size = TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 1777777);
            int byteUpto = 0;
            for (upto = 0; upto < size; ++upto) {
                bytes[byteUpto++] = BaseDirectoryTestCase.value(upto);
                if (byteUpto != bytes.length) continue;
                out.writeBytes(bytes, 0, bytes.length);
                byteUpto = 0;
            }
            out.writeBytes(bytes, 0, byteUpto);
            BaseDirectoryTestCase.assertEquals((long)size, (long)out.getFilePointer());
            out.close();
            BaseDirectoryTestCase.assertEquals((long)size, (long)dir.fileLength("test"));
            IndexInput in = dir.openInput("test", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            out = dir.createOutput("test2", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            upto = 0;
            while (upto < size) {
                if (BaseDirectoryTestCase.random().nextBoolean()) {
                    out.writeByte(in.readByte());
                    ++upto;
                    continue;
                }
                int chunk = Math.min(TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, bytes.length), size - upto);
                out.copyBytes((DataInput)in, (long)chunk);
                upto += chunk;
            }
            BaseDirectoryTestCase.assertEquals((long)size, (long)upto);
            out.close();
            in.close();
            IndexInput in2 = dir.openInput("test2", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            upto = 0;
            while (upto < size) {
                if (BaseDirectoryTestCase.random().nextBoolean()) {
                    byte v = in2.readByte();
                    BaseDirectoryTestCase.assertEquals((long)BaseDirectoryTestCase.value(upto), (long)v);
                    ++upto;
                    continue;
                }
                int limit = Math.min(TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, bytes.length), size - upto);
                in2.readBytes(bytes, 0, limit);
                for (int byteIdx = 0; byteIdx < limit; ++byteIdx) {
                    BaseDirectoryTestCase.assertEquals((long)BaseDirectoryTestCase.value(upto), (long)bytes[byteIdx]);
                    ++upto;
                }
            }
            in2.close();
            dir.deleteFile("test");
            dir.deleteFile("test2");
        }
    }

    private static byte value(int idx) {
        return (byte)(idx % 256 * (1 + idx / 256));
    }

    public void testCopyBytesWithThreads() throws Exception {
        try (Directory d = this.getDirectory(BaseDirectoryTestCase.createTempDir("testCopyBytesWithThreads"));){
            Thread[] copies;
            byte[] data = RandomBytes.randomBytesOfLengthBetween((Random)BaseDirectoryTestCase.random(), (int)101, (int)10000);
            IndexOutput output = d.createOutput("data", IOContext.DEFAULT);
            output.writeBytes(data, 0, data.length);
            output.close();
            IndexInput input = d.openInput("data", IOContext.DEFAULT);
            IndexOutput outputHeader = d.createOutput("header", IOContext.DEFAULT);
            outputHeader.copyBytes((DataInput)input, 100L);
            outputHeader.close();
            int threads = 10;
            CyclicBarrier start = new CyclicBarrier(threads);
            for (Thread t : copies = (Thread[])IntStream.range(0, threads).mapToObj(i -> {
                IndexInput src = input.clone();
                Thread t = new Thread(() -> {
                    try {
                        start.await();
                        IndexOutput dst = d.createOutput("copy" + i, IOContext.DEFAULT);
                        dst.copyBytes((DataInput)src, src.length() - 100L);
                        dst.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                t.start();
                return t;
            }).toArray(Thread[]::new)) {
                t.join();
            }
            for (int i2 = 0; i2 < threads; ++i2) {
                try (IndexInput copiedData = d.openInput("copy" + i2, IOContext.DEFAULT);){
                    byte[] dataCopy = new byte[data.length];
                    System.arraycopy(data, 0, dataCopy, 0, 100);
                    copiedData.readBytes(dataCopy, 100, data.length - 100);
                    BaseDirectoryTestCase.assertArrayEquals((byte[])data, (byte[])dataCopy);
                    continue;
                }
            }
            input.close();
        }
    }

    public void testFsyncDoesntCreateNewFiles() throws Exception {
        Path path = BaseDirectoryTestCase.createTempDir("nocreate");
        try (Directory fsdir = this.getDirectory(path);){
            if (!(fsdir instanceof FSDirectory)) {
                BaseDirectoryTestCase.assumeTrue("test only works for FSDirectory subclasses", false);
                return;
            }
            IndexOutput out = fsdir.createOutput("afile", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            out.writeString("boo");
            out.close();
            Files.delete(path.resolve("afile"));
            int fileCount = fsdir.listAll().length;
            BaseDirectoryTestCase.expectThrowsAnyOf(Arrays.asList(FileNotFoundException.class, NoSuchFileException.class), () -> fsdir.sync(Collections.singleton("afile")));
            BaseDirectoryTestCase.assertEquals((long)fileCount, (long)fsdir.listAll().length);
        }
    }

    public void testRandomLong() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testLongs"));){
            int i;
            IndexOutput output = dir.createOutput("longs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int num = TestUtil.nextInt(BaseDirectoryTestCase.random(), 50, 3000);
            long[] longs = new long[num];
            for (int i2 = 0; i2 < longs.length; ++i2) {
                longs[i2] = TestUtil.nextLong(BaseDirectoryTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE);
                output.writeLong(longs[i2]);
            }
            output.close();
            IndexInput input = dir.openInput("longs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            RandomAccessInput slice = input.randomAccessSlice(0L, input.length());
            for (i = 0; i < longs.length; ++i) {
                BaseDirectoryTestCase.assertEquals((long)longs[i], (long)slice.readLong((long)(i * 8)));
            }
            for (i = 1; i < longs.length; ++i) {
                long offset = i * 8;
                RandomAccessInput subslice = input.randomAccessSlice(offset, input.length() - offset);
                for (int j = i; j < longs.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)longs[j], (long)subslice.readLong((long)((j - i) * 8)));
                }
            }
            for (i = 0; i < 7; ++i) {
                String name = "longs-" + i;
                IndexOutput o = dir.createOutput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                byte[] junk = new byte[i];
                BaseDirectoryTestCase.random().nextBytes(junk);
                o.writeBytes(junk, junk.length);
                input.seek(0L);
                o.copyBytes((DataInput)input, input.length());
                o.close();
                IndexInput padded = dir.openInput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                RandomAccessInput whole = padded.randomAccessSlice((long)i, padded.length() - (long)i);
                for (int j = 0; j < longs.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)longs[j], (long)whole.readLong((long)(j * 8)));
                }
                padded.close();
            }
            input.close();
        }
    }

    public void testRandomInt() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testInts"));){
            int i;
            IndexOutput output = dir.createOutput("ints", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int num = TestUtil.nextInt(BaseDirectoryTestCase.random(), 50, 3000);
            int[] ints = new int[num];
            for (int i2 = 0; i2 < ints.length; ++i2) {
                ints[i2] = BaseDirectoryTestCase.random().nextInt();
                output.writeInt(ints[i2]);
            }
            output.close();
            IndexInput input = dir.openInput("ints", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            RandomAccessInput slice = input.randomAccessSlice(0L, input.length());
            for (i = 0; i < ints.length; ++i) {
                BaseDirectoryTestCase.assertEquals((long)ints[i], (long)slice.readInt((long)(i * 4)));
            }
            for (i = 1; i < ints.length; ++i) {
                long offset = i * 4;
                RandomAccessInput subslice = input.randomAccessSlice(offset, input.length() - offset);
                for (int j = i; j < ints.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)ints[j], (long)subslice.readInt((long)((j - i) * 4)));
                }
            }
            for (i = 0; i < 7; ++i) {
                String name = "ints-" + i;
                IndexOutput o = dir.createOutput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                byte[] junk = new byte[i];
                BaseDirectoryTestCase.random().nextBytes(junk);
                o.writeBytes(junk, junk.length);
                input.seek(0L);
                o.copyBytes((DataInput)input, input.length());
                o.close();
                IndexInput padded = dir.openInput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                RandomAccessInput whole = padded.randomAccessSlice((long)i, padded.length() - (long)i);
                for (int j = 0; j < ints.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)ints[j], (long)whole.readInt((long)(j * 4)));
                }
                padded.close();
            }
            input.close();
        }
    }

    public void testRandomShort() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testShorts"));){
            int i;
            IndexOutput output = dir.createOutput("shorts", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int num = TestUtil.nextInt(BaseDirectoryTestCase.random(), 50, 3000);
            short[] shorts = new short[num];
            for (int i2 = 0; i2 < shorts.length; ++i2) {
                shorts[i2] = (short)BaseDirectoryTestCase.random().nextInt();
                output.writeShort(shorts[i2]);
            }
            output.close();
            IndexInput input = dir.openInput("shorts", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            RandomAccessInput slice = input.randomAccessSlice(0L, input.length());
            for (i = 0; i < shorts.length; ++i) {
                BaseDirectoryTestCase.assertEquals((long)shorts[i], (long)slice.readShort((long)(i * 2)));
            }
            for (i = 1; i < shorts.length; ++i) {
                long offset = i * 2;
                RandomAccessInput subslice = input.randomAccessSlice(offset, input.length() - offset);
                for (int j = i; j < shorts.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)shorts[j], (long)subslice.readShort((long)((j - i) * 2)));
                }
            }
            for (i = 0; i < 7; ++i) {
                String name = "shorts-" + i;
                IndexOutput o = dir.createOutput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                byte[] junk = new byte[i];
                BaseDirectoryTestCase.random().nextBytes(junk);
                o.writeBytes(junk, junk.length);
                input.seek(0L);
                o.copyBytes((DataInput)input, input.length());
                o.close();
                IndexInput padded = dir.openInput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                RandomAccessInput whole = padded.randomAccessSlice((long)i, padded.length() - (long)i);
                for (int j = 0; j < shorts.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)shorts[j], (long)whole.readShort((long)(j * 2)));
                }
                padded.close();
            }
            input.close();
        }
    }

    public void testRandomByte() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testBytes"));){
            int i;
            IndexOutput output = dir.createOutput("bytes", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int num = TestUtil.nextInt(BaseDirectoryTestCase.random(), 50, 3000);
            byte[] bytes = new byte[num];
            BaseDirectoryTestCase.random().nextBytes(bytes);
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                output.writeByte(bytes[i2]);
            }
            output.close();
            IndexInput input = dir.openInput("bytes", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            RandomAccessInput slice = input.randomAccessSlice(0L, input.length());
            for (i = 0; i < bytes.length; ++i) {
                BaseDirectoryTestCase.assertEquals((long)bytes[i], (long)slice.readByte((long)i));
            }
            for (i = 1; i < bytes.length; ++i) {
                long offset = i;
                RandomAccessInput subslice = input.randomAccessSlice(offset, input.length() - offset);
                for (int j = i; j < bytes.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)bytes[j], (long)subslice.readByte((long)(j - i)));
                }
            }
            for (i = 0; i < 7; ++i) {
                String name = "bytes-" + i;
                IndexOutput o = dir.createOutput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                byte[] junk = new byte[i];
                BaseDirectoryTestCase.random().nextBytes(junk);
                o.writeBytes(junk, junk.length);
                input.seek(0L);
                o.copyBytes((DataInput)input, input.length());
                o.close();
                IndexInput padded = dir.openInput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                RandomAccessInput whole = padded.randomAccessSlice((long)i, padded.length() - (long)i);
                for (int j = 0; j < bytes.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)bytes[j], (long)whole.readByte((long)j));
                }
                padded.close();
            }
            input.close();
        }
    }

    public void testSliceOfSlice() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("sliceOfSlice"));){
            IndexOutput output = dir.createOutput("bytes", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int num = TEST_NIGHTLY ? TestUtil.nextInt(BaseDirectoryTestCase.random(), 250, 2500) : TestUtil.nextInt(BaseDirectoryTestCase.random(), 50, 250);
            byte[] bytes = new byte[num];
            BaseDirectoryTestCase.random().nextBytes(bytes);
            for (int i = 0; i < bytes.length; ++i) {
                output.writeByte(bytes[i]);
            }
            output.close();
            IndexInput input = dir.openInput("bytes", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            input.seek(TestUtil.nextLong(BaseDirectoryTestCase.random(), 0L, input.length()));
            for (int i = 0; i < num; i += 16) {
                IndexInput slice1 = input.slice("slice1", (long)i, (long)(num - i));
                BaseDirectoryTestCase.assertEquals((long)0L, (long)slice1.getFilePointer());
                BaseDirectoryTestCase.assertEquals((long)(num - i), (long)slice1.length());
                slice1.seek(TestUtil.nextLong(BaseDirectoryTestCase.random(), 0L, slice1.length()));
                int j = 0;
                while ((long)j < slice1.length()) {
                    IndexInput slice2 = slice1.slice("slice2", (long)j, (long)(num - i - j));
                    BaseDirectoryTestCase.assertEquals((long)0L, (long)slice2.getFilePointer());
                    BaseDirectoryTestCase.assertEquals((long)(num - i - j), (long)slice2.length());
                    byte[] data = new byte[num];
                    System.arraycopy(bytes, 0, data, 0, i + j);
                    if (BaseDirectoryTestCase.random().nextBoolean()) {
                        slice2.readBytes(data, i + j, num - i - j);
                    } else {
                        long seek = TestUtil.nextLong(BaseDirectoryTestCase.random(), 0L, slice2.length());
                        slice2.seek(seek);
                        slice2.readBytes(data, (int)((long)(i + j) + seek), (int)((long)(num - i - j) - seek));
                        slice2.seek(0L);
                        slice2.readBytes(data, i + j, (int)seek);
                    }
                    BaseDirectoryTestCase.assertArrayEquals((byte[])bytes, (byte[])data);
                    j += 16;
                }
            }
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLargeWrites() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("largeWrites"));){
            IndexOutput os = dir.createOutput("testBufferStart.txt", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            byte[] largeBuf = new byte[2048];
            BaseDirectoryTestCase.random().nextBytes(largeBuf);
            long currentPos = os.getFilePointer();
            os.writeBytes(largeBuf, largeBuf.length);
            try {
                BaseDirectoryTestCase.assertEquals((long)(currentPos + (long)largeBuf.length), (long)os.getFilePointer());
            }
            finally {
                os.close();
            }
        }
    }

    public void testIndexOutputToString() throws Throwable {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            IndexOutput out = dir.createOutput("camelCase.txt", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertTrue((String)out.toString(), (boolean)out.toString().contains("camelCase.txt"));
            out.close();
        }
    }

    public void testDoubleCloseOutput() throws Throwable {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            IndexOutput out = dir.createOutput("foobar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            out.writeString("testing");
            out.close();
            out.close();
        }
    }

    public void testDoubleCloseInput() throws Throwable {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            IndexOutput out = dir.createOutput("foobar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            out.writeString("testing");
            out.close();
            IndexInput in = dir.openInput("foobar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((Object)"testing", (Object)in.readString());
            in.close();
            in.close();
        }
    }

    public void testCreateTempOutput() throws Throwable {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            int iter;
            ArrayList<String> names = new ArrayList<String>();
            int iters = BaseDirectoryTestCase.atLeast(50);
            for (iter = 0; iter < iters; ++iter) {
                IndexOutput out = dir.createTempOutput("foo", "bar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                names.add(out.getName());
                out.writeVInt(iter);
                out.close();
            }
            for (iter = 0; iter < iters; ++iter) {
                IndexInput in = dir.openInput((String)names.get(iter), BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                BaseDirectoryTestCase.assertEquals((long)iter, (long)in.readVInt());
                in.close();
            }
            Set files = Arrays.stream(dir.listAll()).filter(file -> !ExtrasFS.isExtra(file)).collect(Collectors.toSet());
            BaseDirectoryTestCase.assertEquals(new HashSet(names), files);
        }
    }

    public void testCreateOutputForExistingFile() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            String name = "file";
            IndexOutput out = dir.createOutput(name, IOContext.DEFAULT);
            Throwable throwable = null;
            if (out != null) {
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    out.close();
                }
            }
            BaseDirectoryTestCase.expectThrows(FileAlreadyExistsException.class, () -> {
                IndexOutput out = dir.createOutput(name, IOContext.DEFAULT);
                Throwable throwable = null;
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        out.close();
                    }
                }
            });
            dir.deleteFile(name);
            dir.createOutput(name, IOContext.DEFAULT).close();
        }
    }

    public void testSeekToEndOfFile() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            try (IndexOutput out = dir.createOutput("a", IOContext.DEFAULT);){
                for (int i = 0; i < 1024; ++i) {
                    out.writeByte((byte)0);
                }
            }
            var4_6 = null;
            try (IndexInput in = dir.openInput("a", IOContext.DEFAULT);){
                in.seek(100L);
                BaseDirectoryTestCase.assertEquals((long)100L, (long)in.getFilePointer());
                in.seek(1024L);
                BaseDirectoryTestCase.assertEquals((long)1024L, (long)in.getFilePointer());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
        }
    }

    public void testSeekBeyondEndOfFile() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            try (IndexOutput out = dir.createOutput("a", IOContext.DEFAULT);){
                for (int i = 0; i < 1024; ++i) {
                    out.writeByte((byte)0);
                }
            }
            var4_6 = null;
            try (IndexInput in = dir.openInput("a", IOContext.DEFAULT);){
                in.seek(100L);
                BaseDirectoryTestCase.assertEquals((long)100L, (long)in.getFilePointer());
                BaseDirectoryTestCase.expectThrows(EOFException.class, () -> in.seek(1025L));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
        }
    }

    public void testPendingDeletions() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.addVirusChecker(BaseDirectoryTestCase.createTempDir()));){
            String candidate;
            BaseDirectoryTestCase.assumeTrue("we can only install VirusCheckingFS on an FSDirectory", dir instanceof FSDirectory);
            FSDirectory fsDir = (FSDirectory)dir;
            do {
                candidate = IndexFileNames.segmentFileName((String)TestUtil.randomSimpleString(BaseDirectoryTestCase.random(), 1, 6), (String)TestUtil.randomSimpleString(BaseDirectoryTestCase.random()), (String)"test");
                try (IndexOutput out = dir.createOutput(candidate, IOContext.DEFAULT);){
                    out.getFilePointer();
                }
                fsDir.deleteFile(candidate);
            } while (fsDir.getPendingDeletions().size() <= 0);
            String fileName = candidate;
            BaseDirectoryTestCase.assertFalse((boolean)Arrays.asList(fsDir.listAll()).contains(fileName));
            BaseDirectoryTestCase.expectThrows(NoSuchFileException.class, () -> fsDir.fileLength(fileName));
            BaseDirectoryTestCase.expectThrows(NoSuchFileException.class, () -> fsDir.rename(fileName, "file2"));
            BaseDirectoryTestCase.expectThrows(NoSuchFileException.class, () -> fsDir.deleteFile(fileName));
            BaseDirectoryTestCase.expectThrows(NoSuchFileException.class, () -> fsDir.openInput(fileName, IOContext.DEFAULT));
        }
    }

    public void testListAllIsSorted() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            int count = BaseDirectoryTestCase.atLeast(20);
            HashSet<String> names = new HashSet<String>();
            while (names.size() < count) {
                IndexOutput out;
                String name = IndexFileNames.segmentFileName((String)TestUtil.randomSimpleString(BaseDirectoryTestCase.random(), 1, 6), (String)TestUtil.randomSimpleString(BaseDirectoryTestCase.random()), (String)"test");
                if (BaseDirectoryTestCase.random().nextInt(5) == 1) {
                    out = dir.createTempOutput(name, "foo", IOContext.DEFAULT);
                    names.add(out.getName());
                    out.close();
                    continue;
                }
                if (names.contains(name)) continue;
                out = dir.createOutput(name, IOContext.DEFAULT);
                names.add(out.getName());
                out.close();
            }
            Object[] actual = dir.listAll();
            Object[] expected = (String[])actual.clone();
            Arrays.sort(expected);
            BaseDirectoryTestCase.assertArrayEquals((Object[])expected, (Object[])actual);
        }
    }
}

