/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.BinaryPoint;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FutureArrays;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.Rethrow;
import org.apache.lucene.util.TestUtil;
import org.junit.Assert;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BasePointsFormatTestCase
extends BaseIndexFileFormatTestCase {
    @Override
    protected void addRandomFields(Document doc) {
        int numValues = BasePointsFormatTestCase.random().nextInt(3);
        for (int i = 0; i < numValues; ++i) {
            doc.add((IndexableField)new IntPoint("f", new int[]{BasePointsFormatTestCase.random().nextInt()}));
        }
    }

    public void testBasic() throws Exception {
        Directory dir = this.getDirectory(20);
        IndexWriterConfig iwc = BasePointsFormatTestCase.newIndexWriterConfig();
        iwc.setMergePolicy((MergePolicy)BasePointsFormatTestCase.newLogMergePolicy());
        IndexWriter w = new IndexWriter(dir, iwc);
        byte[] point = new byte[4];
        for (int i = 0; i < 20; ++i) {
            Document doc = new Document();
            NumericUtils.intToSortableBytes((int)i, (byte[])point, (int)0);
            doc.add((IndexableField)new BinaryPoint("dim", (byte[][])new byte[][]{point}));
            w.addDocument((Iterable)doc);
        }
        w.forceMerge(1);
        w.close();
        DirectoryReader r = DirectoryReader.open((Directory)dir);
        LeafReader sub = BasePointsFormatTestCase.getOnlyLeafReader((IndexReader)r);
        PointValues values = sub.getPointValues("dim");
        final BitSet seen = new BitSet();
        values.intersect(new PointValues.IntersectVisitor(){

            public PointValues.Relation compare(byte[] minPacked, byte[] maxPacked) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }

            public void visit(int docID) {
                throw new IllegalStateException();
            }

            public void visit(int docID, byte[] packedValue) {
                seen.set(docID);
                Assert.assertEquals((long)docID, (long)NumericUtils.sortableBytesToInt((byte[])packedValue, (int)0));
            }
        });
        BasePointsFormatTestCase.assertEquals((long)20L, (long)seen.cardinality());
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    public void testMerge() throws Exception {
        Directory dir = this.getDirectory(20);
        IndexWriterConfig iwc = BasePointsFormatTestCase.newIndexWriterConfig();
        iwc.setMergePolicy((MergePolicy)BasePointsFormatTestCase.newLogMergePolicy());
        IndexWriter w = new IndexWriter(dir, iwc);
        byte[] point = new byte[4];
        for (int i = 0; i < 20; ++i) {
            Document doc = new Document();
            NumericUtils.intToSortableBytes((int)i, (byte[])point, (int)0);
            doc.add((IndexableField)new BinaryPoint("dim", (byte[][])new byte[][]{point}));
            w.addDocument((Iterable)doc);
            if (i != 10) continue;
            w.commit();
        }
        w.forceMerge(1);
        w.close();
        DirectoryReader r = DirectoryReader.open((Directory)dir);
        LeafReader sub = BasePointsFormatTestCase.getOnlyLeafReader((IndexReader)r);
        PointValues values = sub.getPointValues("dim");
        final BitSet seen = new BitSet();
        values.intersect(new PointValues.IntersectVisitor(){

            public PointValues.Relation compare(byte[] minPacked, byte[] maxPacked) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }

            public void visit(int docID) {
                throw new IllegalStateException();
            }

            public void visit(int docID, byte[] packedValue) {
                seen.set(docID);
                Assert.assertEquals((long)docID, (long)NumericUtils.sortableBytesToInt((byte[])packedValue, (int)0));
            }
        });
        BasePointsFormatTestCase.assertEquals((long)20L, (long)seen.cardinality());
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    public void testAllPointDocsDeletedInSegment() throws Exception {
        Directory dir = this.getDirectory(20);
        IndexWriterConfig iwc = BasePointsFormatTestCase.newIndexWriterConfig();
        IndexWriter w = new IndexWriter(dir, iwc);
        byte[] point = new byte[4];
        for (int i = 0; i < 10; ++i) {
            Document doc = new Document();
            NumericUtils.intToSortableBytes((int)i, (byte[])point, (int)0);
            doc.add((IndexableField)new BinaryPoint("dim", (byte[][])new byte[][]{point}));
            doc.add((IndexableField)new NumericDocValuesField("id", (long)i));
            doc.add((IndexableField)BasePointsFormatTestCase.newStringField("x", "x", Field.Store.NO));
            w.addDocument((Iterable)doc);
        }
        w.addDocument((Iterable)new Document());
        w.deleteDocuments(new Term[]{new Term("x", "x")});
        if (BasePointsFormatTestCase.random().nextBoolean()) {
            w.forceMerge(1);
        }
        w.close();
        DirectoryReader r = DirectoryReader.open((Directory)dir);
        BasePointsFormatTestCase.assertEquals((long)1L, (long)r.numDocs());
        final Bits liveDocs = MultiFields.getLiveDocs((IndexReader)r);
        for (LeafReaderContext ctx : r.leaves()) {
            int docID;
            PointValues values = ctx.reader().getPointValues("dim");
            NumericDocValues idValues = ctx.reader().getNumericDocValues("id");
            if (idValues == null) continue;
            final int[] docIDToID = new int[ctx.reader().maxDoc()];
            while ((docID = idValues.nextDoc()) != Integer.MAX_VALUE) {
                docIDToID[docID] = (int)idValues.longValue();
            }
            if (values == null) continue;
            final BitSet seen = new BitSet();
            values.intersect(new PointValues.IntersectVisitor(){

                public PointValues.Relation compare(byte[] minPacked, byte[] maxPacked) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }

                public void visit(int docID) {
                    throw new IllegalStateException();
                }

                public void visit(int docID, byte[] packedValue) {
                    if (liveDocs.get(docID)) {
                        seen.set(docID);
                    }
                    Assert.assertEquals((long)docIDToID[docID], (long)NumericUtils.sortableBytesToInt((byte[])packedValue, (int)0));
                }
            });
            BasePointsFormatTestCase.assertEquals((long)0L, (long)seen.cardinality());
        }
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    public void testWithExceptions() throws Exception {
        int numDocs = BasePointsFormatTestCase.atLeast(10000);
        int numBytesPerDim = TestUtil.nextInt(BasePointsFormatTestCase.random(), 2, 16);
        int numDims = TestUtil.nextInt(BasePointsFormatTestCase.random(), 1, 8);
        byte[][][] docValues = new byte[numDocs][][];
        for (int docID = 0; docID < numDocs; ++docID) {
            byte[][] values = new byte[numDims][];
            for (int dim = 0; dim < numDims; ++dim) {
                values[dim] = new byte[numBytesPerDim];
                BasePointsFormatTestCase.random().nextBytes(values[dim]);
            }
            docValues[docID] = values;
        }
        boolean done = false;
        while (!done) {
            MockDirectoryWrapper dir = BasePointsFormatTestCase.newMockFSDirectory(BasePointsFormatTestCase.createTempDir());
            Throwable throwable = null;
            try {
                try {
                    dir.setRandomIOExceptionRate(0.05);
                    dir.setRandomIOExceptionRateOnOpen(0.05);
                    this.verify((Directory)dir, docValues, null, numDims, numBytesPerDim, true);
                }
                catch (IllegalStateException ise) {
                    done = this.handlePossiblyFakeException(ise);
                }
                catch (AssertionError ae) {
                    if (((Throwable)((Object)ae)).getMessage() != null && ((Throwable)((Object)ae)).getMessage().contains("does not exist; files=")) {
                        done = true;
                        continue;
                    }
                    throw ae;
                }
                catch (IllegalArgumentException iae) {
                    BasePointsFormatTestCase.assertTrue((boolean)iae.getMessage().contains("either increase maxMBSortInHeap or decrease maxPointsInLeafNode"));
                }
                catch (IOException ioe) {
                    done = this.handlePossiblyFakeException(ioe);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dir == null) continue;
                if (throwable != null) {
                    try {
                        dir.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dir.close();
            }
        }
    }

    private boolean handlePossiblyFakeException(Exception e) {
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            String message = ex.getMessage();
            if (message == null || !message.contains("a random IOException") && !message.contains("background merge hit exception")) continue;
            return true;
        }
        Rethrow.rethrow(e);
        return false;
    }

    public void testMultiValued() throws Exception {
        int numBytesPerDim = TestUtil.nextInt(BasePointsFormatTestCase.random(), 2, 16);
        int numDims = TestUtil.nextInt(BasePointsFormatTestCase.random(), 1, 8);
        int numDocs = BasePointsFormatTestCase.atLeast(1000);
        ArrayList<byte[][]> docValues = new ArrayList<byte[][]>();
        ArrayList<Integer> docIDs = new ArrayList<Integer>();
        for (int docID = 0; docID < numDocs; ++docID) {
            int numValuesInDoc = TestUtil.nextInt(BasePointsFormatTestCase.random(), 1, 5);
            for (int ord = 0; ord < numValuesInDoc; ++ord) {
                docIDs.add(docID);
                byte[][] values = new byte[numDims][];
                for (int dim = 0; dim < numDims; ++dim) {
                    values[dim] = new byte[numBytesPerDim];
                    BasePointsFormatTestCase.random().nextBytes(values[dim]);
                }
                docValues.add(values);
            }
        }
        byte[][][] docValuesArray = (byte[][][])docValues.toArray((T[])new byte[docValues.size()][][]);
        int[] docIDsArray = new int[docIDs.size()];
        for (int i = 0; i < docIDsArray.length; ++i) {
            docIDsArray[i] = (Integer)docIDs.get(i);
        }
        this.verify(docValuesArray, docIDsArray, numDims, numBytesPerDim);
    }

    public void testAllEqual() throws Exception {
        int numBytesPerDim = TestUtil.nextInt(BasePointsFormatTestCase.random(), 2, 16);
        int numDims = TestUtil.nextInt(BasePointsFormatTestCase.random(), 1, 8);
        int numDocs = BasePointsFormatTestCase.atLeast(1000);
        byte[][][] docValues = new byte[numDocs][][];
        for (int docID = 0; docID < numDocs; ++docID) {
            if (docID == 0) {
                byte[][] values = new byte[numDims][];
                for (int dim = 0; dim < numDims; ++dim) {
                    values[dim] = new byte[numBytesPerDim];
                    BasePointsFormatTestCase.random().nextBytes(values[dim]);
                }
                docValues[docID] = values;
                continue;
            }
            docValues[docID] = docValues[0];
        }
        this.verify(docValues, null, numDims, numBytesPerDim);
    }

    public void testOneDimEqual() throws Exception {
        int numBytesPerDim = TestUtil.nextInt(BasePointsFormatTestCase.random(), 2, 16);
        int numDims = TestUtil.nextInt(BasePointsFormatTestCase.random(), 1, 8);
        int numDocs = BasePointsFormatTestCase.atLeast(1000);
        int theEqualDim = BasePointsFormatTestCase.random().nextInt(numDims);
        byte[][][] docValues = new byte[numDocs][][];
        for (int docID = 0; docID < numDocs; ++docID) {
            byte[][] values = new byte[numDims][];
            for (int dim = 0; dim < numDims; ++dim) {
                values[dim] = new byte[numBytesPerDim];
                BasePointsFormatTestCase.random().nextBytes(values[dim]);
            }
            docValues[docID] = values;
            if (docID <= 0) continue;
            docValues[docID][theEqualDim] = docValues[0][theEqualDim];
        }
        this.verify(docValues, null, numDims, numBytesPerDim);
    }

    public void testOneDimTwoValues() throws Exception {
        int numBytesPerDim = TestUtil.nextInt(BasePointsFormatTestCase.random(), 2, 16);
        int numDims = TestUtil.nextInt(BasePointsFormatTestCase.random(), 1, 8);
        int numDocs = BasePointsFormatTestCase.atLeast(1000);
        int theDim = BasePointsFormatTestCase.random().nextInt(numDims);
        byte[] value1 = new byte[numBytesPerDim];
        BasePointsFormatTestCase.random().nextBytes(value1);
        byte[] value2 = new byte[numBytesPerDim];
        BasePointsFormatTestCase.random().nextBytes(value2);
        byte[][][] docValues = new byte[numDocs][][];
        for (int docID = 0; docID < numDocs; ++docID) {
            byte[][] values = new byte[numDims][];
            for (int dim = 0; dim < numDims; ++dim) {
                if (dim == theDim) {
                    values[dim] = BasePointsFormatTestCase.random().nextBoolean() ? value1 : value2;
                    continue;
                }
                values[dim] = new byte[numBytesPerDim];
                BasePointsFormatTestCase.random().nextBytes(values[dim]);
            }
            docValues[docID] = values;
        }
        this.verify(docValues, null, numDims, numBytesPerDim);
    }

    public void testBigIntNDims() throws Exception {
        int numDocs = BasePointsFormatTestCase.atLeast(1000);
        try (Directory dir = this.getDirectory(numDocs);){
            final int numBytesPerDim = TestUtil.nextInt(BasePointsFormatTestCase.random(), 2, 16);
            final int numDims = TestUtil.nextInt(BasePointsFormatTestCase.random(), 1, 8);
            IndexWriterConfig iwc = BasePointsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BasePointsFormatTestCase.random()));
            iwc.setMergePolicy((MergePolicy)BasePointsFormatTestCase.newLogMergePolicy());
            RandomIndexWriter w = new RandomIndexWriter(BasePointsFormatTestCase.random(), dir, iwc);
            BigInteger[][] docs = new BigInteger[numDocs][];
            for (int docID = 0; docID < numDocs; ++docID) {
                BigInteger[] values = new BigInteger[numDims];
                if (VERBOSE) {
                    System.out.println("  docID=" + docID);
                }
                byte[][] bytes = new byte[numDims][];
                for (int dim = 0; dim < numDims; ++dim) {
                    values[dim] = this.randomBigInt(numBytesPerDim);
                    bytes[dim] = new byte[numBytesPerDim];
                    NumericUtils.bigIntToSortableBytes((BigInteger)values[dim], (int)numBytesPerDim, (byte[])bytes[dim], (int)0);
                    if (!VERBOSE) continue;
                    System.out.println("    " + dim + " -> " + values[dim]);
                }
                docs[docID] = values;
                Document doc = new Document();
                doc.add((IndexableField)new BinaryPoint("field", (byte[][])bytes));
                w.addDocument(doc);
            }
            DirectoryReader r = w.getReader();
            w.close();
            int iters = BasePointsFormatTestCase.atLeast(100);
            for (int iter = 0; iter < iters; ++iter) {
                if (VERBOSE) {
                    System.out.println("\nTEST: iter=" + iter);
                }
                final BigInteger[] queryMin = new BigInteger[numDims];
                final BigInteger[] queryMax = new BigInteger[numDims];
                for (int dim = 0; dim < numDims; ++dim) {
                    queryMin[dim] = this.randomBigInt(numBytesPerDim);
                    queryMax[dim] = this.randomBigInt(numBytesPerDim);
                    if (queryMin[dim].compareTo(queryMax[dim]) > 0) {
                        BigInteger x = queryMin[dim];
                        queryMin[dim] = queryMax[dim];
                        queryMax[dim] = x;
                    }
                    if (!VERBOSE) continue;
                    System.out.println("  " + dim + "\n    min=" + queryMin[dim] + "\n    max=" + queryMax[dim]);
                }
                final BitSet hits = new BitSet();
                for (LeafReaderContext ctx : r.leaves()) {
                    PointValues dimValues = ctx.reader().getPointValues("field");
                    if (dimValues == null) continue;
                    final int docBase = ctx.docBase;
                    dimValues.intersect(new PointValues.IntersectVisitor(){

                        public void visit(int docID) {
                            hits.set(docBase + docID);
                        }

                        public void visit(int docID, byte[] packedValue) {
                            for (int dim = 0; dim < numDims; ++dim) {
                                BigInteger x = NumericUtils.sortableBytesToBigInt((byte[])packedValue, (int)(dim * numBytesPerDim), (int)numBytesPerDim);
                                if (x.compareTo(queryMin[dim]) >= 0 && x.compareTo(queryMax[dim]) <= 0) continue;
                                return;
                            }
                            hits.set(docBase + docID);
                        }

                        public PointValues.Relation compare(byte[] minPacked, byte[] maxPacked) {
                            boolean crosses = false;
                            for (int dim = 0; dim < numDims; ++dim) {
                                BigInteger min = NumericUtils.sortableBytesToBigInt((byte[])minPacked, (int)(dim * numBytesPerDim), (int)numBytesPerDim);
                                BigInteger max = NumericUtils.sortableBytesToBigInt((byte[])maxPacked, (int)(dim * numBytesPerDim), (int)numBytesPerDim);
                                assert (max.compareTo(min) >= 0);
                                if (max.compareTo(queryMin[dim]) < 0 || min.compareTo(queryMax[dim]) > 0) {
                                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                                }
                                if (min.compareTo(queryMin[dim]) >= 0 && max.compareTo(queryMax[dim]) <= 0) continue;
                                crosses = true;
                            }
                            if (crosses) {
                                return PointValues.Relation.CELL_CROSSES_QUERY;
                            }
                            return PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                    });
                }
                for (int docID = 0; docID < numDocs; ++docID) {
                    BigInteger[] docValues = docs[docID];
                    boolean expected = true;
                    for (int dim = 0; dim < numDims; ++dim) {
                        BigInteger x = docValues[dim];
                        if (x.compareTo(queryMin[dim]) >= 0 && x.compareTo(queryMax[dim]) <= 0) continue;
                        expected = false;
                        break;
                    }
                    boolean actual = hits.get(docID);
                    BasePointsFormatTestCase.assertEquals((String)("docID=" + docID), (Object)expected, (Object)actual);
                }
            }
            r.close();
        }
    }

    public void testRandomBinaryTiny() throws Exception {
        this.doTestRandomBinary(10);
    }

    public void testRandomBinaryMedium() throws Exception {
        this.doTestRandomBinary(10000);
    }

    @LuceneTestCase.Nightly
    public void testRandomBinaryBig() throws Exception {
        BasePointsFormatTestCase.assumeFalse("too slow with SimpleText", Codec.getDefault().getName().equals("SimpleText"));
        this.doTestRandomBinary(200000);
    }

    private void doTestRandomBinary(int count) throws Exception {
        int numDocs = TestUtil.nextInt(BasePointsFormatTestCase.random(), count, count * 2);
        int numBytesPerDim = TestUtil.nextInt(BasePointsFormatTestCase.random(), 2, 16);
        int numDataDims = TestUtil.nextInt(BasePointsFormatTestCase.random(), 1, 8);
        int numIndexDims = TestUtil.nextInt(BasePointsFormatTestCase.random(), 1, numDataDims);
        byte[][][] docValues = new byte[numDocs][][];
        for (int docID = 0; docID < numDocs; ++docID) {
            byte[][] values = new byte[numDataDims][];
            for (int dim = 0; dim < numDataDims; ++dim) {
                values[dim] = new byte[numBytesPerDim];
                BasePointsFormatTestCase.random().nextBytes(values[dim]);
            }
            docValues[docID] = values;
        }
        this.verify(docValues, null, numDataDims, numIndexDims, numBytesPerDim);
    }

    private void verify(byte[][][] docValues, int[] docIDs, int numDims, int numBytesPerDim) throws Exception {
        this.verify(docValues, docIDs, numDims, numDims, numBytesPerDim);
    }

    private void verify(byte[][][] docValues, int[] docIDs, int numDataDims, int numIndexDims, int numBytesPerDim) throws Exception {
        Directory dir = this.getDirectory(docValues.length);
        Throwable throwable = null;
        while (true) {
            try {
                this.verify(dir, docValues, docIDs, numDataDims, numIndexDims, numBytesPerDim, false);
                return;
            }
            catch (IllegalArgumentException iae) {
                try {
                    iae.printStackTrace();
                    BasePointsFormatTestCase.assertTrue((boolean)iae.getMessage().contains("either increase maxMBSortInHeap or decrease maxPointsInLeafNode"));
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            break;
        }
        finally {
            if (dir != null) {
                if (throwable != null) {
                    try {
                        dir.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    dir.close();
                }
            }
        }
    }

    private void verify(Directory dir, byte[][][] docValues, int[] ids, int numDims, int numBytesPerDim, boolean expectExceptions) throws Exception {
        this.verify(dir, docValues, ids, numDims, numDims, numBytesPerDim, expectExceptions);
    }

    private byte[] flattenBinaryPoint(byte[][] value, int numDataDims, int numBytesPerDim) {
        byte[] result = new byte[value.length * numBytesPerDim];
        for (int d = 0; d < numDataDims; ++d) {
            System.arraycopy(value[d], 0, result, d * numBytesPerDim, numBytesPerDim);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify(Directory dir, byte[][][] docValues, int[] ids, int numDataDims, final int numIndexDims, final int numBytesPerDim, boolean expectExceptions) throws Exception {
        int addIndexesAt;
        RandomIndexWriter saveW;
        Directory saveDir;
        MergeScheduler ms;
        int numValues = docValues.length;
        if (VERBOSE) {
            System.out.println("TEST: numValues=" + numValues + " numDataDims=" + numDataDims + " numIndexDims=" + numIndexDims + " numBytesPerDim=" + numBytesPerDim);
        }
        boolean useRealWriter = docValues.length > 10000;
        IndexWriterConfig iwc = useRealWriter ? new IndexWriterConfig((Analyzer)new MockAnalyzer(BasePointsFormatTestCase.random())) : BasePointsFormatTestCase.newIndexWriterConfig();
        if (expectExceptions && (ms = iwc.getMergeScheduler()) instanceof ConcurrentMergeScheduler) {
            ((ConcurrentMergeScheduler)ms).setSuppressExceptions();
        }
        RandomIndexWriter w = new RandomIndexWriter(BasePointsFormatTestCase.random(), dir, iwc);
        DirectoryReader r = null;
        byte[][] expectedMinValues = new byte[numDataDims][];
        byte[][] expectedMaxValues = new byte[numDataDims][];
        for (int ord = 0; ord < docValues.length; ++ord) {
            for (int dim = 0; dim < numDataDims; ++dim) {
                if (ord == 0) {
                    expectedMinValues[dim] = new byte[numBytesPerDim];
                    System.arraycopy(docValues[ord][dim], 0, expectedMinValues[dim], 0, numBytesPerDim);
                    expectedMaxValues[dim] = new byte[numBytesPerDim];
                    System.arraycopy(docValues[ord][dim], 0, expectedMaxValues[dim], 0, numBytesPerDim);
                    continue;
                }
                if (FutureArrays.compareUnsigned((byte[])docValues[ord][dim], (int)0, (int)numBytesPerDim, (byte[])expectedMinValues[dim], (int)0, (int)numBytesPerDim) < 0) {
                    System.arraycopy(docValues[ord][dim], 0, expectedMinValues[dim], 0, numBytesPerDim);
                }
                if (FutureArrays.compareUnsigned((byte[])docValues[ord][dim], (int)0, (int)numBytesPerDim, (byte[])expectedMaxValues[dim], (int)0, (int)numBytesPerDim) <= 0) continue;
                System.arraycopy(docValues[ord][dim], 0, expectedMaxValues[dim], 0, numBytesPerDim);
            }
        }
        if (BasePointsFormatTestCase.random().nextInt(5) == 1) {
            MergeScheduler ms2;
            saveDir = dir;
            saveW = w;
            dir = this.getDirectory(numValues);
            iwc = useRealWriter ? new IndexWriterConfig((Analyzer)new MockAnalyzer(BasePointsFormatTestCase.random())) : BasePointsFormatTestCase.newIndexWriterConfig();
            if (expectExceptions && (ms2 = iwc.getMergeScheduler()) instanceof ConcurrentMergeScheduler) {
                ((ConcurrentMergeScheduler)ms2).setSuppressExceptions();
            }
            w = new RandomIndexWriter(BasePointsFormatTestCase.random(), dir, iwc);
            addIndexesAt = TestUtil.nextInt(BasePointsFormatTestCase.random(), 1, numValues - 1);
        } else {
            saveW = null;
            saveDir = null;
            addIndexesAt = 0;
        }
        try {
            int docID;
            FieldType fieldType = new FieldType();
            fieldType.setDimensions(numDataDims, numIndexDims, numBytesPerDim);
            fieldType.freeze();
            Document doc = null;
            int lastID = -1;
            for (int ord = 0; ord < numValues; ++ord) {
                int id = ids == null ? ord : ids[ord];
                if (id != lastID) {
                    if (doc != null) {
                        if (useRealWriter) {
                            w.w.addDocument((Iterable)doc);
                        } else {
                            w.addDocument(doc);
                        }
                    }
                    doc = new Document();
                    doc.add((IndexableField)new NumericDocValuesField("id", (long)id));
                }
                byte[] val = this.flattenBinaryPoint(docValues[ord], numDataDims, numBytesPerDim);
                doc.add((IndexableField)new BinaryPoint("field", val, (IndexableFieldType)fieldType));
                lastID = id;
                if (BasePointsFormatTestCase.random().nextInt(30) == 17) {
                    if (useRealWriter) {
                        w.w.addDocument((Iterable)new Document());
                    } else {
                        w.addDocument(new Document());
                    }
                    if (VERBOSE) {
                        System.out.println("add empty doc");
                    }
                }
                if (BasePointsFormatTestCase.random().nextInt(30) == 17) {
                    Document xdoc = new Document();
                    val = this.flattenBinaryPoint(docValues[ord], numDataDims, numBytesPerDim);
                    xdoc.add((IndexableField)new BinaryPoint("field", val, (IndexableFieldType)fieldType));
                    xdoc.add((IndexableField)new StringField("nukeme", "yes", Field.Store.NO));
                    if (useRealWriter) {
                        w.w.addDocument((Iterable)xdoc);
                    } else {
                        w.addDocument(xdoc);
                    }
                    if (VERBOSE) {
                        System.out.println("add doc doc-to-delete");
                    }
                    if (BasePointsFormatTestCase.random().nextInt(5) == 1) {
                        if (useRealWriter) {
                            w.w.deleteDocuments(new Term[]{new Term("nukeme", "yes")});
                        } else {
                            w.deleteDocuments(new Term("nukeme", "yes"));
                        }
                    }
                }
                if (VERBOSE) {
                    System.out.println("  ord=" + ord + " id=" + id);
                    for (int dim = 0; dim < numDataDims; ++dim) {
                        System.out.println("    dim=" + dim + " value=" + new BytesRef(docValues[ord][dim]));
                    }
                }
                if (saveW == null || ord < addIndexesAt) continue;
                this.switchIndex(w, dir, saveW);
                w = saveW;
                dir = saveDir;
                saveW = null;
                saveDir = null;
            }
            w.addDocument(doc);
            w.deleteDocuments(new Term("nukeme", "yes"));
            if (BasePointsFormatTestCase.random().nextBoolean()) {
                if (VERBOSE) {
                    System.out.println("\nTEST: now force merge");
                }
                w.forceMerge(1);
            }
            r = w.getReader();
            w.close();
            if (VERBOSE) {
                System.out.println("TEST: reader=" + r);
            }
            NumericDocValues idValues = MultiDocValues.getNumericValues((IndexReader)r, (String)"id");
            final int[] docIDToID = new int[r.maxDoc()];
            while ((docID = idValues.nextDoc()) != Integer.MAX_VALUE) {
                docIDToID[docID] = (int)idValues.longValue();
            }
            final Bits liveDocs = MultiFields.getLiveDocs((IndexReader)r);
            byte[] minValues = new byte[numIndexDims * numBytesPerDim];
            Arrays.fill(minValues, (byte)-1);
            byte[] maxValues = new byte[numIndexDims * numBytesPerDim];
            for (LeafReaderContext ctx : r.leaves()) {
                PointValues dimValues = ctx.reader().getPointValues("field");
                if (dimValues == null) continue;
                byte[] leafMinValues = dimValues.getMinPackedValue();
                byte[] leafMaxValues = dimValues.getMaxPackedValue();
                for (int dim = 0; dim < numIndexDims; ++dim) {
                    if (FutureArrays.compareUnsigned((byte[])leafMinValues, (int)(dim * numBytesPerDim), (int)(dim * numBytesPerDim + numBytesPerDim), (byte[])minValues, (int)(dim * numBytesPerDim), (int)(dim * numBytesPerDim + numBytesPerDim)) < 0) {
                        System.arraycopy(leafMinValues, dim * numBytesPerDim, minValues, dim * numBytesPerDim, numBytesPerDim);
                    }
                    if (FutureArrays.compareUnsigned((byte[])leafMaxValues, (int)(dim * numBytesPerDim), (int)(dim * numBytesPerDim + numBytesPerDim), (byte[])maxValues, (int)(dim * numBytesPerDim), (int)(dim * numBytesPerDim + numBytesPerDim)) <= 0) continue;
                    System.arraycopy(leafMaxValues, dim * numBytesPerDim, maxValues, dim * numBytesPerDim, numBytesPerDim);
                }
            }
            byte[] scratch = new byte[numBytesPerDim];
            for (int dim = 0; dim < numIndexDims; ++dim) {
                System.arraycopy(minValues, dim * numBytesPerDim, scratch, 0, numBytesPerDim);
                BasePointsFormatTestCase.assertTrue((boolean)Arrays.equals(expectedMinValues[dim], scratch));
                System.arraycopy(maxValues, dim * numBytesPerDim, scratch, 0, numBytesPerDim);
                BasePointsFormatTestCase.assertTrue((boolean)Arrays.equals(expectedMaxValues[dim], scratch));
            }
            int iters = BasePointsFormatTestCase.atLeast(100);
            for (int iter = 0; iter < iters; ++iter) {
                int dim;
                if (VERBOSE) {
                    System.out.println("\nTEST: iter=" + iter);
                }
                final byte[][] queryMin = new byte[numIndexDims][];
                final byte[][] queryMax = new byte[numIndexDims][];
                for (dim = 0; dim < numIndexDims; ++dim) {
                    queryMin[dim] = new byte[numBytesPerDim];
                    BasePointsFormatTestCase.random().nextBytes(queryMin[dim]);
                    queryMax[dim] = new byte[numBytesPerDim];
                    BasePointsFormatTestCase.random().nextBytes(queryMax[dim]);
                    if (FutureArrays.compareUnsigned((byte[])queryMin[dim], (int)0, (int)numBytesPerDim, (byte[])queryMax[dim], (int)0, (int)numBytesPerDim) <= 0) continue;
                    Object x = queryMin[dim];
                    queryMin[dim] = queryMax[dim];
                    queryMax[dim] = (byte[])x;
                }
                if (VERBOSE) {
                    for (dim = 0; dim < numIndexDims; ++dim) {
                        System.out.println("  dim=" + dim + "\n    queryMin=" + new BytesRef(queryMin[dim]) + "\n    queryMax=" + new BytesRef(queryMax[dim]));
                    }
                }
                final BitSet hits = new BitSet();
                for (LeafReaderContext ctx : r.leaves()) {
                    PointValues dimValues = ctx.reader().getPointValues("field");
                    if (dimValues == null) continue;
                    final int docBase = ctx.docBase;
                    dimValues.intersect(new PointValues.IntersectVisitor(){

                        public void visit(int docID) {
                            if (liveDocs == null || liveDocs.get(docBase + docID)) {
                                hits.set(docIDToID[docBase + docID]);
                            }
                        }

                        public void visit(int docID, byte[] packedValue) {
                            if (liveDocs != null && !liveDocs.get(docBase + docID)) {
                                return;
                            }
                            for (int dim = 0; dim < numIndexDims; ++dim) {
                                if (FutureArrays.compareUnsigned((byte[])packedValue, (int)(dim * numBytesPerDim), (int)(dim * numBytesPerDim + numBytesPerDim), (byte[])queryMin[dim], (int)0, (int)numBytesPerDim) >= 0 && FutureArrays.compareUnsigned((byte[])packedValue, (int)(dim * numBytesPerDim), (int)(dim * numBytesPerDim + numBytesPerDim), (byte[])queryMax[dim], (int)0, (int)numBytesPerDim) <= 0) continue;
                                return;
                            }
                            hits.set(docIDToID[docBase + docID]);
                        }

                        public PointValues.Relation compare(byte[] minPacked, byte[] maxPacked) {
                            boolean crosses = false;
                            for (int dim = 0; dim < numIndexDims; ++dim) {
                                if (FutureArrays.compareUnsigned((byte[])maxPacked, (int)(dim * numBytesPerDim), (int)(dim * numBytesPerDim + numBytesPerDim), (byte[])queryMin[dim], (int)0, (int)numBytesPerDim) < 0 || FutureArrays.compareUnsigned((byte[])minPacked, (int)(dim * numBytesPerDim), (int)(dim * numBytesPerDim + numBytesPerDim), (byte[])queryMax[dim], (int)0, (int)numBytesPerDim) > 0) {
                                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                                }
                                if (FutureArrays.compareUnsigned((byte[])minPacked, (int)(dim * numBytesPerDim), (int)(dim * numBytesPerDim + numBytesPerDim), (byte[])queryMin[dim], (int)0, (int)numBytesPerDim) >= 0 && FutureArrays.compareUnsigned((byte[])maxPacked, (int)(dim * numBytesPerDim), (int)(dim * numBytesPerDim + numBytesPerDim), (byte[])queryMax[dim], (int)0, (int)numBytesPerDim) <= 0) continue;
                                crosses = true;
                            }
                            if (crosses) {
                                return PointValues.Relation.CELL_CROSSES_QUERY;
                            }
                            return PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                    });
                }
                BitSet expected = new BitSet();
                for (int ord = 0; ord < numValues; ++ord) {
                    boolean matches = true;
                    for (int dim2 = 0; dim2 < numIndexDims; ++dim2) {
                        byte[] x = docValues[ord][dim2];
                        if (FutureArrays.compareUnsigned((byte[])x, (int)0, (int)numBytesPerDim, (byte[])queryMin[dim2], (int)0, (int)numBytesPerDim) >= 0 && FutureArrays.compareUnsigned((byte[])x, (int)0, (int)numBytesPerDim, (byte[])queryMax[dim2], (int)0, (int)numBytesPerDim) <= 0) continue;
                        matches = false;
                        break;
                    }
                    if (!matches) continue;
                    int id = ids == null ? ord : ids[ord];
                    expected.set(id);
                }
                int limit = Math.max(expected.length(), hits.length());
                int failCount = 0;
                int successCount = 0;
                for (int id = 0; id < limit; ++id) {
                    if (expected.get(id) != hits.get(id)) {
                        System.out.println("FAIL: id=" + id);
                        ++failCount;
                        continue;
                    }
                    ++successCount;
                }
                if (failCount == 0) continue;
                for (int docID2 = 0; docID2 < r.maxDoc(); ++docID2) {
                    System.out.println("  docID=" + docID2 + " id=" + docIDToID[docID2]);
                }
                BasePointsFormatTestCase.fail((String)(failCount + " docs failed; " + successCount + " docs succeeded"));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{r, w, saveW, saveDir == null ? null : dir});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{r, w, saveW, saveDir == null ? null : dir});
    }

    public void testAddIndexes() throws IOException {
        BaseDirectoryWrapper dir1 = BasePointsFormatTestCase.newDirectory();
        RandomIndexWriter w = new RandomIndexWriter(BasePointsFormatTestCase.random(), (Directory)dir1);
        Document doc = new Document();
        doc.add((IndexableField)new IntPoint("int1", new int[]{17}));
        w.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new IntPoint("int2", new int[]{42}));
        w.addDocument(doc);
        w.close();
        BaseDirectoryWrapper dir2 = BasePointsFormatTestCase.newDirectory();
        w = new RandomIndexWriter(BasePointsFormatTestCase.random(), (Directory)dir2);
        doc = new Document();
        doc.add((IndexableField)new IntPoint("int2", new int[]{42}));
        w.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new IntPoint("int1", new int[]{17}));
        w.addDocument(doc);
        w.close();
        BaseDirectoryWrapper dir = BasePointsFormatTestCase.newDirectory();
        w = new RandomIndexWriter(BasePointsFormatTestCase.random(), (Directory)dir);
        w.addIndexes(new Directory[]{dir1, dir2});
        w.forceMerge(1);
        DirectoryReader r = w.getReader();
        IndexSearcher s = BasePointsFormatTestCase.newSearcher((IndexReader)r, false);
        BasePointsFormatTestCase.assertEquals((long)2L, (long)s.count(IntPoint.newExactQuery((String)"int1", (int)17)));
        BasePointsFormatTestCase.assertEquals((long)2L, (long)s.count(IntPoint.newExactQuery((String)"int2", (int)42)));
        r.close();
        w.close();
        dir.close();
        dir1.close();
        dir2.close();
    }

    private void switchIndex(RandomIndexWriter w, Directory dir, RandomIndexWriter saveW) throws IOException {
        if (BasePointsFormatTestCase.random().nextBoolean()) {
            try (DirectoryReader r = w.getReader();){
                if (BasePointsFormatTestCase.random().nextBoolean()) {
                    ArrayList<CodecReader> subs = new ArrayList<CodecReader>();
                    for (LeafReaderContext context : r.leaves()) {
                        subs.add((CodecReader)context.reader());
                    }
                    if (VERBOSE) {
                        System.out.println("TEST: now use addIndexes(CodecReader[]) to switch writers");
                    }
                    saveW.addIndexes(subs.toArray(new CodecReader[subs.size()]));
                }
                if (VERBOSE) {
                    System.out.println("TEST: now use TestUtil.addIndexesSlowly(DirectoryReader[]) to switch writers");
                }
                TestUtil.addIndexesSlowly(saveW.w, r);
            }
        } else {
            if (VERBOSE) {
                System.out.println("TEST: now use addIndexes(Directory[]) to switch writers");
            }
            w.close();
            saveW.addIndexes(dir);
        }
        w.close();
        dir.close();
    }

    private BigInteger randomBigInt(int numBytes) {
        BigInteger x = new BigInteger(numBytes * 8 - 1, BasePointsFormatTestCase.random());
        if (BasePointsFormatTestCase.random().nextBoolean()) {
            x = x.negate();
        }
        return x;
    }

    private Directory getDirectory(int numPoints) throws IOException {
        BaseDirectoryWrapper dir = numPoints > 100000 ? BasePointsFormatTestCase.newFSDirectory(BasePointsFormatTestCase.createTempDir("TestBKDTree")) : BasePointsFormatTestCase.newDirectory();
        return dir;
    }

    @Override
    protected boolean mergeIsStable() {
        return false;
    }

    public void testMixedSchema() throws Exception {
        BaseDirectoryWrapper dir = BasePointsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePointsFormatTestCase.newIndexWriterConfig();
        RandomIndexWriter w = new RandomIndexWriter(BasePointsFormatTestCase.random(), (Directory)dir, iwc);
        iwc.setMaxBufferedDocs(2);
        int i = 0;
        while (i < 2) {
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", Integer.toString(i), Field.Store.NO));
            doc.add((IndexableField)new IntPoint("int", new int[]{i++}));
            w.addDocument(doc);
        }
        Document doc = new Document();
        doc.add((IndexableField)new IntPoint("id", new int[]{0}));
        w.addDocument(doc);
        w.forceMerge(1);
        IOUtils.close((Closeable[])new Closeable[]{w, dir});
    }
}

