/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.BitSet;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryUtils;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.junit.AfterClass;
import org.junit.BeforeClass;

@LuceneTestCase.SuppressCodecs(value={"SimpleText"})
public abstract class SearchEquivalenceTestBase
extends LuceneTestCase {
    protected static IndexSearcher s1;
    protected static IndexSearcher s2;
    protected static Directory directory;
    protected static IndexReader reader;
    protected static Analyzer analyzer;
    protected static String stopword;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Random random = SearchEquivalenceTestBase.random();
        directory = SearchEquivalenceTestBase.newDirectory();
        stopword = "" + SearchEquivalenceTestBase.randomChar();
        CharacterRunAutomaton stopset = new CharacterRunAutomaton(Automata.makeString((String)stopword));
        analyzer = new MockAnalyzer(random, MockTokenizer.WHITESPACE, false, stopset);
        RandomIndexWriter iw = new RandomIndexWriter(random, directory, analyzer);
        Document doc = new Document();
        StringField id = new StringField("id", "", Field.Store.NO);
        TextField field = new TextField("field", "", Field.Store.NO);
        doc.add((IndexableField)id);
        doc.add((IndexableField)field);
        int numDocs = TEST_NIGHTLY ? SearchEquivalenceTestBase.atLeast(1000) : SearchEquivalenceTestBase.atLeast(100);
        for (int i = 0; i < numDocs; ++i) {
            id.setStringValue(Integer.toString(i));
            field.setStringValue(SearchEquivalenceTestBase.randomFieldContents());
            iw.addDocument(doc);
        }
        int numDeletes = numDocs / 20;
        for (int i = 0; i < numDeletes; ++i) {
            Term toDelete = new Term("id", Integer.toString(random.nextInt(numDocs)));
            if (random.nextBoolean()) {
                iw.deleteDocuments(toDelete);
                continue;
            }
            iw.deleteDocuments((Query)new TermQuery(toDelete));
        }
        reader = iw.getReader();
        s1 = SearchEquivalenceTestBase.newSearcher(reader);
        s2 = SearchEquivalenceTestBase.newSearcher(reader);
        iw.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        reader.close();
        directory.close();
        analyzer.close();
        reader = null;
        directory = null;
        analyzer = null;
        s2 = null;
        s1 = null;
    }

    static String randomFieldContents() {
        StringBuilder sb = new StringBuilder();
        int numTerms = SearchEquivalenceTestBase.random().nextInt(15);
        for (int i = 0; i < numTerms; ++i) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(SearchEquivalenceTestBase.randomChar());
        }
        return sb.toString();
    }

    static char randomChar() {
        return (char)TestUtil.nextInt(SearchEquivalenceTestBase.random(), 97, 122);
    }

    protected Term randomTerm() {
        return new Term("field", "" + SearchEquivalenceTestBase.randomChar());
    }

    protected Query randomFilter() {
        TermRangeQuery query;
        if (SearchEquivalenceTestBase.random().nextBoolean()) {
            query = TermRangeQuery.newStringRange((String)"field", (String)"a", (String)("" + SearchEquivalenceTestBase.randomChar()), (boolean)true, (boolean)true);
        } else {
            PhraseQuery phrase = new PhraseQuery(100, "field", new String[]{"" + SearchEquivalenceTestBase.randomChar(), "" + SearchEquivalenceTestBase.randomChar()});
            query = phrase;
        }
        return query;
    }

    public void assertSameSet(Query q1, Query q2) throws Exception {
        this.assertSubsetOf(q1, q2);
        this.assertSubsetOf(q2, q1);
    }

    public void assertSubsetOf(Query q1, Query q2) throws Exception {
        this.assertSubsetOf(q1, q2, null);
        int numFilters = TEST_NIGHTLY ? SearchEquivalenceTestBase.atLeast(10) : SearchEquivalenceTestBase.atLeast(3);
        for (int i = 0; i < numFilters; ++i) {
            Query filter = this.randomFilter();
            this.assertSubsetOf(q1, q2, filter);
            this.assertSubsetOf(this.filteredQuery(q1, filter), this.filteredQuery(q2, filter), null);
        }
    }

    protected void assertSubsetOf(Query q1, Query q2, Query filter) throws Exception {
        QueryUtils.check(q1);
        QueryUtils.check(q2);
        if (filter != null) {
            q1 = new BooleanQuery.Builder().add(q1, BooleanClause.Occur.MUST).add(filter, BooleanClause.Occur.FILTER).build();
            q2 = new BooleanQuery.Builder().add(q2, BooleanClause.Occur.MUST).add(filter, BooleanClause.Occur.FILTER).build();
        }
        for (Sort sort : new Sort[]{Sort.INDEXORDER, Sort.RELEVANCE}) {
            int i;
            TopFieldDocs td1 = s1.search(q1, reader.maxDoc(), sort);
            TopFieldDocs td2 = s2.search(q2, reader.maxDoc(), sort);
            SearchEquivalenceTestBase.assertTrue((String)("too many hits: " + td1.totalHits + " > " + td2.totalHits), (td1.totalHits <= td2.totalHits ? 1 : 0) != 0);
            BitSet bitset = new BitSet();
            for (i = 0; i < td2.scoreDocs.length; ++i) {
                bitset.set(td2.scoreDocs[i].doc);
            }
            for (i = 0; i < td1.scoreDocs.length; ++i) {
                SearchEquivalenceTestBase.assertTrue((boolean)bitset.get(td1.scoreDocs[i].doc));
            }
        }
    }

    protected void assertSameScores(Query q1, Query q2) throws Exception {
        this.assertSameSet(q1, q2);
        this.assertSameScores(q1, q2, null);
        int numFilters = TEST_NIGHTLY ? SearchEquivalenceTestBase.atLeast(10) : SearchEquivalenceTestBase.atLeast(3);
        for (int i = 0; i < numFilters; ++i) {
            Query filter = this.randomFilter();
            this.assertSameScores(q1, q2, filter);
            this.assertSameScores(this.filteredQuery(q1, filter), this.filteredQuery(q2, filter), null);
        }
    }

    protected void assertSameScores(Query q1, Query q2, Query filter) throws Exception {
        if (filter != null) {
            q1 = new BooleanQuery.Builder().add(q1, BooleanClause.Occur.MUST).add(filter, BooleanClause.Occur.FILTER).build();
            q2 = new BooleanQuery.Builder().add(q2, BooleanClause.Occur.MUST).add(filter, BooleanClause.Occur.FILTER).build();
        }
        TopDocs td1 = s1.search(q1, reader.maxDoc());
        TopDocs td2 = s2.search(q2, reader.maxDoc());
        SearchEquivalenceTestBase.assertEquals((long)td1.totalHits, (long)td2.totalHits);
        for (int i = 0; i < td1.scoreDocs.length; ++i) {
            SearchEquivalenceTestBase.assertEquals((long)td1.scoreDocs[i].doc, (long)td2.scoreDocs[i].doc);
            SearchEquivalenceTestBase.assertEquals((double)td1.scoreDocs[i].score, (double)td2.scoreDocs[i].score, (double)1.0E-4);
        }
    }

    protected Query filteredQuery(Query query, Query filter) {
        return new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(filter, BooleanClause.Occur.FILTER).build();
    }
}

