/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.AttributeSource;

public class MockSynonymFilter
extends TokenFilter {
    CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    PositionLengthAttribute posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    List<AttributeSource> tokenQueue = new ArrayList<AttributeSource>();
    boolean endOfInput = false;

    public MockSynonymFilter(TokenStream input) {
        super(input);
    }

    public void reset() throws IOException {
        super.reset();
        this.tokenQueue.clear();
        this.endOfInput = false;
    }

    public final boolean incrementToken() throws IOException {
        if (this.tokenQueue.size() > 0) {
            this.tokenQueue.remove(0).copyTo((AttributeSource)this);
            return true;
        }
        if (!this.endOfInput && this.input.incrementToken()) {
            if (this.termAtt.toString().equals("dogs")) {
                this.addSynonymAndRestoreOrigToken("dog", 1, this.offsetAtt.endOffset());
            } else if (this.termAtt.toString().equals("guinea")) {
                AttributeSource firstSavedToken = this.cloneAttributes();
                if (this.input.incrementToken()) {
                    if (this.termAtt.toString().equals("pig")) {
                        AttributeSource secondSavedToken = this.cloneAttributes();
                        int secondEndOffset = this.offsetAtt.endOffset();
                        firstSavedToken.copyTo((AttributeSource)this);
                        this.addSynonym("cavy", 2, secondEndOffset);
                        this.tokenQueue.add(secondSavedToken);
                    } else if (this.termAtt.toString().equals("dogs")) {
                        this.tokenQueue.add(this.cloneAttributes());
                        this.addSynonym("dog", 1, this.offsetAtt.endOffset());
                    }
                } else {
                    this.endOfInput = true;
                }
                firstSavedToken.copyTo((AttributeSource)this);
            }
            return true;
        }
        this.endOfInput = true;
        return false;
    }

    private void addSynonym(String synonymText, int posLen, int endOffset) {
        this.termAtt.setEmpty().append(synonymText);
        this.posIncAtt.setPositionIncrement(0);
        this.posLenAtt.setPositionLength(posLen);
        this.offsetAtt.setOffset(this.offsetAtt.startOffset(), endOffset);
        this.tokenQueue.add(this.cloneAttributes());
    }

    private void addSynonymAndRestoreOrigToken(String synonymText, int posLen, int endOffset) {
        AttributeSource origToken = this.cloneAttributes();
        this.addSynonym(synonymText, posLen, endOffset);
        origToken.copyTo((AttributeSource)this);
    }
}

