/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.Version;

public abstract class BaseFieldInfoFormatTestCase
extends BaseIndexFileFormatTestCase {
    public void testOneField() throws Exception {
        BaseDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfos.Builder builder = new FieldInfos.Builder();
        FieldInfo fi = builder.getOrAdd("field");
        fi.setIndexOptions(TextField.TYPE_STORED.indexOptions());
        this.addAttributes(fi);
        FieldInfos infos = builder.finish();
        codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT);
        FieldInfos infos2 = codec.fieldInfosFormat().read((Directory)dir, segmentInfo, "", IOContext.DEFAULT);
        BaseFieldInfoFormatTestCase.assertEquals((long)1L, (long)infos2.size());
        BaseFieldInfoFormatTestCase.assertNotNull((Object)infos2.fieldInfo("field"));
        BaseFieldInfoFormatTestCase.assertTrue((infos2.fieldInfo("field").getIndexOptions() != IndexOptions.NONE ? 1 : 0) != 0);
        BaseFieldInfoFormatTestCase.assertFalse((infos2.fieldInfo("field").getDocValuesType() != DocValuesType.NONE ? 1 : 0) != 0);
        BaseFieldInfoFormatTestCase.assertFalse((boolean)infos2.fieldInfo("field").omitsNorms());
        BaseFieldInfoFormatTestCase.assertFalse((boolean)infos2.fieldInfo("field").hasPayloads());
        BaseFieldInfoFormatTestCase.assertFalse((boolean)infos2.fieldInfo("field").hasVectors());
        dir.close();
    }

    public void testImmutableAttributes() throws Exception {
        BaseDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfos.Builder builder = new FieldInfos.Builder();
        FieldInfo fi = builder.getOrAdd("field");
        fi.setIndexOptions(TextField.TYPE_STORED.indexOptions());
        this.addAttributes(fi);
        fi.putAttribute("foo", "bar");
        fi.putAttribute("bar", "baz");
        FieldInfos infos = builder.finish();
        codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT);
        FieldInfos infos2 = codec.fieldInfosFormat().read((Directory)dir, segmentInfo, "", IOContext.DEFAULT);
        BaseFieldInfoFormatTestCase.assertEquals((long)1L, (long)infos2.size());
        BaseFieldInfoFormatTestCase.assertNotNull((Object)infos2.fieldInfo("field"));
        Map attributes = infos2.fieldInfo("field").attributes();
        BaseFieldInfoFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> attributes.put("bogus", "bogus"));
        dir.close();
    }

    public void testExceptionOnCreateOutput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    if (!this.doFail || !"createOutput".equals(e.getMethodName())) continue;
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfos.Builder builder = new FieldInfos.Builder();
        FieldInfo fi = builder.getOrAdd("field");
        fi.setIndexOptions(TextField.TYPE_STORED.indexOptions());
        this.addAttributes(fi);
        FieldInfos infos = builder.finish();
        fail.setDoFail();
        BaseFieldInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnCloseOutput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    if (!this.doFail || !"close".equals(e.getMethodName())) continue;
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfos.Builder builder = new FieldInfos.Builder();
        FieldInfo fi = builder.getOrAdd("field");
        fi.setIndexOptions(TextField.TYPE_STORED.indexOptions());
        this.addAttributes(fi);
        FieldInfos infos = builder.finish();
        fail.setDoFail();
        BaseFieldInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnOpenInput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    if (!this.doFail || !"openInput".equals(e.getMethodName())) continue;
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfos.Builder builder = new FieldInfos.Builder();
        FieldInfo fi = builder.getOrAdd("field");
        fi.setIndexOptions(TextField.TYPE_STORED.indexOptions());
        this.addAttributes(fi);
        FieldInfos infos = builder.finish();
        codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT);
        fail.setDoFail();
        BaseFieldInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.fieldInfosFormat().read((Directory)dir, segmentInfo, "", IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnCloseInput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    if (!this.doFail || !"close".equals(e.getMethodName())) continue;
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        FieldInfos.Builder builder = new FieldInfos.Builder();
        FieldInfo fi = builder.getOrAdd("field");
        fi.setIndexOptions(TextField.TYPE_STORED.indexOptions());
        this.addAttributes(fi);
        FieldInfos infos = builder.finish();
        codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT);
        fail.setDoFail();
        BaseFieldInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.fieldInfosFormat().read((Directory)dir, segmentInfo, "", IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testRandom() throws Exception {
        BaseDirectoryWrapper dir = BaseFieldInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = BaseFieldInfoFormatTestCase.newSegmentInfo((Directory)dir, "_123");
        int numFields = BaseFieldInfoFormatTestCase.atLeast(2000);
        HashSet<String> fieldNames = new HashSet<String>();
        for (int i = 0; i < numFields; ++i) {
            fieldNames.add(TestUtil.randomUnicodeString(BaseFieldInfoFormatTestCase.random()));
        }
        FieldInfos.Builder builder = new FieldInfos.Builder();
        for (String field : fieldNames) {
            IndexableFieldType fieldType = this.randomFieldType(BaseFieldInfoFormatTestCase.random());
            FieldInfo fi = builder.getOrAdd(field);
            IndexOptions indexOptions = fieldType.indexOptions();
            if (indexOptions != IndexOptions.NONE) {
                fi.setIndexOptions(indexOptions);
                if (fieldType.omitNorms()) {
                    fi.setOmitsNorms();
                }
            }
            fi.setDocValuesType(fieldType.docValuesType());
            if (fieldType.indexOptions() != IndexOptions.NONE && fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && BaseFieldInfoFormatTestCase.random().nextBoolean()) {
                fi.setStorePayloads();
            }
            this.addAttributes(fi);
        }
        FieldInfos infos = builder.finish();
        codec.fieldInfosFormat().write((Directory)dir, segmentInfo, "", infos, IOContext.DEFAULT);
        FieldInfos infos2 = codec.fieldInfosFormat().read((Directory)dir, segmentInfo, "", IOContext.DEFAULT);
        this.assertEquals(infos, infos2);
        dir.close();
    }

    private final IndexableFieldType randomFieldType(Random r) {
        IndexOptions[] values;
        FieldType type = new FieldType();
        if (r.nextBoolean()) {
            values = IndexOptions.values();
            type.setIndexOptions(values[r.nextInt(values.length)]);
            type.setOmitNorms(r.nextBoolean());
            if (r.nextBoolean()) {
                type.setStoreTermVectors(true);
                if (type.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
                    type.setStoreTermVectorPositions(r.nextBoolean());
                    type.setStoreTermVectorOffsets(r.nextBoolean());
                    if (type.storeTermVectorPositions()) {
                        type.setStoreTermVectorPayloads(r.nextBoolean());
                    }
                }
            }
        }
        if (r.nextBoolean()) {
            values = this.getDocValuesTypes();
            type.setDocValuesType((DocValuesType)values[r.nextInt(values.length)]);
        }
        return type;
    }

    protected void addAttributes(FieldInfo fi) {
    }

    @Deprecated
    protected DocValuesType[] getDocValuesTypes() {
        return DocValuesType.values();
    }

    protected void assertEquals(FieldInfos expected, FieldInfos actual) {
        BaseFieldInfoFormatTestCase.assertEquals((long)expected.size(), (long)actual.size());
        for (FieldInfo expectedField : expected) {
            FieldInfo actualField = actual.fieldInfo(expectedField.number);
            BaseFieldInfoFormatTestCase.assertNotNull((Object)actualField);
            this.assertEquals(expectedField, actualField);
        }
    }

    protected void assertEquals(FieldInfo expected, FieldInfo actual) {
        BaseFieldInfoFormatTestCase.assertEquals((long)expected.number, (long)actual.number);
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.name, (Object)actual.name);
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.getDocValuesType(), (Object)actual.getDocValuesType());
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.getIndexOptions(), (Object)actual.getIndexOptions());
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.hasNorms(), (Object)actual.hasNorms());
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.hasPayloads(), (Object)actual.hasPayloads());
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.hasVectors(), (Object)actual.hasVectors());
        BaseFieldInfoFormatTestCase.assertEquals((Object)expected.omitsNorms(), (Object)actual.omitsNorms());
        BaseFieldInfoFormatTestCase.assertEquals((long)expected.getDocValuesGen(), (long)actual.getDocValuesGen());
    }

    protected static SegmentInfo newSegmentInfo(Directory dir, String name) {
        Version minVersion = BaseFieldInfoFormatTestCase.random().nextBoolean() ? null : Version.LATEST;
        return new SegmentInfo(dir, Version.LATEST, minVersion, name, 10000, false, Codec.getDefault(), Collections.emptyMap(), StringHelper.randomId(), new HashMap(), null);
    }

    @Override
    protected void addRandomFields(Document doc) {
        doc.add((IndexableField)new StoredField("foobar", TestUtil.randomSimpleString(BaseFieldInfoFormatTestCase.random())));
    }

    @Override
    public void testRamBytesUsed() throws IOException {
        BaseFieldInfoFormatTestCase.assumeTrue("not applicable for this format", true);
    }
}

