/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.Version;

public abstract class BaseSegmentInfoFormatTestCase
extends BaseIndexFileFormatTestCase {
    public void testFiles() throws Exception {
        BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, new HashMap(), null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
        BaseSegmentInfoFormatTestCase.assertEquals((Object)info.files(), (Object)info2.files());
        dir.close();
    }

    public void testAddsSelfToFiles() throws Exception {
        BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, new HashMap(), null);
        Set<String> originalFiles = Collections.singleton("_123.a");
        info.setFiles(originalFiles);
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        Set modifiedFiles = info.files();
        BaseSegmentInfoFormatTestCase.assertTrue((boolean)modifiedFiles.containsAll(originalFiles));
        BaseSegmentInfoFormatTestCase.assertTrue((String)"did you forget to add yourself to files()", (modifiedFiles.size() > originalFiles.size() ? 1 : 0) != 0);
        SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
        BaseSegmentInfoFormatTestCase.assertEquals((Object)info.files(), (Object)info2.files());
        BaseSegmentInfoFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> info2.files().add("bogus"));
        dir.close();
    }

    public void testDiagnostics() throws Exception {
        BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        HashMap<String, String> diagnostics = new HashMap<String, String>();
        diagnostics.put("key1", "value1");
        diagnostics.put("key2", "value2");
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], "_123", 1, false, codec, diagnostics, id, new HashMap(), null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
        BaseSegmentInfoFormatTestCase.assertEquals(diagnostics, (Object)info2.getDiagnostics());
        BaseSegmentInfoFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> info2.getDiagnostics().put("bogus", "bogus"));
        dir.close();
    }

    public void testAttributes() throws Exception {
        BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("key1", "value1");
        attributes.put("key2", "value2");
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, attributes, null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
        BaseSegmentInfoFormatTestCase.assertEquals(attributes, (Object)info2.getAttributes());
        BaseSegmentInfoFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> info2.getAttributes().put("bogus", "bogus"));
        dir.close();
    }

    public void testUniqueID() throws Exception {
        Codec codec = this.getCodec();
        BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, new HashMap(), null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
        this.assertIDEquals(id, info2.getId());
        dir.close();
    }

    public void testVersions() throws Exception {
        Codec codec = this.getCodec();
        for (Version v : this.getVersions()) {
            BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
            byte[] id = StringHelper.randomId();
            SegmentInfo info = new SegmentInfo((Directory)dir, v, "_123", 1, false, codec, Collections.emptyMap(), id, new HashMap(), null);
            info.setFiles(Collections.emptySet());
            codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
            SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
            BaseSegmentInfoFormatTestCase.assertEquals((Object)info2.getVersion(), (Object)v);
            dir.close();
        }
    }

    protected boolean supportsIndexSort() {
        return true;
    }

    public void testSort() throws IOException {
        BaseSegmentInfoFormatTestCase.assumeTrue("test requires a codec that can read/write index sort", this.supportsIndexSort());
        int iters = BaseSegmentInfoFormatTestCase.atLeast(5);
        for (int i = 0; i < iters; ++i) {
            Sort sort;
            if (i == 0) {
                sort = null;
            } else {
                int numSortFields = TestUtil.nextInt(BaseSegmentInfoFormatTestCase.random(), 1, 3);
                SortField[] sortFields = new SortField[numSortFields];
                block5: for (int j = 0; j < numSortFields; ++j) {
                    sortFields[j] = new SortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), BaseSegmentInfoFormatTestCase.random().nextBoolean() ? SortField.Type.LONG : SortField.Type.STRING, BaseSegmentInfoFormatTestCase.random().nextBoolean());
                    if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) continue;
                    switch (sortFields[j].getType()) {
                        case LONG: {
                            sortFields[j].setMissingValue((Object)BaseSegmentInfoFormatTestCase.random().nextLong());
                            continue block5;
                        }
                        case STRING: {
                            sortFields[j].setMissingValue(BaseSegmentInfoFormatTestCase.random().nextBoolean() ? SortField.STRING_FIRST : SortField.STRING_LAST);
                            continue block5;
                        }
                        default: {
                            BaseSegmentInfoFormatTestCase.fail();
                        }
                    }
                }
                sort = new Sort(sortFields);
            }
            BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
            Codec codec = this.getCodec();
            byte[] id = StringHelper.randomId();
            SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, new HashMap(), sort);
            info.setFiles(Collections.emptySet());
            codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
            SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
            BaseSegmentInfoFormatTestCase.assertEquals((Object)sort, (Object)info2.getIndexSort());
            dir.close();
        }
    }

    public void testExceptionOnCreateOutput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    if (!this.doFail || !"createOutput".equals(e.getMethodName())) continue;
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, new HashMap(), null);
        info.setFiles(Collections.emptySet());
        fail.setDoFail();
        BaseSegmentInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnCloseOutput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    if (!this.doFail || !"close".equals(e.getMethodName())) continue;
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, new HashMap(), null);
        info.setFiles(Collections.emptySet());
        fail.setDoFail();
        BaseSegmentInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnOpenInput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    if (!this.doFail || !"openInput".equals(e.getMethodName())) continue;
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, new HashMap(), null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        fail.setDoFail();
        BaseSegmentInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnCloseInput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    if (!this.doFail || !"close".equals(e.getMethodName())) continue;
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, new HashMap(), null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        fail.setDoFail();
        BaseSegmentInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testRandom() throws Exception {
        Codec codec = this.getCodec();
        Version[] versions = this.getVersions();
        for (int i = 0; i < 10; ++i) {
            BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
            Version version = versions[BaseSegmentInfoFormatTestCase.random().nextInt(versions.length)];
            String name = "_" + Integer.toString(BaseSegmentInfoFormatTestCase.random().nextInt(Integer.MAX_VALUE), 36);
            int docCount = TestUtil.nextInt(BaseSegmentInfoFormatTestCase.random(), 1, 0x7FFFFF7F);
            boolean isCompoundFile = BaseSegmentInfoFormatTestCase.random().nextBoolean();
            HashSet<String> files = new HashSet<String>();
            int numFiles = BaseSegmentInfoFormatTestCase.random().nextInt(10);
            for (int j = 0; j < numFiles; ++j) {
                String file = IndexFileNames.segmentFileName((String)name, (String)"", (String)Integer.toString(j));
                files.add(file);
                dir.createOutput(file, IOContext.DEFAULT).close();
            }
            HashMap<String, String> diagnostics = new HashMap<String, String>();
            int numDiags = BaseSegmentInfoFormatTestCase.random().nextInt(10);
            for (int j = 0; j < numDiags; ++j) {
                diagnostics.put(TestUtil.randomUnicodeString(BaseSegmentInfoFormatTestCase.random()), TestUtil.randomUnicodeString(BaseSegmentInfoFormatTestCase.random()));
            }
            byte[] id = new byte[16];
            BaseSegmentInfoFormatTestCase.random().nextBytes(id);
            HashMap<String, String> attributes = new HashMap<String, String>();
            int numAttributes = BaseSegmentInfoFormatTestCase.random().nextInt(10);
            for (int j = 0; j < numAttributes; ++j) {
                attributes.put(TestUtil.randomUnicodeString(BaseSegmentInfoFormatTestCase.random()), TestUtil.randomUnicodeString(BaseSegmentInfoFormatTestCase.random()));
            }
            SegmentInfo info = new SegmentInfo((Directory)dir, version, name, docCount, isCompoundFile, codec, diagnostics, id, attributes, null);
            info.setFiles(files);
            codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
            SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, name, id, IOContext.DEFAULT);
            this.assertEquals(info, info2);
            dir.close();
        }
    }

    protected final void assertEquals(SegmentInfo expected, SegmentInfo actual) {
        BaseSegmentInfoFormatTestCase.assertSame((Object)expected.dir, (Object)actual.dir);
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.name, (Object)actual.name);
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.files(), (Object)actual.files());
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.getDiagnostics(), (Object)actual.getDiagnostics());
        BaseSegmentInfoFormatTestCase.assertEquals((long)expected.maxDoc(), (long)actual.maxDoc());
        this.assertIDEquals(expected.getId(), actual.getId());
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.getUseCompoundFile(), (Object)actual.getUseCompoundFile());
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.getVersion(), (Object)actual.getVersion());
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.getAttributes(), (Object)actual.getAttributes());
    }

    protected abstract Version[] getVersions();

    @Deprecated
    protected void assertIDEquals(byte[] expected, byte[] actual) {
        BaseSegmentInfoFormatTestCase.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Override
    protected void addRandomFields(Document doc) {
        doc.add((IndexableField)new StoredField("foobar", TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random())));
    }

    @Override
    public void testRamBytesUsed() throws IOException {
        BaseSegmentInfoFormatTestCase.assumeTrue("not applicable for this format", true);
    }
}

