/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SuppressForbidden;

public final class RamUsageTester {
    public static long sizeOf(Object obj, Accumulator accumulator) {
        return RamUsageTester.measureObjectSize(obj, accumulator);
    }

    public static long sizeOf(Object obj) {
        return RamUsageTester.sizeOf(obj, new Accumulator());
    }

    public static String humanSizeOf(Object object) {
        return RamUsageEstimator.humanReadableUnits((long)RamUsageTester.sizeOf(object));
    }

    private static long measureObjectSize(Object root, Accumulator accumulator) {
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        IdentityHashMap classCache = new IdentityHashMap();
        ArrayList<Object> stack = new ArrayList<Object>();
        stack.add(root);
        long totalSize = 0L;
        while (!stack.isEmpty()) {
            final Object ob = stack.remove(stack.size() - 1);
            if (ob == null || seen.contains(ob)) continue;
            seen.add(ob);
            Class<?> obClazz = ob.getClass();
            assert (obClazz != null) : "jvm bug detected (Object.getClass() == null). please report this to your vendor";
            if (obClazz.isArray()) {
                long shallowSize = RamUsageEstimator.shallowSizeOf(ob);
                final int len = Array.getLength(ob);
                Class<?> componentClazz = obClazz.getComponentType();
                AbstractList<Object> values = componentClazz.isPrimitive() ? Collections.emptyList() : new AbstractList<Object>(){

                    @Override
                    public Object get(int index) {
                        return Array.get(ob, index);
                    }

                    @Override
                    public int size() {
                        return len;
                    }
                };
                totalSize += accumulator.accumulateArray(ob, shallowSize, (List<Object>)values, stack);
                continue;
            }
            try {
                ClassCache cachedInfo = (ClassCache)classCache.get(obClazz);
                if (cachedInfo == null) {
                    cachedInfo = RamUsageTester.createCacheEntry(obClazz);
                    classCache.put(obClazz, cachedInfo);
                }
                HashMap<Field, Object> fieldValues = new HashMap<Field, Object>();
                for (Field f : cachedInfo.referenceFields) {
                    fieldValues.put(f, f.get(ob));
                }
                totalSize += accumulator.accumulateObject(ob, cachedInfo.alignedShallowInstanceSize, fieldValues, stack);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Reflective field access failed?", e);
            }
        }
        seen.clear();
        stack.clear();
        classCache.clear();
        return totalSize;
    }

    @SuppressForbidden(reason="We need to access private fields of measured objects.")
    private static ClassCache createCacheEntry(Class<?> clazz) {
        return AccessController.doPrivileged(() -> {
            long shallowInstanceSize = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
            ArrayList<Field> referenceFields = new ArrayList<Field>(32);
            for (Class c = clazz; c != null; c = c.getSuperclass()) {
                Field[] fields;
                if (c == Class.class) continue;
                for (Field f : fields = c.getDeclaredFields()) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    shallowInstanceSize = RamUsageEstimator.adjustForField((long)shallowInstanceSize, (Field)f);
                    if (f.getType().isPrimitive()) continue;
                    f.setAccessible(true);
                    referenceFields.add(f);
                }
            }
            ClassCache cachedInfo = new ClassCache(RamUsageEstimator.alignObjectSize((long)shallowInstanceSize), referenceFields.toArray(new Field[referenceFields.size()]));
            return cachedInfo;
        });
    }

    private static final class ClassCache {
        public final long alignedShallowInstanceSize;
        public final Field[] referenceFields;

        public ClassCache(long alignedShallowInstanceSize, Field[] referenceFields) {
            this.alignedShallowInstanceSize = alignedShallowInstanceSize;
            this.referenceFields = referenceFields;
        }
    }

    public static class Accumulator {
        public long accumulateObject(Object o, long shallowSize, Map<Field, Object> fieldValues, Collection<Object> queue) {
            for (Object value : fieldValues.values()) {
                queue.add(value);
            }
            return shallowSize;
        }

        public long accumulateArray(Object array, long shallowSize, List<Object> values, Collection<Object> queue) {
            queue.addAll(values);
            return shallowSize;
        }
    }
}

