/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.AssertingWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;

public final class AssertingQuery
extends Query {
    private final Random random;
    private final Query in;

    public AssertingQuery(Random random, Query in) {
        this.random = random;
        this.in = in;
    }

    public static Query wrap(Random random, Query query) {
        return query instanceof AssertingQuery ? query : new AssertingQuery(random, query);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new AssertingWeight(new Random(this.random.nextLong()), this.in.createWeight(searcher, needsScores), needsScores);
    }

    public String toString(String field) {
        return this.in.toString(field);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AssertingQuery)) {
            return false;
        }
        AssertingQuery that = (AssertingQuery)((Object)obj);
        return this.in.equals((Object)that.in);
    }

    public int hashCode() {
        return -this.in.hashCode();
    }

    public Random getRandom() {
        return this.random;
    }

    public Query getIn() {
        return this.in;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.in.rewrite(reader);
        if (rewritten == this.in) {
            return super.rewrite(reader);
        }
        return AssertingQuery.wrap(new Random(this.random.nextLong()), rewritten);
    }
}

