/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.junit.Assert;

public abstract class BaseDocValuesFormatTestCase
extends BaseIndexFileFormatTestCase {
    @Override
    protected void addRandomFields(Document doc) {
        int i;
        int numValues;
        if (BaseDocValuesFormatTestCase.usually()) {
            doc.add((IndexableField)new NumericDocValuesField("ndv", (long)BaseDocValuesFormatTestCase.random().nextInt(4096)));
            doc.add((IndexableField)new BinaryDocValuesField("bdv", new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random()))));
            doc.add((IndexableField)new SortedDocValuesField("sdv", new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random(), 2))));
        }
        if (this.codecSupportsSortedSet()) {
            numValues = BaseDocValuesFormatTestCase.random().nextInt(5);
            for (i = 0; i < numValues; ++i) {
                doc.add((IndexableField)new SortedSetDocValuesField("ssdv", new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random(), 2))));
            }
        }
        if (this.codecSupportsSortedNumeric()) {
            numValues = BaseDocValuesFormatTestCase.random().nextInt(5);
            for (i = 0; i < numValues; ++i) {
                doc.add((IndexableField)new SortedNumericDocValuesField("sndv", TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE)));
            }
        }
    }

    public void testOneNumber() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv", 5L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.get(hits.scoreDocs[i].doc));
        }
        ireader.close();
        directory.close();
    }

    public void testOneFloat() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new FloatDocValuesField("dv", 5.7f));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
            BaseDocValuesFormatTestCase.assertEquals((long)Float.floatToRawIntBits(5.7f), (long)dv.get(hits.scoreDocs[i].doc));
        }
        ireader.close();
        directory.close();
    }

    public void testTwoNumbers() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        doc.add((IndexableField)new NumericDocValuesField("dv2", 17L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv1");
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.get(hits.scoreDocs[i].doc));
            dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv2");
            BaseDocValuesFormatTestCase.assertEquals((long)17L, (long)dv.get(hits.scoreDocs[i].doc));
        }
        ireader.close();
        directory.close();
    }

    public void testTwoBinaryValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef((CharSequence)longTerm)));
        doc.add((IndexableField)new BinaryDocValuesField("dv2", new BytesRef((CharSequence)text)));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv1");
            BytesRef scratch = dv.get(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)longTerm), (Object)scratch);
            dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv2");
            scratch = dv.get(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)text), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testTwoFieldsMixed() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        doc.add((IndexableField)new BinaryDocValuesField("dv2", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv1");
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.get(hits.scoreDocs[i].doc));
            BinaryDocValues dv2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv2");
            BytesRef scratch = dv2.get(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testThreeFieldsMixed() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new SortedDocValuesField("dv1", new BytesRef((CharSequence)"hello hello")));
        doc.add((IndexableField)new NumericDocValuesField("dv2", 5L));
        doc.add((IndexableField)new BinaryDocValuesField("dv3", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv1");
            int ord = dv.getOrd(0);
            BytesRef scratch = dv.lookupOrd(ord);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello hello"), (Object)scratch);
            NumericDocValues dv2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv2");
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv2.get(hits.scoreDocs[i].doc));
            BinaryDocValues dv3 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv3");
            scratch = dv3.get(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testThreeFieldsMixed2() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef((CharSequence)"hello world")));
        doc.add((IndexableField)new SortedDocValuesField("dv2", new BytesRef((CharSequence)"hello hello")));
        doc.add((IndexableField)new NumericDocValuesField("dv3", 5L));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv2");
            int ord = dv.getOrd(0);
            scratch = dv.lookupOrd(ord);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello hello"), (Object)scratch);
            NumericDocValues dv2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv3");
            BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv2.get(hits.scoreDocs[i].doc));
            BinaryDocValues dv3 = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv1");
            scratch = dv3.get(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testTwoDocumentsNumeric() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 1L));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 2L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.get(0));
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.get(1));
        ireader.close();
        directory.close();
    }

    public void testTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new NumericDocValuesField("dv", -10L));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new NumericDocValuesField("dv", 99L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        for (int i = 0; i < 2; ++i) {
            Document doc2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().document(i);
            long expected = doc2.get("id").equals("0") ? -10L : 99L;
            BaseDocValuesFormatTestCase.assertEquals((long)expected, (long)dv.get(i));
        }
        ireader.close();
        directory.close();
    }

    public void testBigNumericRange() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", Long.MIN_VALUE));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", Long.MAX_VALUE));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)Long.MIN_VALUE, (long)dv.get(0));
        BaseDocValuesFormatTestCase.assertEquals((long)Long.MAX_VALUE, (long)dv.get(1));
        ireader.close();
        directory.close();
    }

    public void testBigNumericRange2() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", -8841491950446638677L));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("dv", 9062230939892376225L));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        NumericDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getNumericDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)-8841491950446638677L, (long)dv.get(0));
        BaseDocValuesFormatTestCase.assertEquals((long)9062230939892376225L, (long)dv.get(1));
        ireader.close();
        directory.close();
    }

    public void testBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
            BytesRef scratch = dv.get(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testBytesTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < 2; ++i) {
            Document doc2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().document(i);
            String expected = doc2.get("id").equals("0") ? "hello world 1" : "hello 2";
            scratch = dv.get(i);
            BaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)scratch.utf8ToString());
        }
        ireader.close();
        directory.close();
    }

    public void testBytesMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new BinaryDocValuesField("field", new BytesRef((CharSequence)"hi")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        BinaryDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getBinaryDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)dv.get(0));
        ireader.close();
        directory.close();
    }

    public void testSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        String longTerm = "longtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongtermlongterm";
        String text = "This is the text to be indexed. " + longTerm;
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("fieldname", text, Field.Store.YES));
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)isearcher.search((Query)new TermQuery((Term)new Term((String)"fieldname", (String)longTerm)), (int)1).totalHits);
        TermQuery query = new TermQuery(new Term("fieldname", "text"));
        TopDocs hits = isearcher.search((Query)query, 1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)hits.totalHits);
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            Document hitDoc = isearcher.doc(hits.scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((Object)text, (Object)hitDoc.get("fieldname"));
            assert (ireader.leaves().size() == 1);
            SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
            scratch = dv.lookupOrd(dv.getOrd(hits.scoreDocs[i].doc));
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world"), (Object)scratch);
        }
        ireader.close();
        directory.close();
    }

    public void testSortedBytesTwoDocuments() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BytesRef scratch = new BytesRef();
        scratch = dv.lookupOrd(dv.getOrd(0));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 1", (Object)scratch.utf8ToString());
        scratch = dv.lookupOrd(dv.getOrd(1));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 2", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testSortedBytesThreeDocuments() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getOrd(0));
        BytesRef scratch = dv.lookupOrd(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 1", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getOrd(1));
        scratch = dv.lookupOrd(1);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello world 2", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getOrd(2));
        ireader.close();
        directory.close();
    }

    public void testSortedBytesTwoDocumentsMerged() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "0", StringField.TYPE_STORED));
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 1")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)BaseDocValuesFormatTestCase.newField("id", "1", StringField.TYPE_STORED));
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        BytesRef scratch = dv.lookupOrd(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world 1"), (Object)scratch);
        scratch = dv.lookupOrd(1);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world 2"), (Object)scratch);
        for (int i = 0; i < 2; ++i) {
            Document doc2 = ((LeafReaderContext)ireader.leaves().get(0)).reader().document(i);
            String expected = doc2.get("id").equals("0") ? "hello world 1" : "hello world 2";
            scratch = dv.lookupOrd(dv.getOrd(i));
            BaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)scratch.utf8ToString());
        }
        ireader.close();
        directory.close();
    }

    public void testSortedMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedDocValues("field");
        if (this.codecSupportsDocsWithField()) {
            BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.getOrd(0));
            BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getValueCount());
        } else {
            BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getOrd(0));
            BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
            BytesRef ref = dv.lookupOrd(0);
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)ref);
        }
        ireader.close();
        directory.close();
    }

    public void testBytesWithNewline() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"hello\nworld\r1")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BytesRef scratch = dv.get(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello\nworld\r1"), (Object)scratch);
        ireader.close();
        directory.close();
    }

    public void testMissingSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"hello world 2")));
        iwriter.addDocument(doc);
        iwriter.addDocument(new Document());
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BytesRef scratch = dv.lookupOrd(dv.getOrd(0));
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello world 2"), (Object)scratch);
        if (this.codecSupportsDocsWithField()) {
            BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.getOrd(1));
        }
        scratch = dv.get(1);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)""), (Object)scratch);
        ireader.close();
        directory.close();
    }

    public void testSortedTermsEnum() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"beer")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        TermsEnum termsEnum = dv.termsEnum();
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"ha!")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"beer")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"zzz")));
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"aba")));
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"beer")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"hello")));
        BaseDocValuesFormatTestCase.assertEquals((String)Codec.getDefault().toString(), (Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"world")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"bogus")));
        termsEnum.seekExact(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        termsEnum.seekExact(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        termsEnum.seekExact(2L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        ireader.close();
        directory.close();
    }

    public void testEmptySortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getOrd(0));
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getOrd(1));
        BytesRef scratch = dv.lookupOrd(dv.getOrd(0));
        BaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testEmptyBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BytesRef scratch = dv.get(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)scratch.utf8ToString());
        scratch = dv.get(1);
        BaseDocValuesFormatTestCase.assertEquals((Object)"", (Object)scratch.utf8ToString());
        ireader.close();
        directory.close();
    }

    public void testVeryLargeButLegalBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        byte[] bytes = new byte[32766];
        BytesRef b = new BytesRef(bytes);
        BaseDocValuesFormatTestCase.random().nextBytes(bytes);
        doc.add((IndexableField)new BinaryDocValuesField("dv", b));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        BytesRef scratch = dv.get(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(bytes), (Object)scratch);
        ireader.close();
        directory.close();
    }

    public void testVeryLargeButLegalSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        byte[] bytes = new byte[32766];
        BytesRef b = new BytesRef(bytes);
        BaseDocValuesFormatTestCase.random().nextBytes(bytes);
        doc.add((IndexableField)new SortedDocValuesField("dv", b));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        BytesRef scratch = dv.get(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(bytes), (Object)scratch);
        ireader.close();
        directory.close();
    }

    public void testCodecUsesOwnBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("dv", new BytesRef((CharSequence)"boo!")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        BinaryDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getBinaryDocValues("dv");
        byte[] mybytes = new byte[20];
        BytesRef scratch = dv.get(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)"boo!", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertFalse((scratch.bytes == mybytes ? 1 : 0) != 0);
        ireader.close();
        directory.close();
    }

    public void testCodecUsesOwnSortedBytes() throws IOException {
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new SortedDocValuesField("dv", new BytesRef((CharSequence)"boo!")));
        iwriter.addDocument(doc);
        iwriter.close();
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        assert (ireader.leaves().size() == 1);
        SortedDocValues dv = ((LeafReaderContext)ireader.leaves().get(0)).reader().getSortedDocValues("dv");
        byte[] mybytes = new byte[20];
        BytesRef scratch = dv.get(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)"boo!", (Object)scratch.utf8ToString());
        BaseDocValuesFormatTestCase.assertFalse((scratch.bytes == mybytes ? 1 : 0) != 0);
        ireader.close();
        directory.close();
    }

    public void testDocValuesSimple() throws IOException {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        IndexWriter writer = new IndexWriter((Directory)dir, conf);
        for (int i = 0; i < 5; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)new NumericDocValuesField("docId", (long)i));
            doc.add((IndexableField)new TextField("docId", "" + i, Field.Store.NO));
            writer.addDocument((Iterable)doc);
        }
        writer.commit();
        writer.forceMerge(1, true);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)reader.leaves().size());
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.add((Query)new TermQuery(new Term("docId", "0")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "1")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "2")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "3")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("docId", "4")), BooleanClause.Occur.SHOULD);
        TopDocs search = searcher.search((Query)query.build(), 10);
        BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)search.totalHits);
        ScoreDoc[] scoreDocs = search.scoreDocs;
        NumericDocValues docValues = BaseDocValuesFormatTestCase.getOnlySegmentReader(reader).getNumericDocValues("docId");
        for (int i = 0; i < scoreDocs.length; ++i) {
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)scoreDocs[i].doc);
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)docValues.get(scoreDocs[i].doc));
        }
        reader.close();
        dir.close();
    }

    public void testRandomSortedBytes() throws IOException {
        Document doc;
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig cfg = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        if (!this.codecSupportsDocsWithField()) {
            cfg.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        }
        RandomIndexWriter w = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, cfg);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(100);
        BytesRefHash hash = new BytesRefHash();
        HashMap<String, String> docToString = new HashMap<String, String>();
        int maxLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 50);
        for (int i = 0; i < numDocs; ++i) {
            Document doc2 = new Document();
            doc2.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("id", "" + i, Field.Store.YES));
            String string = TestUtil.randomRealisticUnicodeString(BaseDocValuesFormatTestCase.random(), 1, maxLength);
            BytesRef br = new BytesRef((CharSequence)string);
            doc2.add((IndexableField)new SortedDocValuesField("field", br));
            hash.add(br);
            docToString.put("" + i, string);
            w.addDocument(doc2);
        }
        if (BaseDocValuesFormatTestCase.rarely()) {
            w.commit();
        }
        int numDocsNoValue = BaseDocValuesFormatTestCase.atLeast(10);
        for (int i = 0; i < numDocsNoValue; ++i) {
            doc = new Document();
            doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("id", "noValue", Field.Store.YES));
            w.addDocument(doc);
        }
        if (!this.codecSupportsDocsWithField()) {
            BytesRef bytesRef = new BytesRef();
            hash.add(bytesRef);
        }
        if (BaseDocValuesFormatTestCase.rarely()) {
            w.commit();
        }
        if (!this.codecSupportsDocsWithField()) {
            w.forceMerge(1);
        }
        for (int i = 0; i < numDocs; ++i) {
            doc = new Document();
            String id = "" + i + numDocs;
            doc.add((IndexableField)BaseDocValuesFormatTestCase.newTextField("id", id, Field.Store.YES));
            String string = TestUtil.randomRealisticUnicodeString(BaseDocValuesFormatTestCase.random(), 1, maxLength);
            BytesRef br = new BytesRef((CharSequence)string);
            hash.add(br);
            docToString.put(id, string);
            doc.add((IndexableField)new SortedDocValuesField("field", br));
            w.addDocument(doc);
        }
        w.commit();
        DirectoryReader reader = w.getReader();
        SortedDocValues docValues = MultiDocValues.getSortedValues((IndexReader)reader, (String)"field");
        int[] sort = hash.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
        BytesRef expected = new BytesRef();
        BaseDocValuesFormatTestCase.assertEquals((long)hash.size(), (long)docValues.getValueCount());
        for (int i = 0; i < hash.size(); ++i) {
            hash.get(sort[i], expected);
            BytesRef actual = docValues.lookupOrd(i);
            BaseDocValuesFormatTestCase.assertEquals((Object)expected.utf8ToString(), (Object)actual.utf8ToString());
            int ord = docValues.lookupTerm(expected);
            BaseDocValuesFormatTestCase.assertEquals((long)i, (long)ord);
        }
        LeafReader slowR = SlowCompositeReaderWrapper.wrap((IndexReader)reader);
        Set entrySet = docToString.entrySet();
        for (Map.Entry entry : entrySet) {
            PostingsEnum termPostingsEnum = slowR.postings(new Term("id", (String)entry.getKey()));
            int docId = termPostingsEnum.nextDoc();
            expected = new BytesRef((CharSequence)entry.getValue());
            BytesRef actual = docValues.get(docId);
            BaseDocValuesFormatTestCase.assertEquals((Object)expected, (Object)actual);
        }
        reader.close();
        w.close();
        dir.close();
    }

    private void doTestNumericsVsStoredFields(final long minValue, final long maxValue) throws Exception {
        this.doTestNumericsVsStoredFields(new LongProducer(){

            @Override
            long next() {
                return TestUtil.nextLong(LuceneTestCase.random(), minValue, maxValue);
            }
        });
    }

    private void doTestNumericsVsStoredFields(LongProducer longs) throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        Field storedField = BaseDocValuesFormatTestCase.newStringField("stored", "", Field.Store.YES);
        NumericDocValuesField dvField = new NumericDocValuesField("dv", 0L);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(300);
        assert (numDocs > 256);
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            long value = longs.next();
            storedField.setStringValue(Long.toString(value));
            dvField.setLongValue(value);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.forceMerge(numDocs / 256);
        writer.close();
        DirectoryReader ir = DirectoryReader.open((Directory)dir);
        for (LeafReaderContext context : ir.leaves()) {
            LeafReader r = context.reader();
            NumericDocValues docValues = r.getNumericDocValues("dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                long storedValue = Long.parseLong(r.document(i).get("stored"));
                BaseDocValuesFormatTestCase.assertEquals((long)storedValue, (long)docValues.get(i));
            }
        }
        ir.close();
        dir.close();
    }

    private void doTestSortedNumericsVsStoredFields(LongProducer counts, LongProducer values) throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(300);
        assert (numDocs > 256);
        for (int i = 0; i < numDocs; ++i) {
            int j;
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", Integer.toString(i), Field.Store.NO));
            int valueCount = (int)counts.next();
            long[] valueArray = new long[valueCount];
            for (j = 0; j < valueCount; ++j) {
                long value;
                valueArray[j] = value = values.next();
                doc.add((IndexableField)new SortedNumericDocValuesField("dv", value));
            }
            Arrays.sort(valueArray);
            for (j = 0; j < valueCount; ++j) {
                doc.add((IndexableField)new StoredField("stored", Long.toString(valueArray[j])));
            }
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.forceMerge(numDocs / 256);
        writer.close();
        DirectoryReader ir = DirectoryReader.open((Directory)dir);
        for (LeafReaderContext context : ir.leaves()) {
            LeafReader r = context.reader();
            SortedNumericDocValues docValues = DocValues.getSortedNumeric((LeafReader)r, (String)"dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                Object[] expected = r.document(i).getValues("stored");
                docValues.setDocument(i);
                Object[] actual = new String[docValues.count()];
                for (int j = 0; j < actual.length; ++j) {
                    actual[j] = Long.toString(docValues.valueAt(j));
                }
                BaseDocValuesFormatTestCase.assertArrayEquals((Object[])expected, (Object[])actual);
            }
        }
        ir.close();
        dir.close();
    }

    public void testBooleanNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(0L, 1L);
        }
    }

    public void testByteNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(-128L, 127L);
        }
    }

    public void testShortNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(-32768L, 32767L);
        }
    }

    public void testIntNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }

    public void testLongNumericsVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestNumericsVsStoredFields(Long.MIN_VALUE, Long.MAX_VALUE);
        }
    }

    private void doTestBinaryVsStoredFields(int minLength, int maxLength) throws Exception {
        BytesRef scratch;
        BytesRef binaryValue;
        int i;
        BinaryDocValues docValues;
        LeafReader r;
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedField = new StoredField("stored", new byte[0]);
        BinaryDocValuesField dvField = new BinaryDocValuesField("dv", new BytesRef());
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(300);
        for (int i2 = 0; i2 < numDocs; ++i2) {
            idField.setStringValue(Integer.toString(i2));
            int length = minLength == maxLength ? minLength : TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), minLength, maxLength);
            byte[] buffer = new byte[length];
            BaseDocValuesFormatTestCase.random().nextBytes(buffer);
            storedField.setBytesValue(buffer);
            dvField.setBytesValue(buffer);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i3 = 0; i3 < numDeletions; ++i3) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        DirectoryReader ir = writer.getReader();
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getBinaryDocValues("dv");
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = r.document(i).getBinaryValue("stored");
                scratch = docValues.get(i);
                BaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)scratch);
            }
        }
        ir.close();
        writer.forceMerge(1);
        ir = writer.getReader();
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getBinaryDocValues("dv");
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = r.document(i).getBinaryValue("stored");
                scratch = docValues.get(i);
                BaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)scratch);
            }
        }
        ir.close();
        writer.close();
        dir.close();
    }

    public void testBinaryFixedLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 0, 10);
            this.doTestBinaryVsStoredFields(fixedLength, fixedLength);
        }
    }

    public void testBinaryVariableLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestBinaryVsStoredFields(0, 10);
        }
    }

    protected void doTestSortedVsStoredFields(int numDocs, int minLength, int maxLength) throws Exception {
        BytesRef scratch;
        BytesRef binaryValue;
        int i;
        SortedDocValues docValues;
        LeafReader r;
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newFSDirectory(BaseDocValuesFormatTestCase.createTempDir("dvduel"));
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedField = new StoredField("stored", new byte[0]);
        SortedDocValuesField dvField = new SortedDocValuesField("dv", new BytesRef());
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        for (int i2 = 0; i2 < numDocs; ++i2) {
            idField.setStringValue(Integer.toString(i2));
            int length = minLength == maxLength ? minLength : TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), minLength, maxLength);
            byte[] buffer = new byte[length];
            BaseDocValuesFormatTestCase.random().nextBytes(buffer);
            storedField.setBytesValue(buffer);
            dvField.setBytesValue(buffer);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i3 = 0; i3 < numDeletions; ++i3) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        DirectoryReader ir = writer.getReader();
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getSortedDocValues("dv");
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = r.document(i).getBinaryValue("stored");
                scratch = docValues.get(i);
                BaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)scratch);
            }
        }
        ir.close();
        writer.forceMerge(1);
        ir = writer.getReader();
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getSortedDocValues("dv");
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = r.document(i).getBinaryValue("stored");
                scratch = docValues.get(i);
                BaseDocValuesFormatTestCase.assertEquals((Object)binaryValue, (Object)scratch);
            }
        }
        ir.close();
        writer.close();
        dir.close();
    }

    public void testSortedFixedLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), fixedLength, fixedLength);
        }
    }

    public void testSortedVariableLengthVsStoredFields() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 1, 10);
        }
    }

    public void testSortedSetOneValue() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoFields() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field2", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field2");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsMerged() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.getValueCount());
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        bytes = dv.lookupOrd(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoValues() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        bytes = dv.lookupOrd(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoValuesUnordered() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        bytes = dv.lookupOrd(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetThreeValuesTwoDocs() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"beer")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"beer"), (Object)bytes);
        bytes = dv.lookupOrd(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        bytes = dv.lookupOrd(2L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"world"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsLastMissing() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        doc = new Document();
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsLastMissingMerge() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsFirstMissing() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetTwoDocumentsFirstMissingMerge() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        iwriter.addDocument(doc);
        iwriter.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.getValueCount());
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.nextOrd());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        BytesRef bytes = dv.lookupOrd(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"hello"), (Object)bytes);
        ireader.close();
        directory.close();
    }

    public void testSortedSetMergeAwayAllValues() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getValueCount());
        ireader.close();
        directory.close();
    }

    public void testSortedSetTermsEnum() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"world")));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"beer")));
        iwriter.addDocument(doc);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)3L, (long)dv.getValueCount());
        TermsEnum termsEnum = dv.termsEnum();
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.next().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.NOT_FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"ha!")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.FOUND, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"beer")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"zzz")));
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"beer")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"hello")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"world")));
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        BaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"bogus")));
        termsEnum.seekExact(0L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"beer", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)termsEnum.ord());
        termsEnum.seekExact(1L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"hello", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)termsEnum.ord());
        termsEnum.seekExact(2L);
        BaseDocValuesFormatTestCase.assertEquals((Object)"world", (Object)termsEnum.term().utf8ToString());
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)termsEnum.ord());
        ireader.close();
        directory.close();
    }

    protected void doTestSortedSetVsStoredFields(int numDocs, int minLength, int maxLength, int maxValuesPerDoc, int maxUniqueValues) throws Exception {
        BytesRef scratch;
        long ord;
        int j;
        String[] stringValues;
        SortedSetDocValues docValues;
        LeafReader r;
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newFSDirectory(BaseDocValuesFormatTestCase.createTempDir("dvduel"));
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        HashSet<String> valueSet = new HashSet<String>();
        for (int i = 0; i < 10000 && valueSet.size() < maxUniqueValues; ++i) {
            int length = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), minLength, maxLength);
            valueSet.add(TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random(), length));
        }
        Object[] uniqueValues = valueSet.toArray(new String[0]);
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            StringField idField = new StringField("id", Integer.toString(i), Field.Store.NO);
            doc.add((IndexableField)idField);
            int numValues = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 0, maxValuesPerDoc);
            TreeSet<Object> values = new TreeSet<Object>();
            for (int v = 0; v < numValues; ++v) {
                values.add(RandomPicks.randomFrom((Random)BaseDocValuesFormatTestCase.random(), (Object[])uniqueValues));
            }
            for (String string : values) {
                doc.add((IndexableField)new StoredField("stored", string));
            }
            ArrayList unordered = new ArrayList(values);
            Collections.shuffle(unordered, BaseDocValuesFormatTestCase.random());
            for (String v : unordered) {
                doc.add((IndexableField)new SortedSetDocValuesField("dv", new BytesRef((CharSequence)v)));
            }
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        DirectoryReader ir = writer.getReader();
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getSortedSetDocValues("dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                stringValues = r.document(i).getValues("stored");
                if (docValues != null) {
                    docValues.setDocument(i);
                }
                for (j = 0; j < stringValues.length; ++j) {
                    assert (docValues != null);
                    ord = docValues.nextOrd();
                    assert (ord != -1L);
                    scratch = docValues.lookupOrd(ord);
                    BaseDocValuesFormatTestCase.assertEquals((Object)stringValues[j], (Object)scratch.utf8ToString());
                }
                assert (docValues == null || docValues.nextOrd() == -1L);
            }
        }
        ir.close();
        writer.forceMerge(1);
        ir = writer.getReader();
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getSortedSetDocValues("dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                stringValues = r.document(i).getValues("stored");
                if (docValues != null) {
                    docValues.setDocument(i);
                }
                for (j = 0; j < stringValues.length; ++j) {
                    assert (docValues != null);
                    ord = docValues.nextOrd();
                    assert (ord != -1L);
                    scratch = docValues.lookupOrd(ord);
                    BaseDocValuesFormatTestCase.assertEquals((Object)stringValues[j], (Object)scratch.utf8ToString());
                }
                assert (docValues == null || docValues.nextOrd() == -1L);
            }
        }
        ir.close();
        writer.close();
        dir.close();
    }

    public void testSortedSetFixedLengthVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), fixedLength, fixedLength, 16, 100);
        }
    }

    public void testSortedNumericsSingleValuedVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(new LongProducer(){

                @Override
                long next() {
                    return 1L;
                }
            }, new LongProducer(){

                @Override
                long next() {
                    return TestUtil.nextLong(LuceneTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE);
                }
            });
        }
    }

    public void testSortedNumericsSingleValuedMissingVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(new LongProducer(){

                @Override
                long next() {
                    return LuceneTestCase.random().nextBoolean() ? 0L : 1L;
                }
            }, new LongProducer(){

                @Override
                long next() {
                    return TestUtil.nextLong(LuceneTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE);
                }
            });
        }
    }

    public void testSortedNumericsMultipleValuesVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(new LongProducer(){

                @Override
                long next() {
                    return TestUtil.nextLong(LuceneTestCase.random(), 0L, 50L);
                }
            }, new LongProducer(){

                @Override
                long next() {
                    return TestUtil.nextLong(LuceneTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE);
                }
            });
        }
    }

    public void testSortedNumericsFewUniqueSetsVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        final long[] values = new long[TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 2, 6)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = BaseDocValuesFormatTestCase.random().nextLong();
        }
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedNumericsVsStoredFields(new LongProducer(){

                @Override
                long next() {
                    return TestUtil.nextLong(LuceneTestCase.random(), 0L, 6L);
                }
            }, new LongProducer(){

                @Override
                long next() {
                    return values[LuceneTestCase.random().nextInt(values.length)];
                }
            });
        }
    }

    public void testSortedSetVariableLengthVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 1, 10, 16, 100);
        }
    }

    public void testSortedSetFixedLengthSingleValuedVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            int fixedLength = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1, 10);
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), fixedLength, fixedLength, 1, 100);
        }
    }

    public void testSortedSetVariableLengthSingleValuedVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 1, 10, 1, 100);
        }
    }

    public void testSortedSetFixedLengthFewUniqueSetsVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 10, 10, 6, 6);
        }
    }

    public void testSortedSetVariableLengthFewUniqueSetsVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(300), 1, 10, 6, 6);
        }
    }

    public void testSortedSetVariableLengthManyValuesPerDocVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(20), 1, 10, 500, 1000);
        }
    }

    public void testSortedSetFixedLengthManyValuesPerDocVsStoredFields() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            this.doTestSortedSetVsStoredFields(BaseDocValuesFormatTestCase.atLeast(20), 10, 10, 500, 1000);
        }
    }

    public void testGCDCompression() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            final long min = -((long)BaseDocValuesFormatTestCase.random().nextInt(0x40000000) << 32);
            final long mul = (long)BaseDocValuesFormatTestCase.random().nextInt() & 0xFFFFFFFFL;
            LongProducer longs = new LongProducer(){

                @Override
                long next() {
                    return min + mul * (long)LuceneTestCase.random().nextInt(0x100000);
                }
            };
            this.doTestNumericsVsStoredFields(longs);
        }
    }

    public void testZeros() throws Exception {
        this.doTestNumericsVsStoredFields(0L, 0L);
    }

    public void testZeroOrMin() throws Exception {
        int numIterations = BaseDocValuesFormatTestCase.atLeast(1);
        for (int i = 0; i < numIterations; ++i) {
            LongProducer longs = new LongProducer(){

                @Override
                long next() {
                    return LuceneTestCase.random().nextBoolean() ? 0L : Long.MIN_VALUE;
                }
            };
            this.doTestNumericsVsStoredFields(longs);
        }
    }

    public void testTwoNumbersOneMissing() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support getDocsWithField", this.codecSupportsDocsWithField());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 0L));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        NumericDocValues dv = ar.getNumericDocValues("dv1");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.get(0));
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.get(1));
        Bits docsWithField = ar.getDocsWithField("dv1");
        BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(0));
        BaseDocValuesFormatTestCase.assertFalse((boolean)docsWithField.get(1));
        ir.close();
        directory.close();
    }

    public void testTwoNumbersOneMissingWithMerging() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support getDocsWithField", this.codecSupportsDocsWithField());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 0L));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        NumericDocValues dv = ar.getNumericDocValues("dv1");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.get(0));
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.get(1));
        Bits docsWithField = ar.getDocsWithField("dv1");
        BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(0));
        BaseDocValuesFormatTestCase.assertFalse((boolean)docsWithField.get(1));
        ir.close();
        directory.close();
    }

    public void testThreeNumbersOneMissingWithMerging() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support getDocsWithField", this.codecSupportsDocsWithField());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 0L));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "2", Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("dv1", 5L));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        NumericDocValues dv = ar.getNumericDocValues("dv1");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.get(0));
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.get(1));
        BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.get(2));
        Bits docsWithField = ar.getDocsWithField("dv1");
        BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(0));
        BaseDocValuesFormatTestCase.assertFalse((boolean)docsWithField.get(1));
        BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(2));
        ir.close();
        directory.close();
    }

    public void testTwoBytesOneMissing() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support getDocsWithField", this.codecSupportsDocsWithField());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef()));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        BinaryDocValues dv = ar.getBinaryDocValues("dv1");
        BytesRef ref = dv.get(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)ref);
        ref = dv.get(1);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)ref);
        Bits docsWithField = ar.getDocsWithField("dv1");
        BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(0));
        BaseDocValuesFormatTestCase.assertFalse((boolean)docsWithField.get(1));
        ir.close();
        directory.close();
    }

    public void testTwoBytesOneMissingWithMerging() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support getDocsWithField", this.codecSupportsDocsWithField());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef()));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        BinaryDocValues dv = ar.getBinaryDocValues("dv1");
        BytesRef ref = dv.get(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)ref);
        ref = dv.get(1);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)ref);
        Bits docsWithField = ar.getDocsWithField("dv1");
        BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(0));
        BaseDocValuesFormatTestCase.assertFalse((boolean)docsWithField.get(1));
        ir.close();
        directory.close();
    }

    public void testThreeBytesOneMissingWithMerging() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support getDocsWithField", this.codecSupportsDocsWithField());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(null);
        conf.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, conf);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef()));
        iw.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.YES));
        iw.addDocument(doc);
        iw.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "2", Field.Store.YES));
        doc.add((IndexableField)new BinaryDocValuesField("dv1", new BytesRef((CharSequence)"boo")));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.close();
        DirectoryReader ir = DirectoryReader.open((Directory)directory);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ir.leaves().size());
        LeafReader ar = ((LeafReaderContext)ir.leaves().get(0)).reader();
        BinaryDocValues dv = ar.getBinaryDocValues("dv1");
        BytesRef ref = dv.get(0);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)ref);
        ref = dv.get(1);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)ref);
        ref = dv.get(2);
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"boo"), (Object)ref);
        Bits docsWithField = ar.getDocsWithField("dv1");
        BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(0));
        BaseDocValuesFormatTestCase.assertFalse((boolean)docsWithField.get(1));
        BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(2));
        ir.close();
        directory.close();
    }

    public void testThreads() throws Exception {
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedBinField = new StoredField("storedBin", new byte[0]);
        BinaryDocValuesField dvBinField = new BinaryDocValuesField("dvBin", new BytesRef());
        SortedDocValuesField dvSortedField = new SortedDocValuesField("dvSorted", new BytesRef());
        StoredField storedNumericField = new StoredField("storedNum", "");
        NumericDocValuesField dvNumericField = new NumericDocValuesField("dvNum", 0L);
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedBinField);
        doc.add((IndexableField)dvBinField);
        doc.add((IndexableField)dvSortedField);
        doc.add((IndexableField)storedNumericField);
        doc.add((IndexableField)dvNumericField);
        int numDocs = BaseDocValuesFormatTestCase.atLeast(300);
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            int length = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 0, 8);
            byte[] buffer = new byte[length];
            BaseDocValuesFormatTestCase.random().nextBytes(buffer);
            storedBinField.setBytesValue(buffer);
            dvBinField.setBytesValue(buffer);
            dvSortedField.setBytesValue(buffer);
            long numericValue = BaseDocValuesFormatTestCase.random().nextLong();
            storedNumericField.setStringValue(Long.toString(numericValue));
            dvNumericField.setLongValue(numericValue);
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.close();
        final DirectoryReader ir = DirectoryReader.open((Directory)dir);
        int numThreads = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 2, 7);
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        startingGun.await();
                        for (LeafReaderContext context : ir.leaves()) {
                            LeafReader r = context.reader();
                            BinaryDocValues binaries = r.getBinaryDocValues("dvBin");
                            SortedDocValues sorted = r.getSortedDocValues("dvSorted");
                            NumericDocValues numerics = r.getNumericDocValues("dvNum");
                            for (int j = 0; j < r.maxDoc(); ++j) {
                                BytesRef binaryValue = r.document(j).getBinaryValue("storedBin");
                                BytesRef scratch = binaries.get(j);
                                Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                scratch = sorted.get(j);
                                Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                String expected = r.document(j).get("storedNum");
                                Assert.assertEquals((long)Long.parseLong(expected), (long)numerics.get(j));
                            }
                        }
                        TestUtil.checkReader((IndexReader)ir);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[i].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
        ir.close();
        dir.close();
    }

    @LuceneTestCase.Slow
    public void testThreads2() throws Exception {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support getDocsWithField", this.codecSupportsDocsWithField());
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedBinField = new StoredField("storedBin", new byte[0]);
        BinaryDocValuesField dvBinField = new BinaryDocValuesField("dvBin", new BytesRef());
        SortedDocValuesField dvSortedField = new SortedDocValuesField("dvSorted", new BytesRef());
        StoredField storedNumericField = new StoredField("storedNum", "");
        NumericDocValuesField dvNumericField = new NumericDocValuesField("dvNum", 0L);
        int numDocs = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 1025, 2047);
        for (int i = 0; i < numDocs; ++i) {
            idField.setStringValue(Integer.toString(i));
            int length = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 0, 8);
            byte[] buffer = new byte[length];
            BaseDocValuesFormatTestCase.random().nextBytes(buffer);
            storedBinField.setBytesValue(buffer);
            dvBinField.setBytesValue(buffer);
            dvSortedField.setBytesValue(buffer);
            long numericValue = BaseDocValuesFormatTestCase.random().nextLong();
            storedNumericField.setStringValue(Long.toString(numericValue));
            dvNumericField.setLongValue(numericValue);
            Document doc = new Document();
            doc.add((IndexableField)idField);
            if (BaseDocValuesFormatTestCase.random().nextInt(4) > 0) {
                doc.add((IndexableField)storedBinField);
                doc.add((IndexableField)dvBinField);
                doc.add((IndexableField)dvSortedField);
            }
            if (BaseDocValuesFormatTestCase.random().nextInt(4) > 0) {
                doc.add((IndexableField)storedNumericField);
                doc.add((IndexableField)dvNumericField);
            }
            int numSortedSetFields = BaseDocValuesFormatTestCase.random().nextInt(3);
            TreeSet<String> values = new TreeSet<String>();
            for (int j = 0; j < numSortedSetFields; ++j) {
                values.add(TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random()));
            }
            for (String v : values) {
                doc.add((IndexableField)new SortedSetDocValuesField("dvSortedSet", new BytesRef((CharSequence)v)));
                doc.add((IndexableField)new StoredField("storedSortedSet", v));
            }
            int numSortedNumericFields = BaseDocValuesFormatTestCase.random().nextInt(3);
            TreeSet<Long> numValues = new TreeSet<Long>();
            for (int j = 0; j < numSortedNumericFields; ++j) {
                numValues.add(TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE));
            }
            for (Long l : numValues) {
                doc.add((IndexableField)new SortedNumericDocValuesField("dvSortedNumeric", l.longValue()));
                doc.add((IndexableField)new StoredField("storedSortedNumeric", Long.toString(l)));
            }
            writer.addDocument(doc);
            if (BaseDocValuesFormatTestCase.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = BaseDocValuesFormatTestCase.random().nextInt(numDocs / 10);
        for (int i = 0; i < numDeletions; ++i) {
            int id = BaseDocValuesFormatTestCase.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        writer.close();
        final DirectoryReader ir = DirectoryReader.open((Directory)dir);
        int numThreads = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 2, 7);
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch startingGun = new CountDownLatch(1);
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        startingGun.await();
                        for (LeafReaderContext context : ir.leaves()) {
                            LeafReader r = context.reader();
                            BinaryDocValues binaries = r.getBinaryDocValues("dvBin");
                            Bits binaryBits = r.getDocsWithField("dvBin");
                            SortedDocValues sorted = r.getSortedDocValues("dvSorted");
                            Bits sortedBits = r.getDocsWithField("dvSorted");
                            NumericDocValues numerics = r.getNumericDocValues("dvNum");
                            Bits numericBits = r.getDocsWithField("dvNum");
                            SortedSetDocValues sortedSet = r.getSortedSetDocValues("dvSortedSet");
                            Bits sortedSetBits = r.getDocsWithField("dvSortedSet");
                            SortedNumericDocValues sortedNumeric = r.getSortedNumericDocValues("dvSortedNumeric");
                            Bits sortedNumericBits = r.getDocsWithField("dvSortedNumeric");
                            for (int j = 0; j < r.maxDoc(); ++j) {
                                String[] values;
                                String number;
                                BytesRef binaryValue = r.document(j).getBinaryValue("storedBin");
                                if (binaryValue != null) {
                                    if (binaries != null) {
                                        BytesRef scratch = binaries.get(j);
                                        Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                        scratch = sorted.get(j);
                                        Assert.assertEquals((Object)binaryValue, (Object)scratch);
                                        Assert.assertTrue((boolean)binaryBits.get(j));
                                        Assert.assertTrue((boolean)sortedBits.get(j));
                                    }
                                } else if (binaries != null) {
                                    Assert.assertFalse((boolean)binaryBits.get(j));
                                    Assert.assertFalse((boolean)sortedBits.get(j));
                                    Assert.assertEquals((long)-1L, (long)sorted.getOrd(j));
                                }
                                if ((number = r.document(j).get("storedNum")) != null) {
                                    if (numerics != null) {
                                        Assert.assertEquals((long)Long.parseLong(number), (long)numerics.get(j));
                                    }
                                } else if (numerics != null) {
                                    Assert.assertFalse((boolean)numericBits.get(j));
                                    Assert.assertEquals((long)0L, (long)numerics.get(j));
                                }
                                if ((values = r.document(j).getValues("storedSortedSet")).length > 0) {
                                    Assert.assertNotNull((Object)sortedSet);
                                    sortedSet.setDocument(j);
                                    for (int k = 0; k < values.length; ++k) {
                                        long ord = sortedSet.nextOrd();
                                        Assert.assertTrue((ord != -1L ? 1 : 0) != 0);
                                        BytesRef value = sortedSet.lookupOrd(ord);
                                        Assert.assertEquals((Object)values[k], (Object)value.utf8ToString());
                                    }
                                    Assert.assertEquals((long)-1L, (long)sortedSet.nextOrd());
                                    Assert.assertTrue((boolean)sortedSetBits.get(j));
                                } else if (sortedSet != null) {
                                    sortedSet.setDocument(j);
                                    Assert.assertEquals((long)-1L, (long)sortedSet.nextOrd());
                                    Assert.assertFalse((boolean)sortedSetBits.get(j));
                                }
                                String[] numValues = r.document(j).getValues("storedSortedNumeric");
                                if (numValues.length > 0) {
                                    Assert.assertNotNull((Object)sortedNumeric);
                                    sortedNumeric.setDocument(j);
                                    Assert.assertEquals((long)numValues.length, (long)sortedNumeric.count());
                                    for (int k = 0; k < numValues.length; ++k) {
                                        long v = sortedNumeric.valueAt(k);
                                        Assert.assertEquals((Object)numValues[k], (Object)Long.toString(v));
                                    }
                                    Assert.assertTrue((boolean)sortedNumericBits.get(j));
                                    continue;
                                }
                                if (sortedNumeric == null) continue;
                                sortedNumeric.setDocument(j);
                                Assert.assertEquals((long)0L, (long)sortedNumeric.count());
                                Assert.assertFalse((boolean)sortedNumericBits.get(j));
                            }
                        }
                        TestUtil.checkReader((IndexReader)ir);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads[i].start();
        }
        startingGun.countDown();
        for (Thread t : threads) {
            t.join();
        }
        ir.close();
        dir.close();
    }

    @LuceneTestCase.Slow
    public void testThreads3() throws Exception {
        int i;
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support getDocsWithField", this.codecSupportsDocsWithField());
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newFSDirectory(BaseDocValuesFormatTestCase.createTempDir());
        IndexWriterConfig conf = BaseDocValuesFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseDocValuesFormatTestCase.random()));
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir, conf);
        int numSortedSets = BaseDocValuesFormatTestCase.random().nextInt(21);
        int numBinaries = BaseDocValuesFormatTestCase.random().nextInt(21);
        int numSortedNums = BaseDocValuesFormatTestCase.random().nextInt(21);
        int numDocs = TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 2025, 2047);
        for (i = 0; i < numDocs; ++i) {
            int j;
            Document doc = new Document();
            for (j = 0; j < numSortedSets; ++j) {
                doc.add((IndexableField)new SortedSetDocValuesField("ss" + j, new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random()))));
                doc.add((IndexableField)new SortedSetDocValuesField("ss" + j, new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random()))));
            }
            for (j = 0; j < numBinaries; ++j) {
                doc.add((IndexableField)new BinaryDocValuesField("b" + j, new BytesRef((CharSequence)TestUtil.randomSimpleString(BaseDocValuesFormatTestCase.random()))));
            }
            for (j = 0; j < numSortedNums; ++j) {
                doc.add((IndexableField)new SortedNumericDocValuesField("sn" + j, TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE)));
                doc.add((IndexableField)new SortedNumericDocValuesField("sn" + j, TestUtil.nextLong(BaseDocValuesFormatTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE)));
            }
            writer.addDocument(doc);
        }
        writer.close();
        for (i = 0; i < 10; ++i) {
            int tid;
            final DirectoryReader r = DirectoryReader.open((Directory)dir);
            final CountDownLatch startingGun = new CountDownLatch(1);
            Thread[] threads = new Thread[TestUtil.nextInt(BaseDocValuesFormatTestCase.random(), 4, 10)];
            for (tid = 0; tid < threads.length; ++tid) {
                threads[tid] = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
                            PrintStream infoStream = new PrintStream((OutputStream)bos, false, IOUtils.UTF_8);
                            startingGun.await();
                            for (LeafReaderContext leaf : r.leaves()) {
                                CheckIndex.Status.DocValuesStatus status = CheckIndex.testDocValues((CodecReader)((SegmentReader)leaf.reader()), (PrintStream)infoStream, (boolean)true);
                                if (status.error == null) continue;
                                throw status.error;
                            }
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            for (tid = 0; tid < threads.length; ++tid) {
                threads[tid].start();
            }
            startingGun.countDown();
            for (tid = 0; tid < threads.length; ++tid) {
                threads[tid].join();
            }
            r.close();
        }
        dir.close();
    }

    public void testEmptyBinaryValueOnPageSizes() throws Exception {
        for (int i = 0; i < 20 && (i <= 14 || this.codecAcceptsHugeBinaryValues("field")); ++i) {
            BaseDirectoryWrapper dir = BaseDocValuesFormatTestCase.newDirectory();
            RandomIndexWriter w = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)dir);
            BytesRef bytes = new BytesRef();
            bytes.bytes = new byte[1 << i];
            bytes.length = 1 << i;
            for (int j = 0; j < 4; ++j) {
                Document doc = new Document();
                doc.add((IndexableField)new BinaryDocValuesField("field", bytes));
                w.addDocument(doc);
            }
            Document doc = new Document();
            doc.add((IndexableField)new StoredField("id", "5"));
            doc.add((IndexableField)new BinaryDocValuesField("field", new BytesRef()));
            w.addDocument(doc);
            DirectoryReader r = w.getReader();
            w.close();
            LeafReader ar = SlowCompositeReaderWrapper.wrap((IndexReader)r);
            BinaryDocValues values = ar.getBinaryDocValues("field");
            for (int j = 0; j < 5; ++j) {
                BytesRef result = values.get(0);
                BaseDocValuesFormatTestCase.assertTrue((result.length == 0 || result.length == 1 << i ? 1 : 0) != 0);
            }
            ar.close();
            dir.close();
        }
    }

    public void testOneSortedNumber() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 5L));
        writer.addDocument(doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.count());
        BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.valueAt(0));
        reader.close();
        directory.close();
    }

    public void testOneSortedNumberOneMissing() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)directory, new IndexWriterConfig(null));
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 5L));
        writer.addDocument((Iterable)doc);
        writer.addDocument((Iterable)new Document());
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.count());
        BaseDocValuesFormatTestCase.assertEquals((long)5L, (long)dv.valueAt(0));
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.count());
        Bits docsWithField = ((LeafReaderContext)reader.leaves().get(0)).reader().getDocsWithField("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)docsWithField.length());
        BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(0));
        BaseDocValuesFormatTestCase.assertFalse((boolean)docsWithField.get(1));
        reader.close();
        directory.close();
    }

    public void testNumberMergeAwayAllValues() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("field", 5L));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        NumericDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getNumericDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.get(0));
        ireader.close();
        directory.close();
    }

    public void testTwoSortedNumber() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", -5L));
        writer.addDocument(doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.count());
        BaseDocValuesFormatTestCase.assertEquals((long)-5L, (long)dv.valueAt(0));
        BaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.valueAt(1));
        reader.close();
        directory.close();
    }

    public void testTwoSortedNumberSameValue() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        writer.addDocument(doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.count());
        BaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.valueAt(0));
        BaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.valueAt(1));
        reader.close();
        directory.close();
    }

    public void testTwoSortedNumberOneMissing() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)directory, new IndexWriterConfig(null));
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", -5L));
        writer.addDocument((Iterable)doc);
        writer.addDocument((Iterable)new Document());
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)dv.count());
        BaseDocValuesFormatTestCase.assertEquals((long)-5L, (long)dv.valueAt(0));
        BaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.valueAt(1));
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.count());
        Bits docsWithField = ((LeafReaderContext)reader.leaves().get(0)).reader().getDocsWithField("dv");
        BaseDocValuesFormatTestCase.assertEquals((long)2L, (long)docsWithField.length());
        BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(0));
        BaseDocValuesFormatTestCase.assertFalse((boolean)docsWithField.get(1));
        reader.close();
        directory.close();
    }

    public void testSortedNumberMerge() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        iwc.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        IndexWriter writer = new IndexWriter((Directory)directory, iwc);
        Document doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", 11L));
        writer.addDocument((Iterable)doc);
        writer.commit();
        doc = new Document();
        doc.add((IndexableField)new SortedNumericDocValuesField("dv", -5L));
        writer.addDocument((Iterable)doc);
        writer.forceMerge(1);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        assert (reader.leaves().size() == 1);
        SortedNumericDocValues dv = ((LeafReaderContext)reader.leaves().get(0)).reader().getSortedNumericDocValues("dv");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.count());
        BaseDocValuesFormatTestCase.assertEquals((long)11L, (long)dv.valueAt(0));
        dv.setDocument(1);
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)dv.count());
        BaseDocValuesFormatTestCase.assertEquals((long)-5L, (long)dv.valueAt(0));
        reader.close();
        directory.close();
    }

    public void testSortedNumberMergeAwayAllValues() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedNumericDocValuesField("field", 5L));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedNumericDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedNumericDocValues("field");
        dv.setDocument(0);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.count());
        ireader.close();
        directory.close();
    }

    public void testSortedEnumAdvanceIndependently() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        SortedDocValuesField field = new SortedDocValuesField("field", new BytesRef((CharSequence)"2"));
        doc.add((IndexableField)field);
        iwriter.addDocument(doc);
        field.setBytesValue(new BytesRef((CharSequence)"1"));
        iwriter.addDocument(doc);
        field.setBytesValue(new BytesRef((CharSequence)"3"));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedDocValues("field");
        this.doTestSortedSetEnumAdvanceIndependently((SortedSetDocValues)DocValues.singleton((SortedDocValues)dv));
        ireader.close();
        directory.close();
    }

    public void testSortedSetEnumAdvanceIndependently() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        SortedSetDocValuesField field1 = new SortedSetDocValuesField("field", new BytesRef((CharSequence)"2"));
        SortedSetDocValuesField field2 = new SortedSetDocValuesField("field", new BytesRef((CharSequence)"3"));
        doc.add((IndexableField)field1);
        doc.add((IndexableField)field2);
        iwriter.addDocument(doc);
        field1.setBytesValue(new BytesRef((CharSequence)"1"));
        iwriter.addDocument(doc);
        field2.setBytesValue(new BytesRef((CharSequence)"2"));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        this.doTestSortedSetEnumAdvanceIndependently(dv);
        ireader.close();
        directory.close();
    }

    protected void doTestSortedSetEnumAdvanceIndependently(SortedSetDocValues dv) throws IOException {
        if (dv.getValueCount() < 2L) {
            return;
        }
        ArrayList<BytesRef> terms = new ArrayList<BytesRef>();
        TermsEnum te = dv.termsEnum();
        terms.add(BytesRef.deepCopyOf((BytesRef)te.next()));
        terms.add(BytesRef.deepCopyOf((BytesRef)te.next()));
        TermsEnum enum1 = dv.termsEnum();
        TermsEnum enum2 = dv.termsEnum();
        BytesRefBuilder term1 = new BytesRefBuilder();
        BytesRefBuilder term2 = new BytesRefBuilder();
        term1.copyBytes(enum1.next());
        term2.copyBytes(enum2.next());
        term1.copyBytes(enum1.next());
        BaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        BytesRefBuilder seekTerm = new BytesRefBuilder();
        seekTerm.append((BytesRef)terms.get(0));
        seekTerm.append((byte)0);
        enum1.seekCeil(seekTerm.get());
        term1.copyBytes(enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        enum1.seekCeil((BytesRef)terms.get(1));
        term1.copyBytes(enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        boolean found = enum1.seekExact((BytesRef)terms.get(1));
        BaseDocValuesFormatTestCase.assertTrue((boolean)found);
        term1.copyBytes(enum1.term());
        enum1 = dv.termsEnum();
        enum2 = dv.termsEnum();
        term1 = new BytesRefBuilder();
        term2 = new BytesRefBuilder();
        term2.copyBytes(enum2.next());
        enum1.seekExact(1L);
        term1.copyBytes(enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term1.get(), (Object)enum1.term());
        BaseDocValuesFormatTestCase.assertEquals((Object)term2.get(), (Object)enum2.term());
    }

    public void testSortedMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedDocValues("field");
        for (int i = 0; i < numEmptyDocs; ++i) {
            if (this.codecSupportsDocsWithField()) {
                BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.getOrd(i));
                continue;
            }
            BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getOrd(i));
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)dv.lookupOrd(0));
        }
        ireader.close();
        directory.close();
    }

    public void testSortedSetMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_SET", this.codecSupportsSortedSet());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedSetDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedSetDocValues("field");
        for (int i = 0; i < numEmptyDocs; ++i) {
            dv.setDocument(i);
            BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.nextOrd());
        }
        ireader.close();
        directory.close();
    }

    public void testNumericMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("field", 42L));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        NumericDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getNumericDocValues("field");
        Bits docsWithField = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getDocsWithField("field");
        for (int i = 0; i < numEmptyDocs; ++i) {
            BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.get(i));
            if (this.codecSupportsDocsWithField()) {
                BaseDocValuesFormatTestCase.assertFalse((boolean)docsWithField.get(i));
                continue;
            }
            BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(i));
        }
        ireader.close();
        directory.close();
    }

    public void testSortedNumericMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDocValuesFormatTestCase.assumeTrue("Codec does not support SORTED_NUMERIC", this.codecSupportsSortedNumeric());
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new SortedNumericDocValuesField("field", 42L));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedNumericDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getSortedNumericDocValues("field");
        for (int i = 0; i < numEmptyDocs; ++i) {
            dv.setDocument(i);
            BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.count());
        }
        ireader.close();
        directory.close();
    }

    public void testBinaryMergeAwayAllValuesLargeSegment() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)new BinaryDocValuesField("field", new BytesRef((CharSequence)"hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        BinaryDocValues dv = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getBinaryDocValues("field");
        Bits docsWithField = BaseDocValuesFormatTestCase.getOnlySegmentReader(ireader).getDocsWithField("field");
        for (int i = 0; i < numEmptyDocs; ++i) {
            BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef(), (Object)dv.get(i));
            if (this.codecSupportsDocsWithField()) {
                BaseDocValuesFormatTestCase.assertFalse((boolean)docsWithField.get(i));
                continue;
            }
            BaseDocValuesFormatTestCase.assertTrue((boolean)docsWithField.get(i));
        }
        ireader.close();
        directory.close();
    }

    protected boolean codecAcceptsHugeBinaryValues(String field) {
        return true;
    }

    protected boolean codecSupportsDocsWithField() {
        return true;
    }

    protected boolean codecSupportsSortedSet() {
        return true;
    }

    protected boolean codecSupportsSortedNumeric() {
        return true;
    }

    static abstract class LongProducer {
        LongProducer() {
        }

        abstract long next();
    }
}

