/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.asserting.AssertingDocValuesFormat;
import org.apache.lucene.codecs.asserting.AssertingLiveDocsFormat;
import org.apache.lucene.codecs.asserting.AssertingNormsFormat;
import org.apache.lucene.codecs.asserting.AssertingPostingsFormat;
import org.apache.lucene.codecs.asserting.AssertingStoredFieldsFormat;
import org.apache.lucene.codecs.asserting.AssertingTermVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;
import org.apache.lucene.util.TestUtil;

public class AssertingCodec
extends FilterCodec {
    private final PostingsFormat postings = new PerFieldPostingsFormat(){

        public PostingsFormat getPostingsFormatForField(String field) {
            return AssertingCodec.this.getPostingsFormatForField(field);
        }
    };
    private final DocValuesFormat docValues = new PerFieldDocValuesFormat(){

        public DocValuesFormat getDocValuesFormatForField(String field) {
            return AssertingCodec.this.getDocValuesFormatForField(field);
        }
    };
    private final TermVectorsFormat vectors = new AssertingTermVectorsFormat();
    private final StoredFieldsFormat storedFields = new AssertingStoredFieldsFormat();
    private final NormsFormat norms = new AssertingNormsFormat();
    private final LiveDocsFormat liveDocs = new AssertingLiveDocsFormat();
    private final PostingsFormat defaultFormat = new AssertingPostingsFormat();
    private final DocValuesFormat defaultDVFormat = new AssertingDocValuesFormat();

    public AssertingCodec() {
        super("Asserting", TestUtil.getDefaultCodec());
    }

    public PostingsFormat postingsFormat() {
        return this.postings;
    }

    public TermVectorsFormat termVectorsFormat() {
        return this.vectors;
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFields;
    }

    public DocValuesFormat docValuesFormat() {
        return this.docValues;
    }

    public NormsFormat normsFormat() {
        return this.norms;
    }

    public LiveDocsFormat liveDocsFormat() {
        return this.liveDocs;
    }

    public String toString() {
        return "Asserting(" + this.delegate + ")";
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        return this.defaultFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.defaultDVFormat;
    }
}

