/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.NullInfoStream;
import org.apache.lucene.util.TestUtil;

public class RandomIndexWriter
implements Closeable {
    public IndexWriter w;
    private final Random r;
    int docCount;
    int flushAt;
    private double flushAtFactor = 1.0;
    private boolean getReaderCalled;
    private final Analyzer analyzer;
    private boolean doRandomForceMerge = true;
    private boolean doRandomForceMergeAssert = true;

    public static IndexWriter mockIndexWriter(Directory dir, IndexWriterConfig conf, Random r) throws IOException {
        final Random random = new Random(r.nextLong());
        return RandomIndexWriter.mockIndexWriter(r, dir, conf, new TestPoint(){

            @Override
            public void apply(String message) {
                if (random.nextInt(4) == 2) {
                    Thread.yield();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexWriter mockIndexWriter(Random r, Directory dir, IndexWriterConfig conf, TestPoint testPoint) throws IOException {
        IndexWriter iw;
        block7: {
            DirectoryReader reader;
            block8: {
                conf.setInfoStream((InfoStream)new TestPointInfoStream(conf.getInfoStream(), testPoint));
                reader = null;
                if (r.nextBoolean() && DirectoryReader.indexExists((Directory)dir) && conf.getOpenMode() != IndexWriterConfig.OpenMode.CREATE) {
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("RIW: open writer from reader");
                    }
                    reader = DirectoryReader.open((Directory)dir);
                    conf.setIndexCommit(reader.getIndexCommit());
                }
                boolean success = false;
                try {
                    iw = new IndexWriter(dir, conf);
                    success = true;
                    if (reader == null) break block7;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{reader});
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                        }
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{reader});
                break block7;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
        }
        iw.enableTestPoints = true;
        return iw;
    }

    public RandomIndexWriter(Random r, Directory dir) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, new MockAnalyzer(r)), true);
    }

    public RandomIndexWriter(Random r, Directory dir, Analyzer a) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, a));
    }

    public RandomIndexWriter(Random r, Directory dir, IndexWriterConfig c) throws IOException {
        this(r, dir, c, false);
    }

    private RandomIndexWriter(Random r, Directory dir, IndexWriterConfig c, boolean closeAnalyzer) throws IOException {
        this.r = new Random(r.nextLong());
        this.w = RandomIndexWriter.mockIndexWriter(dir, c, r);
        this.flushAt = TestUtil.nextInt(r, 10, 1000);
        this.analyzer = closeAnalyzer ? this.w.getAnalyzer() : null;
        if (LuceneTestCase.VERBOSE) {
            System.out.println("RIW dir=" + dir);
        }
        this.doRandomForceMerge = !(c.getMergePolicy() instanceof NoMergePolicy) && r.nextBoolean();
    }

    public <T extends IndexableField> void addDocument(final Iterable<T> doc) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        if (this.r.nextInt(5) == 3) {
            this.w.addDocuments(new Iterable<Iterable<T>>(){

                @Override
                public Iterator<Iterable<T>> iterator() {
                    return new Iterator<Iterable<T>>(){
                        boolean done;

                        @Override
                        public boolean hasNext() {
                            return !this.done;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Iterable<T> next() {
                            if (this.done) {
                                throw new IllegalStateException();
                            }
                            this.done = true;
                            return doc;
                        }
                    };
                }
            });
        } else {
            this.w.addDocument(doc);
        }
        this.maybeFlushOrCommit();
    }

    private void maybeFlushOrCommit() throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        if (this.docCount++ == this.flushAt) {
            if (this.r.nextBoolean()) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("RIW.add/updateDocument: now doing a flush at docCount=" + this.docCount);
                }
                this.w.flush();
            } else {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("RIW.add/updateDocument: now doing a commit at docCount=" + this.docCount);
                }
                this.w.commit();
            }
            this.flushAt += TestUtil.nextInt(this.r, (int)(this.flushAtFactor * 10.0), (int)(this.flushAtFactor * 1000.0));
            if (this.flushAtFactor < 2000000.0) {
                this.flushAtFactor *= 1.05;
            }
        }
    }

    public void addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.addDocuments(docs);
        this.maybeFlushOrCommit();
    }

    public void updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.updateDocuments(delTerm, docs);
        this.maybeFlushOrCommit();
    }

    public <T extends IndexableField> void updateDocument(Term t, final Iterable<T> doc) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        if (this.r.nextInt(5) == 3) {
            this.w.updateDocuments(t, new Iterable<Iterable<T>>(){

                @Override
                public Iterator<Iterable<T>> iterator() {
                    return new Iterator<Iterable<T>>(){
                        boolean done;

                        @Override
                        public boolean hasNext() {
                            return !this.done;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Iterable<T> next() {
                            if (this.done) {
                                throw new IllegalStateException();
                            }
                            this.done = true;
                            return doc;
                        }
                    };
                }
            });
        } else {
            this.w.updateDocument(t, doc);
        }
        this.maybeFlushOrCommit();
    }

    public void addIndexes(Directory ... dirs) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.addIndexes(dirs);
    }

    public void addIndexes(CodecReader ... readers) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.addIndexes(readers);
    }

    public void updateNumericDocValue(Term term, String field, Long value) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.updateNumericDocValue(term, field, value.longValue());
    }

    public void updateBinaryDocValue(Term term, String field, BytesRef value) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.updateBinaryDocValue(term, field, value);
    }

    public void updateDocValues(Term term, Field ... updates) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.updateDocValues(term, updates);
    }

    public void deleteDocuments(Term term) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.deleteDocuments(new Term[]{term});
    }

    public void deleteDocuments(Query q) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.deleteDocuments(new Query[]{q});
    }

    public void commit() throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.commit();
    }

    public int numDocs() {
        return this.w.numDocs();
    }

    public int maxDoc() {
        return this.w.maxDoc();
    }

    public void deleteAll() throws IOException {
        this.w.deleteAll();
    }

    public DirectoryReader getReader() throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        return this.getReader(true);
    }

    public void forceMergeDeletes(boolean doWait) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.forceMergeDeletes(doWait);
    }

    public void forceMergeDeletes() throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.forceMergeDeletes();
    }

    public void setDoRandomForceMerge(boolean v) {
        this.doRandomForceMerge = v;
    }

    public void setDoRandomForceMergeAssert(boolean v) {
        this.doRandomForceMergeAssert = v;
    }

    private void doRandomForceMerge() throws IOException {
        if (this.doRandomForceMerge) {
            int segCount = this.w.getSegmentCount();
            if (this.r.nextBoolean() || segCount == 0) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("RIW: doRandomForceMerge(1)");
                }
                this.w.forceMerge(1);
            } else if (this.r.nextBoolean()) {
                int limit = TestUtil.nextInt(this.r, 1, segCount);
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("RIW: doRandomForceMerge(" + limit + ")");
                }
                this.w.forceMerge(limit);
                assert (!this.doRandomForceMergeAssert || this.w.getSegmentCount() <= limit) : "limit=" + limit + " actual=" + this.w.getSegmentCount();
            } else {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("RIW: do random forceMergeDeletes()");
                }
                this.w.forceMergeDeletes();
            }
        }
    }

    public DirectoryReader getReader(boolean applyDeletions) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.getReaderCalled = true;
        if (this.r.nextInt(20) == 2) {
            this.doRandomForceMerge();
        }
        if (!applyDeletions || this.r.nextBoolean()) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("RIW.getReader: use NRT reader");
            }
            if (this.r.nextInt(5) == 1) {
                this.w.commit();
            }
            return this.w.getReader(applyDeletions);
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("RIW.getReader: open new reader");
        }
        this.w.commit();
        if (this.r.nextBoolean()) {
            return DirectoryReader.open((Directory)this.w.getDirectory());
        }
        return this.w.getReader(applyDeletions);
    }

    @Override
    public void close() throws IOException {
        if (!this.w.isClosed()) {
            LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        }
        if (!this.getReaderCalled && this.r.nextInt(8) == 2 && !this.w.isClosed()) {
            this.doRandomForceMerge();
            if (!this.w.getConfig().getCommitOnClose()) {
                this.w.commit();
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{this.w, this.analyzer});
    }

    public void forceMerge(int maxSegmentCount) throws IOException {
        LuceneTestCase.maybeChangeLiveIndexWriterConfig(this.r, this.w.getConfig());
        this.w.forceMerge(maxSegmentCount);
    }

    public final void flush() throws IOException {
        this.w.flush();
    }

    public static interface TestPoint {
        public void apply(String var1);
    }

    static final class TestPointInfoStream
    extends InfoStream {
        private final InfoStream delegate;
        private final TestPoint testPoint;

        public TestPointInfoStream(InfoStream delegate, TestPoint testPoint) {
            this.delegate = delegate == null ? new NullInfoStream() : delegate;
            this.testPoint = testPoint;
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public void message(String component, String message) {
            if ("TP".equals(component)) {
                this.testPoint.apply(message);
            }
            if (this.delegate.isEnabled(component)) {
                this.delegate.message(component, message);
            }
        }

        public boolean isEnabled(String component) {
            return "TP".equals(component) || this.delegate.isEnabled(component);
        }
    }
}

